/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.exec;

import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.rhq.core.util.UtilI18NResourceKeys;

public class ProcessToStart {
    private static final String PARAM_PROGRAM_TITLE = "programTitle";
    private static final String PARAM_PROGRAM_EXE = "programExecutable";
    private static final String PARAM_PROGRAM_DIR = "programDirectory";
    private static final String PARAM_ARGS = "arguments";
    private static final String PARAM_ENV = "environmentVariables";
    private static final String PARAM_WORKING_DIR = "workingDirectory";
    private static final String PARAM_OUTPUT_DIR = "outputDirectory";
    private static final String PARAM_OUTPUT_FILE = "outputFile";
    private static final String PARAM_OUTPUT_STREAM = "outputStream";
    private static final String PARAM_INPUT_DIR = "inputDirectory";
    private static final String PARAM_INPUT_FILE = "inputFile";
    private static final String PARAM_CAPTURE_OUTPUT = "captureOutput";
    private static final String PARAM_BACKUP_OUTPUT_FILE = "backupOutputFile";
    private static final String PARAM_WAIT_FOR_EXIT = "waitForExit";
    private static final String PARAM_KILL_ON_TIMEOUT = "killOnTimeout";
    private static final String PARAM_CHECK_EXECUTABLE_EXISTS = "checkExecutableExists";
    private Map<String, Object> map = new HashMap<String, Object>();
    private static final long serialVersionUID = 1L;

    public String getProgramTitle() {
        String title = (String)this.map.get(PARAM_PROGRAM_TITLE);
        if (title == null) {
            title = this.getProgramExecutable();
        }
        return title;
    }

    public void setProgramTitle(String value) {
        if (value != null) {
            this.map.put(PARAM_PROGRAM_TITLE, value);
        } else {
            this.map.remove(PARAM_PROGRAM_TITLE);
        }
    }

    public String getProgramExecutable() {
        return (String)this.map.get(PARAM_PROGRAM_EXE);
    }

    public void setProgramExecutable(String value) {
        this.map.put(PARAM_PROGRAM_EXE, value);
    }

    public String getProgramDirectory() {
        return (String)this.map.get(PARAM_PROGRAM_DIR);
    }

    public void setProgramDirectory(String value) {
        this.map.put(PARAM_PROGRAM_DIR, value);
    }

    public String[] getArguments() {
        return (String[])this.map.get(PARAM_ARGS);
    }

    public void setArguments(String[] value) {
        if (value != null) {
            this.map.put(PARAM_ARGS, value);
        } else {
            this.map.remove(PARAM_ARGS);
        }
    }

    public String[] getEnvironment() {
        return (String[])this.map.get(PARAM_ENV);
    }

    public String[] getEnvironment(Properties properties) throws IllegalArgumentException {
        if (properties == null) {
            throw new IllegalArgumentException("properties=null");
        }
        properties.clear();
        String[] envVarArray = this.getEnvironment();
        if (envVarArray != null) {
            for (int i = 0; i < envVarArray.length; ++i) {
                String envVarString = envVarArray[i];
                int equals = envVarString.indexOf(61);
                if (equals < 0) {
                    throw new IllegalArgumentException(UtilI18NResourceKeys.MSG.getMsg("ProcessToStart.env-var-bad-format", new Object[]{envVarString}));
                }
                properties.setProperty(envVarString.substring(0, equals), envVarString.substring(equals + 1));
            }
        }
        return envVarArray;
    }

    public void setEnvironment(String[] value) {
        this.map.put(PARAM_ENV, value);
    }

    public void setEnvironment(Properties value) {
        String[] env = null;
        if (value != null) {
            env = new String[value.size()];
            Enumeration<?> propNames = value.propertyNames();
            int i = 0;
            while (propNames.hasMoreElements()) {
                String propName = (String)propNames.nextElement();
                String propValue = value.getProperty(propName);
                env[i] = propName + "=" + propValue;
                ++i;
            }
        }
        this.setEnvironment(env);
    }

    public String getWorkingDirectory() {
        return (String)this.map.get(PARAM_WORKING_DIR);
    }

    public void setWorkingDirectory(String value) {
        this.map.put(PARAM_WORKING_DIR, value);
    }

    public String getOutputDirectory() {
        return (String)this.map.get(PARAM_OUTPUT_DIR);
    }

    public void setOutputDirectory(String value) {
        if (value != null) {
            this.map.put(PARAM_OUTPUT_DIR, value);
        } else {
            this.map.remove(PARAM_OUTPUT_DIR);
        }
    }

    public String getOutputFile() {
        return (String)this.map.get(PARAM_OUTPUT_FILE);
    }

    public void setOutputFile(String value) {
        if (value != null) {
            this.map.put(PARAM_OUTPUT_FILE, value);
        } else {
            this.map.remove(PARAM_OUTPUT_FILE);
        }
    }

    public OutputStream getOutputStream() {
        return (OutputStream)this.map.get(PARAM_OUTPUT_STREAM);
    }

    public void setOutputStream(OutputStream value) {
        if (value != null) {
            this.map.put(PARAM_OUTPUT_STREAM, value);
        } else {
            this.map.remove(PARAM_OUTPUT_STREAM);
        }
    }

    public String getInputDirectory() {
        return (String)this.map.get(PARAM_INPUT_DIR);
    }

    public void setInputDirectory(String value) {
        if (value != null) {
            this.map.put(PARAM_INPUT_DIR, value);
        } else {
            this.map.remove(PARAM_INPUT_DIR);
        }
    }

    public String getInputFile() {
        return (String)this.map.get(PARAM_INPUT_FILE);
    }

    public void setInputFile(String value) {
        if (value != null) {
            this.map.put(PARAM_INPUT_FILE, value);
        } else {
            this.map.remove(PARAM_INPUT_FILE);
        }
    }

    public Long getWaitForExit() {
        Long waitTimeout = (Long)this.map.get(PARAM_WAIT_FOR_EXIT);
        if (waitTimeout == null) {
            waitTimeout = 0L;
        }
        return waitTimeout;
    }

    public void setWaitForExit(Long value) {
        if (value != null) {
            this.map.put(PARAM_WAIT_FOR_EXIT, value);
        } else {
            this.map.remove(PARAM_WAIT_FOR_EXIT);
        }
    }

    public Boolean isCaptureOutput() {
        Boolean flag = (Boolean)this.map.get(PARAM_CAPTURE_OUTPUT);
        if (flag == null) {
            flag = Boolean.FALSE;
        }
        return flag;
    }

    public void setCaptureOutput(Boolean value) {
        if (value != null) {
            this.map.put(PARAM_CAPTURE_OUTPUT, value);
        } else {
            this.map.remove(PARAM_CAPTURE_OUTPUT);
        }
    }

    public Boolean isBackupOutputFile() {
        return (Boolean)this.map.get(PARAM_BACKUP_OUTPUT_FILE);
    }

    public void setBackupOutputFile(Boolean value) {
        if (value != null) {
            this.map.put(PARAM_BACKUP_OUTPUT_FILE, value);
        } else {
            this.map.remove(PARAM_BACKUP_OUTPUT_FILE);
        }
    }

    public Boolean isKillOnTimeout() {
        Boolean flag = (Boolean)this.map.get(PARAM_KILL_ON_TIMEOUT);
        if (flag == null) {
            flag = Boolean.FALSE;
        }
        return flag;
    }

    public void setKillOnTimeout(Boolean value) {
        if (value != null) {
            this.map.put(PARAM_KILL_ON_TIMEOUT, value);
        } else {
            this.map.remove(PARAM_KILL_ON_TIMEOUT);
        }
    }

    public Boolean isCheckExecutableExists() {
        Boolean flag = (Boolean)this.map.get(PARAM_CHECK_EXECUTABLE_EXISTS);
        if (flag == null) {
            flag = Boolean.TRUE;
        }
        return flag;
    }

    public void setCheckExecutableExists(Boolean value) {
        if (value != null) {
            this.map.put(PARAM_CHECK_EXECUTABLE_EXISTS, value);
        } else {
            this.map.remove(PARAM_CHECK_EXECUTABLE_EXISTS);
        }
    }
}

