/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.rhq.core.util.StringUtil;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.helper.ServerPluginConfiguration;

public class ASUploadConnection {
    private static final Log LOG = LogFactory.getLog(ASUploadConnection.class);
    private static final int SOCKET_CONNECTION_TIMEOUT = 30000;
    private static final int SOCKET_READ_TIMEOUT = 60000;
    private static final String TRIGGER_AUTH_URI = "/management";
    private static final String UPLOAD_URI = "/management/add-content";
    private static final int FILE_POST_MAX_LOGGABLE_RESPONSE_LENGTH = 2048;
    private static final String EMPTY_JSON_TREE = "{}";
    private static final String JSON_NODE_FAILURE_DESCRIPTION = "failure-description";
    private static final String JSON_NODE_FAILURE_DESCRIPTION_VALUE_DEFAULT = "FailureDescription: -input was null-";
    private static final String JSON_NODE_OUTCOME = "outcome";
    private static final String JSON_NODE_OUTCOME_VALUE_FAILED = "failed";
    private static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    private String scheme = "http";
    private String host;
    private int port;
    private UsernamePasswordCredentials credentials;
    private String fileName;
    private int timeout;
    private File cacheFile;
    private BufferedOutputStream cacheOutputStream;

    @Deprecated
    public ASUploadConnection(String host, int port, String user, String password) {
        this(host, port, user, password, null);
    }

    public ASUploadConnection(String host, int port, String user, String password, String fileName) {
        if (host == null) {
            throw new IllegalArgumentException("Management host cannot be null.");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port: " + port);
        }
        if (StringUtil.isBlank((String)fileName)) {
            throw new IllegalArgumentException("Filename cannot be blank");
        }
        this.host = host;
        this.port = port;
        if (user != null && password != null) {
            this.credentials = new UsernamePasswordCredentials(user, password);
        }
        this.fileName = fileName;
        this.timeout = 60000;
    }

    @Deprecated
    public ASUploadConnection(ASConnection asConnection) {
        this(asConnection.getHost(), asConnection.getPort(), asConnection.getUser(), asConnection.getPassword(), null);
    }

    public ASUploadConnection(ASConnection asConnection, String fileName) {
        this(asConnection.getHost(), asConnection.getPort(), asConnection.getUser(), asConnection.getPassword(), fileName);
    }

    public static ASUploadConnection newInstanceForServerPluginConfiguration(ServerPluginConfiguration pluginConfig, String fileName) {
        return new ASUploadConnection(pluginConfig.getHostname(), pluginConfig.getPort(), pluginConfig.getUser(), pluginConfig.getPassword(), fileName);
    }

    @Deprecated
    public OutputStream getOutputStream(String fileName) {
        this.fileName = fileName;
        return this.getOutputStream();
    }

    public OutputStream getOutputStream() {
        try {
            this.cacheFile = File.createTempFile(this.getClass().getSimpleName(), ".cache");
            this.cacheOutputStream = new BufferedOutputStream(new FileOutputStream(this.cacheFile));
            return this.cacheOutputStream;
        }
        catch (IOException e) {
            LOG.error((Object)("Could not create outputstream for " + this.fileName), (Throwable)e);
            return null;
        }
    }

    public void cancelUpload() {
        this.closeQuietly(this.cacheOutputStream);
        this.deleteCacheFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode finishUpload() {
        if (this.fileName == null) {
            throw new IllegalStateException("Upload fileName is null");
        }
        this.closeQuietly(this.cacheOutputStream);
        BasicClientConnectionManager httpConnectionManager = new BasicClientConnectionManager();
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)httpConnectionManager);
        HttpParams httpParams = httpClient.getParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)30000);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.timeout);
        if (this.credentials != null) {
            httpClient.getCredentialsProvider().setCredentials(new AuthScope(this.host, this.port), (Credentials)this.credentials);
        }
        String triggerAuthUrl = this.scheme + "://" + this.host + ":" + this.port + TRIGGER_AUTH_URI;
        HttpGet triggerAuthRequest = new HttpGet(triggerAuthUrl);
        try {
            httpClient.execute((HttpUriRequest)triggerAuthRequest);
        }
        catch (Exception ignore) {
        }
        finally {
            triggerAuthRequest.abort();
        }
        String uploadURL = this.scheme + "://" + this.host + ":" + this.port + UPLOAD_URI;
        HttpPost uploadRequest = new HttpPost(uploadURL);
        try {
            MultipartEntity multipartEntity = new MultipartEntity();
            multipartEntity.addPart(this.fileName, (ContentBody)new FileBody(this.cacheFile));
            uploadRequest.setEntity((HttpEntity)multipartEntity);
            HttpResponse uploadResponse = httpClient.execute((HttpUriRequest)uploadRequest);
            if (uploadResponse.getStatusLine().getStatusCode() != 200) {
                this.logUploadDoesNotEndWithHttpOkStatus(uploadResponse);
                JsonNode jsonNode = null;
                return jsonNode;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            InputStream responseBodyAsStream = uploadResponse.getEntity().getContent();
            if (responseBodyAsStream == null) {
                LOG.warn((Object)"POST request has no response body");
                JsonNode jsonNode = objectMapper.readTree(EMPTY_JSON_TREE);
                return jsonNode;
            }
            JsonNode jsonNode = objectMapper.readTree(responseBodyAsStream);
            return jsonNode;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            JsonNode jsonNode = null;
            return jsonNode;
        }
        finally {
            uploadRequest.abort();
            httpConnectionManager.shutdown();
            this.deleteCacheFile();
        }
    }

    public static String getFailureDescription(JsonNode jsonNode) {
        if (jsonNode == null) {
            return JSON_NODE_FAILURE_DESCRIPTION_VALUE_DEFAULT;
        }
        JsonNode node = jsonNode.findValue(JSON_NODE_FAILURE_DESCRIPTION);
        if (node == null) {
            return JSON_NODE_FAILURE_DESCRIPTION_VALUE_DEFAULT;
        }
        return node.getValueAsText();
    }

    public static boolean isErrorReply(JsonNode jsonNode) {
        if (jsonNode == null) {
            return true;
        }
        if (jsonNode.has(JSON_NODE_OUTCOME)) {
            String outcome = null;
            try {
                JsonNode outcomeNode = jsonNode.findValue(JSON_NODE_OUTCOME);
                outcome = outcomeNode.getTextValue();
                if (outcome.equals(JSON_NODE_OUTCOME_VALUE_FAILED)) {
                    return true;
                }
            }
            catch (Exception e) {
                LOG.error((Object)e);
                return true;
            }
        }
        return false;
    }

    private boolean credentialsProvided() {
        return this.credentials != null;
    }

    private void logUploadDoesNotEndWithHttpOkStatus(HttpResponse uploadResponse) {
        StringBuilder logMessageBuilder = new StringBuilder("File upload failed: ").append(ASConnection.statusAsString(uploadResponse.getStatusLine()));
        if (uploadResponse.getEntity().getContentLength() > 0L && uploadResponse.getEntity().getContentLength() < 2048L) {
            try {
                String responseBodyAsString = EntityUtils.toString((HttpEntity)uploadResponse.getEntity());
                logMessageBuilder.append(SYSTEM_LINE_SEPARATOR).append(responseBodyAsString);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOG.warn((Object)logMessageBuilder.toString());
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteCacheFile() {
        if (this.cacheFile != null) {
            this.cacheFile.delete();
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

