/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.SubsystemDiscovery;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.rhq.modules.plugins.jbossas7.modcluster.ProxyInfo;

public class ModClusterContextDiscoveryComponent
extends SubsystemDiscovery {
    private final Log log = LogFactory.getLog(this.getClass());
    private static Log staticLogger = LogFactory.getLog(ModClusterContextDiscoveryComponent.class);
    private final String PROXY_INFO_OPERATION = "read-proxies-info";
    private final String CONFIGURATION = ",mod-cluster-config=configuration";
    private static String jvmRoute = null;

    @Override
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<BaseComponent<?>> context) {
        HashSet<DiscoveredResourceDetails> entities = new HashSet<DiscoveredResourceDetails>();
        if (jvmRoute == null) {
            jvmRoute = "";
        }
        String rawProxyInfo = "";
        BaseComponent parentComponent = (BaseComponent)context.getParentResourceComponent();
        ASConnection connection = parentComponent.getASConnection();
        String path = parentComponent.getPath();
        int located = -1;
        located = path.indexOf(",mod-cluster-config=configuration");
        if (located > -1) {
            path = path.substring(0, located);
        }
        if (path == null || path.isEmpty()) {
            this.log.error((Object)("Path plugin config is null for ResourceType [" + context.getResourceType().getName() + "]."));
            return entities;
        }
        Address addr = new Address(path);
        Operation op = new Operation("read-proxies-info", addr);
        Result result = connection.execute(op);
        rawProxyInfo = ModClusterContextDiscoveryComponent.extractRawProxyInfo(result);
        ProxyInfo proxyInfo = new ProxyInfo(rawProxyInfo);
        for (ProxyInfo.Context availableContext : proxyInfo.getAvailableContexts()) {
            if (!availableContext.getJvmRoute().equals(jvmRoute)) continue;
            String resourceKey = path + ":" + availableContext.createKey();
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(context.getResourceType(), resourceKey, availableContext.createName(), null, "Webapp Context", null, null);
            entities.add(detail);
        }
        return entities;
    }

    static String extractRawProxyInfo(Result result) {
        String rawProxyInfo = "";
        if (result != null && result.isSuccess()) {
            if (!(result.getResult() instanceof ArrayList)) {
                staticLogger.warn((Object)"Attempting to extract proxyInfo but JSON type information is not correct.");
                return rawProxyInfo;
            }
            ArrayList container = (ArrayList)result.getResult();
            if (container != null && !container.isEmpty()) {
                Object type = container.get(0);
                String values = "";
                values = type instanceof String ? values + container.get(1) : container.toString();
                rawProxyInfo = values;
            }
        }
        return rawProxyInfo;
    }
}

