/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.Map;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class NamingComponent
extends BaseComponent
implements OperationFacet {
    @Override
    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        OperationResult result = new OperationResult();
        if (name.equals("jndi-view")) {
            Address address = new Address(this.path);
            Operation operation = new Operation("jndi-view", address);
            Result res = this.getASConnection().execute(operation);
            if (!res.isSuccess()) {
                result.setErrorMessage(res.getFailureDescription());
                return result;
            }
            Configuration config = result.getComplexResults();
            Map contexts = (Map)res.getResult();
            String entryName = "java: contexts";
            Map javaContexts = (Map)contexts.get(entryName);
            PropertyList javaContextsMap = this.fillMap(javaContexts, "java-contexts", false);
            config.put((Property)javaContextsMap);
            entryName = "applications";
            Map applications = (Map)contexts.get(entryName);
            PropertyList applicationsMap = this.fillMap(applications, entryName, true);
            config.put((Property)applicationsMap);
            return result;
        }
        return super.invokeOperation(name, parameters);
    }

    private PropertyList fillMap(Map<String, Map> contexts, String name, boolean isAppCtx) {
        PropertyList pl = new PropertyList(name);
        if (contexts == null) {
            return pl;
        }
        for (String entry : contexts.keySet()) {
            Map map = contexts.get(entry);
            if (map == null) continue;
            for (String innerkey : map.keySet()) {
                PropertyMap pm = new PropertyMap(name);
                pm.put((Property)new PropertySimple("context", (Object)entry));
                pm.put((Property)new PropertySimple("name", (Object)innerkey));
                Object val = map.get(innerkey);
                if (val != null) {
                    Map cvmap;
                    if (isAppCtx) {
                        cvmap = (Map)val;
                        if (cvmap.containsKey("AppName")) {
                            Map nameMap = (Map)cvmap.get("AppName");
                            pm.put((Property)new PropertySimple("value", nameMap.get("value")));
                        } else {
                            pm.put((Property)new PropertySimple("value", (Object)val.toString()));
                        }
                    } else {
                        cvmap = (Map)val;
                        String clazz = (String)cvmap.get("class-name");
                        String value = (String)cvmap.get("value");
                        pm.put((Property)new PropertySimple("value", (Object)(clazz + "=" + value)));
                    }
                }
                pl.add((Property)pm);
            }
        }
        return pl;
    }
}

