/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;

public class DomainConfigurationEditor {
    public static String updateXML(Configuration config, String xmlToEdit) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(xmlToEdit));
            Element root = doc.getRootElement();
            root.setAttribute("type", config.getSimple("type").getStringValue());
            DomainConfigurationEditor.updateSimpleNode(config, root, "name");
            DomainConfigurationEditor.updateSimpleNode(config, root, "uuid");
            DomainConfigurationEditor.updateSimpleNode(config, root, "memory");
            DomainConfigurationEditor.updateSimpleNode(config, root, "currentMemory");
            DomainConfigurationEditor.updateSimpleNode(config, root, "vcpu");
            DomainConfigurationEditor.updateSimpleNode(config, root, "on_poweroff");
            DomainConfigurationEditor.updateSimpleNode(config, root, "on_reboot");
            DomainConfigurationEditor.updateSimpleNode(config, root, "on_crash");
            XMLOutputter outputter = new XMLOutputter();
            outputter.getFormat().setIndent("    ");
            outputter.getFormat().setLineSeparator("\n");
            return outputter.outputString(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void updateSimpleNode(Configuration config, Element parent, String name) {
        Element e = parent.getChild(name);
        e.setText(config.getSimple(name).getStringValue());
    }

    public static String getXml(Configuration config) {
        Document doc = new Document();
        Element root = new Element("domain");
        doc.setRootElement(root);
        root.setAttribute("type", config.getSimple("type").getStringValue());
        DomainConfigurationEditor.addSimpleNode(config, root, "name");
        DomainConfigurationEditor.addSimpleNode(config, root, "uuid");
        DomainConfigurationEditor.addSimpleNode(config, root, "memory");
        DomainConfigurationEditor.addSimpleNode(config, root, "currentMemory");
        DomainConfigurationEditor.addSimpleNode(config, root, "vcpu");
        DomainConfigurationEditor.addSimpleNode(config, root, "on_poweroff");
        DomainConfigurationEditor.addSimpleNode(config, root, "on_reboot");
        DomainConfigurationEditor.addSimpleNode(config, root, "on_crash");
        Element devices = new Element("devices");
        root.addContent((Content)devices);
        PropertyList interfaces = config.getList("interfaces");
        for (Property intf : interfaces.getList()) {
            PropertyMap intfMap = (PropertyMap)intf;
            Element intfElement = new Element("interface");
            devices.addContent((Content)intfElement);
            intfElement.setAttribute("type", intfMap.getSimple("type").getStringValue());
            Element sourceElement = new Element("source");
            intfElement.addContent((Content)sourceElement);
            sourceElement.setAttribute("bridge", intfMap.getSimple("source").getStringValue());
            Element targetElement = new Element("target");
            intfElement.addContent((Content)targetElement);
            targetElement.setAttribute("dev", intfMap.getSimple("target").getStringValue());
            Element macElement = new Element("mac");
            intfElement.addContent((Content)macElement);
            macElement.setAttribute("address", intfMap.getSimple("mac").getStringValue());
            Element scriptElement = new Element("script");
            intfElement.addContent((Content)scriptElement);
            scriptElement.setAttribute("path", intfMap.getSimple("script").getStringValue());
        }
        PropertyList disks = config.getList("disks");
        for (Property disk : disks.getList()) {
            PropertyMap diskMap = (PropertyMap)disk;
            Element diskElement = new Element("disk");
            devices.addContent((Content)diskElement);
            diskElement.setAttribute("type", diskMap.getSimple("type").getStringValue());
            Element sourceElement = new Element("driver");
            diskElement.addContent((Content)sourceElement);
            sourceElement.setAttribute("name", diskMap.getSimple("driverName").getStringValue());
            Element targetElement = new Element("source");
            diskElement.addContent((Content)targetElement);
            targetElement.setAttribute("file", diskMap.getSimple("sourceFile").getStringValue());
            Element macElement = new Element("target");
            diskElement.addContent((Content)macElement);
            macElement.setAttribute("dev", diskMap.getSimple("targetDevice").getStringValue());
        }
        XMLOutputter outputter = new XMLOutputter();
        outputter.getFormat().setIndent("    ");
        outputter.getFormat().setLineSeparator("\n");
        return outputter.outputString(doc);
    }

    private static void addSimpleNode(Configuration config, Element parent, String name) {
        Element e = new Element(name);
        e.setText(config.getSimple(name).getStringValue());
        parent.addContent((Content)e);
    }

    public static Configuration getConfiguration(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(xml));
            Configuration config = new Configuration();
            Element root = doc.getRootElement();
            String type = root.getAttribute("type").getValue();
            config.put((Property)new PropertySimple("type", (Object)type));
            DomainConfigurationEditor.addChildTextSimpleProperty(config, root, "name");
            DomainConfigurationEditor.addChildTextSimpleProperty(config, root, "uuid");
            DomainConfigurationEditor.addChildTextSimpleProperty(config, root, "memory");
            DomainConfigurationEditor.addChildTextSimpleProperty(config, root, "currentMemory");
            DomainConfigurationEditor.addChildTextSimpleProperty(config, root, "vcpu");
            DomainConfigurationEditor.addChildTextSimpleProperty(config, root, "on_poweroff");
            DomainConfigurationEditor.addChildTextSimpleProperty(config, root, "on_reboot");
            DomainConfigurationEditor.addChildTextSimpleProperty(config, root, "on_crash");
            Element devices = root.getChild("devices");
            PropertyList interfaces = new PropertyList("interfaces");
            config.put((Property)interfaces);
            List interfaceElementList = devices.getChildren("interface");
            for (Element interfaceElement : interfaceElementList) {
                PropertyMap intf = new PropertyMap("interface");
                String iType = interfaceElement.getAttribute("type").getValue();
                intf.put((Property)new PropertySimple("type", (Object)iType));
                String macAddress = interfaceElement.getChild("mac").getAttribute("address").getValue();
                intf.put((Property)new PropertySimple("macAddress", (Object)macAddress));
                String targetDevice = interfaceElement.getChild("target").getAttribute("dev").getValue();
                intf.put((Property)new PropertySimple("target", (Object)targetDevice));
                String source = interfaceElement.getChild("source").getAttribute("bridge").getValue();
                intf.put((Property)new PropertySimple("source", (Object)source));
                String scriptPath = interfaceElement.getChild("script").getAttribute("path").getValue();
                intf.put((Property)new PropertySimple("script", (Object)scriptPath));
                interfaces.add((Property)intf);
            }
            PropertyList disks = new PropertyList("disks");
            config.put((Property)disks);
            List diskElementList = devices.getChildren("disk");
            for (Element diskElement : diskElementList) {
                Element source;
                PropertyMap disk = new PropertyMap("disk");
                Attribute diskType = diskElement.getAttribute("type");
                String dType = diskType != null ? diskType.getValue() : "block";
                disk.put((Property)new PropertySimple("type", (Object)dType));
                Element driver = diskElement.getChild("driver");
                if (driver != null) {
                    String driverName = driver.getAttribute("name").getValue();
                    disk.put((Property)new PropertySimple("driverName", (Object)driverName));
                }
                if ((source = diskElement.getChild("source")) != null) {
                    String sourceFile = source.getAttributeValue("file");
                    disk.put((Property)new PropertySimple("sourceFile", (Object)sourceFile));
                }
                String targetDevice = diskElement.getChild("target").getAttributeValue("dev");
                disk.put((Property)new PropertySimple("targetDevice", (Object)targetDevice));
                disks.add((Property)disk);
            }
            return config;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static void addChildTextSimpleProperty(Configuration config, Element root, String property) {
        String val = root.getChildText(property);
        config.put((Property)new PropertySimple(property, (Object)val));
    }

    public static void main(String[] args) throws JDOMException, IOException {
        String xml = "<domain type='xen' id='6'>\n  <name>ghvirt1</name>\n  <uuid>81731cbe-009c-0f8c-772a-46c9a345a4c4</uuid>\n  <bootloader>/usr/bin/pygrub</bootloader>\n  <os>\n    <type>linux</type>\n  </os>\n  <memory>819200</memory>\n  <currentMemory>512000</currentMemory>\n  <vcpu>1</vcpu>\n  <on_poweroff>destroy</on_poweroff>\n  <on_reboot>restart</on_reboot>\n  <on_crash>restart</on_crash>\n  <devices>\n    <interface type='bridge'>\n      <source bridge='virbr0'/>\n      <target dev='vif6.0'/>\n      <mac address='00:16:3e:5e:ef:b6'/>\n      <script path='vif-bridge'/>\n    </interface>\n    <disk type='file' device='disk'>\n      <driver name='file'/>\n      <source file='/home/ghinkle/ghvirt1'/>\n      <target dev='xvda'/>\n    </disk>\n    <input type='mouse' bus='xen'/>\n    <graphics type='vnc' port='5900'/>\n    <console tty='/dev/pts/4'/>\n  </devices>\n</domain>";
        Configuration c = DomainConfigurationEditor.getConfiguration(xml);
        for (Property p : c.getProperties()) {
            if (!(p instanceof PropertySimple)) continue;
            System.out.println(p.getName() + " = " + ((PropertySimple)p).getStringValue());
        }
        System.out.println("-------------------------");
        System.out.println(xml);
        System.out.println("-------------------------");
        c.getSimple("currentMemory").setIntegerValue(Integer.valueOf(768000));
        System.out.println(DomainConfigurationEditor.updateXML(c, xml));
    }
}

