/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.virt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.virt.LibVirtConnection;

public class VirtualizationDomainDiscoveryComponent
implements ResourceDiscoveryComponent {
    private Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext resourceDiscoveryContext) throws InvalidPluginConfigurationException, Exception {
        int[] ids;
        HashSet<DiscoveredResourceDetails> details = new HashSet<DiscoveredResourceDetails>();
        String uri = resourceDiscoveryContext.getParentResourceContext().getPluginConfiguration().getSimpleValue("connectionURI", "");
        LibVirtConnection virt = null;
        try {
            virt = new LibVirtConnection(uri);
        }
        catch (Throwable t) {
            this.log.warn((Object)String.format("Can not load native library for libvirt with uri '%s'. Message is '%s'.: ", uri, t.getMessage()), t);
            return details;
        }
        List<String> guests = null;
        try {
            ids = virt.getDomainIds();
            guests = virt.getDomainNames();
        }
        catch (Exception e) {
            this.log.info((Object)("Failure obtaining domains from libvirt: " + e.getMessage()));
            return details;
        }
        for (int id : ids) {
            LibVirtConnection.DomainInfo domainInfo = virt.getDomainInfo(id);
            details.add(this.createResource(resourceDiscoveryContext.getResourceType(), domainInfo));
        }
        for (String guestName : guests) {
            if (guestName == null) continue;
            LibVirtConnection.DomainInfo domainInfo = virt.getDomainInfo(guestName);
            details.add(this.createResource(resourceDiscoveryContext.getResourceType(), domainInfo));
        }
        virt.close();
        return details;
    }

    public DiscoveredResourceDetails createResource(ResourceType resourceType, LibVirtConnection.DomainInfo domainInfo) {
        DiscoveredResourceDetails detail = new DiscoveredResourceDetails(resourceType, domainInfo.name, domainInfo.name, null, "Guest Named " + domainInfo.name, null, null);
        return detail;
    }
}

