/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.IOException;
import org.apache.commons.httpclient.NameValuePair;
import org.richfaces.test.LocalWebResponse;
import org.richfaces.test.staging.HttpMethod;
import org.richfaces.test.staging.StagingConnection;
import org.richfaces.test.staging.StagingServer;

public final class LocalWebConnection
implements WebConnection {
    private final StagingServer localServer;

    public LocalWebConnection(StagingServer localServer) {
        this.localServer = localServer;
    }

    public WebResponse getResponse(WebRequestSettings settings) throws IOException {
        StagingConnection connection = this.localServer.getConnection(settings.getUrl());
        for (NameValuePair param : settings.getRequestParameters()) {
            connection.addRequestParameter(param.getName(), param.getValue());
        }
        HttpMethod httpMethod = HttpMethod.valueOf(settings.getHttpMethod().toString());
        connection.setRequestMethod(httpMethod);
        connection.setRequestCharacterEncoding(settings.getCharset());
        String body = settings.getRequestBody();
        String contentType = settings.getEncodingType().getName();
        connection.setRequestBody(body);
        connection.setRequestContentType(contentType);
        connection.addRequestHeaders(settings.getAdditionalHeaders());
        if (null != body && FormEncodingType.URL_ENCODED.getName().equals(contentType)) {
            connection.parseFormParameters(body);
        }
        long startTime = System.currentTimeMillis();
        connection.execute();
        return new LocalWebResponse(settings, connection, System.currentTimeMillis() - startTime);
    }
}

