/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test;

import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebRequestSettings;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.richfaces.test.staging.StagingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalWebResponse
implements WebResponse {
    private WebRequestSettings settings;
    private final StagingConnection serverConnection;
    private final long loadTime;

    public LocalWebResponse(StagingConnection serverConnection, long l) {
        this.serverConnection = serverConnection;
        this.loadTime = l;
    }

    public LocalWebResponse(WebRequestSettings settings, StagingConnection connection, long l) {
        this(connection, l);
        this.settings = settings;
    }

    public InputStream getContentAsStream() throws IOException {
        return new ByteArrayInputStream(this.getResponseBody());
    }

    public String getContentAsString() {
        return this.serverConnection.getContentAsString();
    }

    public String getContentCharSet() {
        return this.serverConnection.getResponseCharacterEncoding();
    }

    public String getContentType() {
        return this.serverConnection.getResponseContentType();
    }

    public long getLoadTimeInMilliSeconds() {
        return this.loadTime;
    }

    public HttpMethod getRequestMethod() {
        return HttpMethod.valueOf((String)this.serverConnection.getRequestMethod().toString());
    }

    public WebRequestSettings getRequestSettings() {
        if (this.settings == null) {
            this.settings = new WebRequestSettings(this.getUrl(), this.getRequestMethod());
        }
        return this.settings;
    }

    public byte[] getResponseBody() {
        return this.serverConnection.getResponseBody();
    }

    public String getResponseHeaderValue(String headerName) {
        String[] values = this.serverConnection.getResponseHeaders().get(headerName);
        if (null != values && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public int getStatusCode() {
        return this.serverConnection.getResponseStatus();
    }

    public String getStatusMessage() {
        return this.serverConnection.getErrorMessage();
    }

    public URL getUrl() {
        return this.serverConnection.getUrl();
    }

    public List<NameValuePair> getResponseHeaders() {
        ArrayList<NameValuePair> headers = new ArrayList<NameValuePair>(10);
        for (Map.Entry<String, String[]> entry : this.serverConnection.getResponseHeaders().entrySet()) {
            for (String value : entry.getValue()) {
                headers.add(new NameValuePair(entry.getKey(), value));
            }
        }
        int contentLength = this.serverConnection.getResponseContentLength();
        if (contentLength >= 0) {
            headers.add(new NameValuePair("Content-Length", String.valueOf(contentLength)));
        }
        return headers;
    }

    public byte[] getContentAsBytes() {
        return this.serverConnection.getResponseBody();
    }

    public String getContentAsString(String encoding) {
        String content;
        byte[] body = this.serverConnection.getResponseBody();
        try {
            content = new String(body, encoding);
        }
        catch (UnsupportedEncodingException e) {
            content = new String(body);
        }
        return content;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public URL getRequestUrl() {
        return this.serverConnection.getUrl();
    }
}

