/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test.staging;

import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.richfaces.test.TestException;
import org.richfaces.test.staging.AbstractServerResource;
import org.richfaces.test.staging.ServerLogger;

public class ClasspathServerResource
extends AbstractServerResource {
    private final String classpath;
    private volatile URL url = null;
    private static final Logger log = ServerLogger.RESOURCE.getLogger();

    public ClasspathServerResource(String classpath) {
        this.classpath = classpath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getURL() {
        if (this.url == null) {
            ClasspathServerResource classpathServerResource = this;
            synchronized (classpathServerResource) {
                ClassLoader classLoader;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("get classpath resource from " + this.classpath);
                }
                if (null == (classLoader = Thread.currentThread().getContextClassLoader())) {
                    classLoader = this.getClass().getClassLoader();
                }
                this.url = classLoader.getResource(this.classpath);
                if (null == this.url) {
                    throw new TestException("Virtual server resource can't be loaded from " + this.classpath);
                }
            }
        }
        return this.url;
    }
}

