/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test.staging;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.richfaces.test.staging.RequestChain;
import org.richfaces.test.staging.ServerLogger;

public class FilterContainer
implements RequestChain {
    private static final Logger log = ServerLogger.SERVER.getLogger();
    private final Filter filter;
    private final RequestChain next;
    private String name = "Default";
    private final Map<String, String> initParameters;
    private boolean initialized = false;

    public FilterContainer(Filter filter, RequestChain next) {
        if (null == filter || null == next) {
            throw new NullPointerException();
        }
        this.filter = filter;
        this.next = next;
        this.initParameters = new HashMap<String, String>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.initialized) {
            throw new IllegalStateException("Filter have already been initialized, name can't be changed");
        }
        this.name = name;
    }

    public void execute(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Filter " + this.getName() + " have not been initialized, could'n execute request");
        }
        log.finest("Request '" + request + "' executes by the '" + this.getName() + "' filter");
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                FilterContainer.this.next.execute(request, response);
            }
        };
        this.filter.doFilter(request, response, chain);
    }

    public void addInitParameter(String name, String value) {
        if (this.initialized) {
            throw new IllegalStateException("Filter have already been initialized, init parameters can't be changed");
        }
        this.initParameters.put(name, value);
    }

    public boolean isApplicable(String path) {
        return this.next.isApplicable(path);
    }

    public void destroy() {
        if (this.initialized) {
            this.next.destroy();
            this.filter.destroy();
            this.initialized = false;
        }
    }

    public void init(final ServletContext context) throws ServletException {
        if (!this.initialized) {
            this.filter.init(new FilterConfig(){

                public String getFilterName() {
                    return FilterContainer.this.name;
                }

                public String getInitParameter(String name) {
                    return (String)FilterContainer.this.initParameters.get(name);
                }

                public Enumeration getInitParameterNames() {
                    return Collections.enumeration(FilterContainer.this.initParameters.keySet());
                }

                public ServletContext getServletContext() {
                    return context;
                }
            });
            this.next.init(context);
            this.initialized = true;
        }
    }

    public String getPathInfo(String path) {
        return this.next.getPathInfo(path);
    }

    public String getServletPath(String path) {
        return this.next.getServletPath(path);
    }
}

