/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test.staging;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.richfaces.test.staging.RequestChain;
import org.richfaces.test.staging.ServerLogger;

public class ServletContainer
implements RequestChain {
    private static final Logger log = ServerLogger.SERVER.getLogger();
    private final Servlet servlet;
    private final boolean prefixMapped;
    private final String mapping;
    private final Map<String, String> initParameters;
    private String name = "Default";
    private boolean initialized = false;

    public ServletContainer(String mapping, Servlet servlet) {
        if (null == servlet) {
            throw new NullPointerException();
        }
        if (null == mapping) {
            this.prefixMapped = true;
            this.mapping = "";
        } else if (mapping.startsWith("*")) {
            this.prefixMapped = false;
            this.mapping = mapping.substring(1);
        } else if (mapping.endsWith("*")) {
            this.prefixMapped = true;
            this.mapping = mapping.substring(0, mapping.length() - 1);
        } else {
            throw new IllegalArgumentException("Invalid mapping " + mapping);
        }
        this.servlet = servlet;
        this.initParameters = new HashMap<String, String>();
    }

    public void addInitParameter(String name, String value) {
        if (this.initialized) {
            throw new IllegalStateException("Servlet have already been initialized, init parameters can't be changed");
        }
        this.initParameters.put(name, value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.initialized) {
            throw new IllegalStateException("Servlet have already been initialized, name can't be changed");
        }
        this.name = name;
    }

    public boolean isApplicable(String path) {
        if (this.prefixMapped && path.startsWith(this.mapping)) {
            return true;
        }
        return !this.prefixMapped && path.endsWith(this.mapping);
    }

    public String getServletPath(String path) {
        if (!this.isApplicable(path)) {
            return null;
        }
        if (this.prefixMapped) {
            return this.mapping;
        }
        return path;
    }

    public String getPathInfo(String path) {
        if (!this.isApplicable(path)) {
            return null;
        }
        if (this.prefixMapped) {
            return path.substring(this.mapping.length());
        }
        return null;
    }

    public void init(final ServletContext context) throws ServletException {
        if (!this.initialized) {
            log.finest("Initialize servlet " + this.getName());
            this.servlet.init(new ServletConfig(){

                public String getInitParameter(String name) {
                    return (String)ServletContainer.this.initParameters.get(name);
                }

                public Enumeration getInitParameterNames() {
                    return Collections.enumeration(ServletContainer.this.initParameters.keySet());
                }

                public ServletContext getServletContext() {
                    return context;
                }

                public String getServletName() {
                    return ServletContainer.this.name;
                }
            });
            this.initialized = true;
        }
    }

    public void execute(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Servlet " + this.getName() + " have not been initialized, could'n execute request");
        }
        log.finest("Request '" + request + "' executes by the '" + this.getName() + "' servlet");
        this.servlet.service(request, response);
    }

    public void destroy() {
        if (this.initialized) {
            this.servlet.destroy();
            this.initialized = false;
        }
    }
}

