/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test.staging;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.richfaces.test.staging.NotImplementedException;
import org.richfaces.test.staging.ServerLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StagingHttpRequest
implements HttpServletRequest {
    private static final Logger log = ServerLogger.CONNECTION.getLogger();
    public static final String LOCALHOST = "localhost";
    public static final String HTTP = "http";
    public static final String LOCALHOST_IP = "127.0.0.1";
    public static final String UTF8 = "UTF-8";
    private String requestBody = null;
    private String contentType;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Map<String, String> headers = new HashMap<String, String>();
    private Collection<Locale> locales = Arrays.asList(Locale.US, Locale.GERMANY);
    private String characterEncoding = "UTF-8";

    StagingHttpRequest() {
    }

    String getRequestBody() {
        return this.requestBody;
    }

    void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getAuthType() {
        log.info("unimplemented request method getAuthType");
        return null;
    }

    public String getContextPath() {
        return "";
    }

    public long getDateHeader(String name) {
        String value = this.headers.get(name);
        if (null != value) {
            try {
                return DateFormat.getDateInstance(0, this.getLocale()).parse(value).getTime();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        return -1L;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Enumeration getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public Enumeration getHeaders(String name) {
        String value = this.headers.get(name);
        Set<Object> values = null != value ? Collections.singleton(value) : Collections.emptySet();
        return Collections.enumeration(values);
    }

    public int getIntHeader(String name) {
        String value = this.headers.get(name);
        if (null != value) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    void addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    public String getPathTranslated() {
        return null;
    }

    public String getRemoteUser() {
        log.info("unimplemented request method getRemoteUser");
        return null;
    }

    public StringBuffer getRequestURL() {
        StringBuffer requestURL = new StringBuffer("http://localhost" + this.getRequestURI());
        return requestURL;
    }

    public String getRequestedSessionId() {
        return "1234567890";
    }

    public Principal getUserPrincipal() {
        log.info("unimplemented request method getUserPrincipal");
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return true;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return true;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isUserInRole(String role) {
        log.info("unimplemented request method isUserInRole");
        return false;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        String body = this.getRequestBody();
        return null == body ? -1 : body.length();
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        String body = this.getRequestBody();
        if (null != body) {
            final ByteArrayInputStream input = new ByteArrayInputStream(body.getBytes(this.getCharacterEncoding()));
            return new ServletInputStream(){

                public int read() throws IOException {
                    return input.read();
                }
            };
        }
        return null;
    }

    public String getLocalAddr() {
        return LOCALHOST_IP;
    }

    public String getLocalName() {
        return LOCALHOST;
    }

    public int getLocalPort() {
        return 80;
    }

    public Locale getLocale() {
        return Locale.US;
    }

    public Enumeration getLocales() {
        return Collections.enumeration(this.locales);
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public BufferedReader getReader() throws IOException {
        String body = this.getRequestBody();
        if (null != body) {
            return new BufferedReader(new StringReader(body));
        }
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public String getRemoteAddr() {
        return LOCALHOST_IP;
    }

    public String getRemoteHost() {
        return LOCALHOST;
    }

    public int getRemotePort() {
        return 1223340;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new NotImplementedException();
    }

    public String getScheme() {
        return HTTP;
    }

    public String getServerName() {
        return LOCALHOST;
    }

    public int getServerPort() {
        return 80;
    }

    public boolean isSecure() {
        return false;
    }

    public void removeAttribute(String name) {
        Object removed = this.attributes.remove(name);
        if (null != removed) {
            this.attributeRemoved(name, removed);
        }
    }

    protected abstract void attributeRemoved(String var1, Object var2);

    public void setAttribute(String name, Object o) {
        if (null == o) {
            this.removeAttribute(name);
        } else {
            Object oldValue = this.attributes.put(name, o);
            if (null != oldValue) {
                this.attributeReplaced(name, o);
            } else {
                this.attributeAdded(name, o);
            }
        }
    }

    protected abstract void attributeAdded(String var1, Object var2);

    protected abstract void attributeReplaced(String var1, Object var2);

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        if (!Charset.isSupported(env)) {
            throw new UnsupportedEncodingException("Unknown charset " + env);
        }
        this.characterEncoding = env;
    }
}

