/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.test.staging;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.naming.NamingException;
import javax.naming.spi.NamingManager;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import javax.servlet.jsp.JspFactory;
import org.richfaces.test.TestException;
import org.richfaces.test.staging.ClasspathServerResource;
import org.richfaces.test.staging.EventInvoker;
import org.richfaces.test.staging.InvocationErrorEvent;
import org.richfaces.test.staging.InvocationEvent;
import org.richfaces.test.staging.InvocationListener;
import org.richfaces.test.staging.RequestChain;
import org.richfaces.test.staging.ServerLogger;
import org.richfaces.test.staging.ServerResource;
import org.richfaces.test.staging.ServerResourcePath;
import org.richfaces.test.staging.ServerResourcesDirectory;
import org.richfaces.test.staging.ServletContainer;
import org.richfaces.test.staging.StaggingJspFactory;
import org.richfaces.test.staging.StagingConnection;
import org.richfaces.test.staging.StagingHttpSession;
import org.richfaces.test.staging.StagingInitialContextFactoryBuilder;
import org.richfaces.test.staging.StagingServletContext;
import org.richfaces.test.staging.StaticServlet;
import org.richfaces.test.staging.UrlServerResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StagingServer {
    private static final Class<ServletRequestListener> REQUEST_LISTENER_CLASS = ServletRequestListener.class;
    private static final Class<ServletRequestAttributeListener> REQUEST_ATTRIBUTE_LISTENER_CLASS = ServletRequestAttributeListener.class;
    private static final Class<ServletContextListener> CONTEXT_LISTENER_CLASS = ServletContextListener.class;
    private static final Class<HttpSessionListener> SESSION_LISTENER_CLASS = HttpSessionListener.class;
    private static final Class<HttpSessionAttributeListener> SESSION_ATTRIBUTE_LISTENER_CLASS = HttpSessionAttributeListener.class;
    private static final Logger log = ServerLogger.SERVER.getLogger();
    private final List<RequestChain> servlets = new ArrayList<RequestChain>();
    private RequestChain defaultServlet = new ServletContainer(null, (Servlet)new StaticServlet());
    private final List<EventListener> contextListeners = new ArrayList<EventListener>();
    private final Map<String, String> initParameters = new HashMap<String, String>();
    private final ServerResource serverRoot = new ServerResourcesDirectory();
    private final Map<String, String> mimeTypes = new HashMap<String, String>();
    private InvocationListener invocationListener;
    private final StagingServletContext context = new LocalContext();
    private ServletContext contextProxy;
    private HttpSession currentSession = null;
    private ThreadLocal<HttpSession> sessions = new ThreadLocal();
    private List<ServerHttpSession> sessionInstances = new ArrayList<ServerHttpSession>();
    private boolean sessionPerThread = false;
    private boolean initialised = false;

    private <T extends EventListener> void fireEvent(Class<T> listenerClass, EventInvoker<T> invoker) {
        for (EventListener listener : this.contextListeners) {
            if (!listenerClass.isInstance(listener)) continue;
            invoker.invoke(listener);
        }
    }

    public void addServlet(RequestChain servlet) {
        this.servlets.add(servlet);
    }

    public void addServlet(String mapping, Servlet servlet) {
        this.servlets.add(new ServletContainer(mapping, servlet));
    }

    public RequestChain getServlet(String path) {
        RequestChain result = null;
        for (RequestChain servlet : this.servlets) {
            if (!servlet.isApplicable(path)) continue;
            result = servlet;
            break;
        }
        if (null == result) {
            try {
                URL resource = this.context.getResource(path);
                if (null != resource) {
                    result = this.defaultServlet;
                }
            }
            catch (MalformedURLException e) {
                log.warning("Mailformed request URL " + e.getMessage());
            }
        }
        return result;
    }

    public void addInitParameter(String name, String value) {
        this.initParameters.put(name, value);
    }

    public void addMimeType(String extension, String mimeType) {
        this.mimeTypes.put(extension, mimeType);
    }

    public void addResource(String path, String resource) {
        ServerResourcePath resourcePath = new ServerResourcePath(path);
        this.serverRoot.addResource(resourcePath, new ClasspathServerResource(resource));
    }

    public void addResource(String path, URL resource) {
        this.serverRoot.addResource(new ServerResourcePath(path), new UrlServerResource(resource));
    }

    public void addResourcesFromDirectory(String path, URL resource) {
        String protocol;
        ServerResourcePath resourcePath = new ServerResourcePath(path);
        ServerResource baseDirectory = this.serverRoot.getResource(resourcePath);
        if (null == baseDirectory) {
            baseDirectory = new ServerResourcesDirectory();
            this.serverRoot.addResource(resourcePath, baseDirectory);
        }
        if ("jar".equals(protocol = resource.getProtocol())) {
            this.addResourcesFromJar(resource, baseDirectory);
        } else if ("file".equals(protocol)) {
            this.addResourcesFromFile(resource, baseDirectory);
        } else {
            throw new TestException("Unsupported protocol " + protocol);
        }
    }

    public void addResourcesFromDirectory(String path, File directory) {
        ServerResourcePath resourcePath = new ServerResourcePath(path);
        ServerResource baseDirectory = this.serverRoot.getResource(resourcePath);
        if (null == baseDirectory) {
            baseDirectory = new ServerResourcesDirectory();
            this.serverRoot.addResource(resourcePath, baseDirectory);
        }
        if (!directory.isDirectory()) {
            directory = directory.getParentFile();
        }
        if (!directory.exists()) {
            throw new TestException("directory does not exist:" + directory.getAbsolutePath());
        }
        try {
            this.addFiles(baseDirectory, directory);
        }
        catch (MalformedURLException e) {
            throw new TestException(e);
        }
    }

    protected void addResourcesFromFile(URL resource, ServerResource baseDirectory) {
        File file = new File(resource.getPath());
        if (!file.isDirectory()) {
            file = file.getParentFile();
        }
        try {
            this.addFiles(baseDirectory, file);
        }
        catch (MalformedURLException e) {
            throw new TestException(e);
        }
    }

    protected void addResourcesFromJar(URL resource, ServerResource baseDirectory) {
        try {
            String jarPath = resource.getPath();
            String entry = jarPath.substring(jarPath.indexOf(33) + 2);
            jarPath = jarPath.substring(0, jarPath.indexOf(33));
            File file = new File(new URI(jarPath));
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            entry = entry.substring(0, entry.lastIndexOf(47) + 1);
            while (entries.hasMoreElements()) {
                ZipEntry zzz = entries.nextElement();
                if (!zzz.getName().startsWith(entry) || zzz.isDirectory()) continue;
                String relativePath = zzz.getName().substring(entry.length());
                URL relativeResource = new URL(resource, relativePath);
                baseDirectory.addResource(new ServerResourcePath("/" + relativePath), new UrlServerResource(relativeResource));
            }
        }
        catch (IOException e) {
            throw new TestException("Error read Jar content", e);
        }
        catch (URISyntaxException e) {
            throw new TestException(e);
        }
    }

    protected void addFiles(ServerResource baseDirectory, File file) throws MalformedURLException {
        File[] files;
        for (File subfile : files = file.listFiles()) {
            ServerResourcePath serverResourcePath;
            if (subfile.isDirectory()) {
                serverResourcePath = new ServerResourcePath("/" + subfile.getName() + "/");
                ServerResourcesDirectory subDir = new ServerResourcesDirectory();
                baseDirectory.addResource(serverResourcePath, subDir);
                this.addFiles(subDir, subfile);
                continue;
            }
            serverResourcePath = new ServerResourcePath("/" + subfile.getName());
            UrlServerResource resource = new UrlServerResource(subfile.toURL());
            baseDirectory.addResource(serverResourcePath, resource);
        }
    }

    public void addWebListener(EventListener listener) {
        this.contextListeners.add(listener);
    }

    public InvocationListener getInvocationListener() {
        return this.invocationListener;
    }

    public void setInvocationListener(InvocationListener invocationListener) {
        this.invocationListener = invocationListener;
    }

    InvocationHandler getInvocationHandler(final Object target) {
        return new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                InvocationListener listener = StagingServer.this.getInvocationListener();
                try {
                    Object result = method.invoke(target, args);
                    if (null != listener) {
                        listener.afterInvoke(new InvocationEvent(target, method, args, result));
                    }
                    return result;
                }
                catch (Throwable e) {
                    if (null != listener) {
                        listener.processException(new InvocationErrorEvent(target, method, args, e));
                    }
                    throw e;
                }
            }
        };
    }

    public boolean isSessionPerThread() {
        return this.sessionPerThread;
    }

    public void setSessionPerThread(boolean sessionPerThread) {
        this.sessionPerThread = sessionPerThread;
    }

    HttpSession getCurrentSession() {
        if (this.isSessionPerThread()) {
            return this.sessions.get();
        }
        return this.currentSession;
    }

    void setCurrentSession(HttpSession session) {
        if (this.isSessionPerThread()) {
            this.sessions.set(session);
        } else {
            this.currentSession = session;
        }
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public synchronized HttpSession getSession(boolean create) {
        if (!this.initialised) {
            throw new TestException("Staging server have not been initialised");
        }
        HttpSession httpSession = this.getCurrentSession();
        if (null == httpSession && create) {
            ServerHttpSession sessionImpl = new ServerHttpSession();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (null == loader) {
                loader = this.getClass().getClassLoader();
            }
            httpSession = (HttpSession)Proxy.newProxyInstance(loader, new Class[]{HttpSession.class}, this.getInvocationHandler(sessionImpl));
            this.setCurrentSession(httpSession);
            final HttpSessionEvent event = new HttpSessionEvent(httpSession);
            this.fireEvent(SESSION_LISTENER_CLASS, new EventInvoker<HttpSessionListener>(){

                @Override
                public void invoke(HttpSessionListener listener) {
                    listener.sessionCreated(event);
                }
            });
            this.sessionInstances.add(sessionImpl);
        }
        return httpSession;
    }

    public void init() {
        log.info("Init staging server");
        JspFactory.setDefaultFactory((JspFactory)new StaggingJspFactory(this.context));
        this.context.addInitParameters(this.initParameters);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (null == loader) {
            loader = this.getClass().getClassLoader();
        }
        this.contextProxy = (ServletContext)Proxy.newProxyInstance(loader, new Class[]{ServletContext.class}, this.getInvocationHandler(this.context));
        final ServletContextEvent event = new ServletContextEvent((ServletContext)this.context);
        this.fireEvent(CONTEXT_LISTENER_CLASS, new EventInvoker<ServletContextListener>(){

            @Override
            public void invoke(ServletContextListener listener) {
                listener.contextInitialized(event);
            }
        });
        try {
            for (RequestChain servlet : this.servlets) {
                servlet.init(this.context);
            }
            this.defaultServlet.init(this.context);
        }
        catch (ServletException e) {
            throw new TestException("Servlet initialisation error ", e);
        }
        try {
            NamingManager.setInitialContextFactoryBuilder(new StagingInitialContextFactoryBuilder());
        }
        catch (NamingException e) {
            log.warning("Error set initial context factory builder.");
        }
        catch (IllegalStateException e) {
            log.warning("Initial context factory builder already set.");
        }
        this.initialised = true;
    }

    public void destroy() {
        if (!this.initialised) {
            throw new TestException("Staging server have not been initialised");
        }
        this.initialised = false;
        Iterator<ServerHttpSession> sessionIterator = this.sessionInstances.iterator();
        while (sessionIterator.hasNext()) {
            ServerHttpSession session = sessionIterator.next();
            final HttpSessionEvent event = new HttpSessionEvent((HttpSession)session);
            this.fireEvent(SESSION_LISTENER_CLASS, new EventInvoker<HttpSessionListener>(){

                @Override
                public void invoke(HttpSessionListener listener) {
                    listener.sessionDestroyed(event);
                }
            });
            session.invalidate();
            sessionIterator.remove();
        }
        this.setCurrentSession(null);
        final ServletContextEvent event = new ServletContextEvent((ServletContext)this.context);
        this.fireEvent(CONTEXT_LISTENER_CLASS, new EventInvoker<ServletContextListener>(){

            @Override
            public void invoke(ServletContextListener listener) {
                listener.contextDestroyed(event);
            }
        });
        for (RequestChain servlet : this.servlets) {
            servlet.destroy();
        }
        this.defaultServlet.destroy();
        JspFactory.setDefaultFactory(null);
        this.contextProxy = null;
        log.info("Staging server have been destroyed");
    }

    public StagingConnection getConnection(URL url) {
        if (!this.initialised) {
            throw new TestException("Staging server have not been initialised");
        }
        return new StagingConnection(this, url);
    }

    public ServletContext getContext() {
        if (!this.initialised) {
            throw new TestException("Staging server have not been initialised");
        }
        return this.contextProxy;
    }

    void requestStarted(ServletRequest request) {
        final ServletRequestEvent event = new ServletRequestEvent((ServletContext)this.context, request);
        this.fireEvent(REQUEST_LISTENER_CLASS, new EventInvoker<ServletRequestListener>(){

            @Override
            public void invoke(ServletRequestListener listener) {
                listener.requestInitialized(event);
            }
        });
    }

    void requestFinished(ServletRequest request) {
        final ServletRequestEvent event = new ServletRequestEvent((ServletContext)this.context, request);
        this.fireEvent(REQUEST_LISTENER_CLASS, new EventInvoker<ServletRequestListener>(){

            @Override
            public void invoke(ServletRequestListener listener) {
                listener.requestDestroyed(event);
            }
        });
    }

    void requestAttributeAdded(ServletRequest request, String name, Object o) {
        final ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.context, request, name, o);
        this.fireEvent(REQUEST_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<ServletRequestAttributeListener>(){

            @Override
            public void invoke(ServletRequestAttributeListener listener) {
                listener.attributeAdded(event);
            }
        });
    }

    void requestAttributeRemoved(ServletRequest request, String name, Object removed) {
        final ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.context, request, name, removed);
        this.fireEvent(REQUEST_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<ServletRequestAttributeListener>(){

            @Override
            public void invoke(ServletRequestAttributeListener listener) {
                listener.attributeRemoved(event);
            }
        });
    }

    void requestAttributeReplaced(ServletRequest request, String name, Object value) {
        final ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this.context, request, name, value);
        this.fireEvent(REQUEST_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<ServletRequestAttributeListener>(){

            @Override
            public void invoke(ServletRequestAttributeListener listener) {
                listener.attributeReplaced(event);
            }
        });
    }

    private class ServerHttpSession
    extends StagingHttpSession {
        private ServerHttpSession() {
        }

        public ServletContext getServletContext() {
            return StagingServer.this.context;
        }

        protected void valueBound(final HttpSessionBindingEvent sessionBindingEvent) {
            StagingServer.this.fireEvent(SESSION_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<HttpSessionAttributeListener>(){

                @Override
                public void invoke(HttpSessionAttributeListener listener) {
                    listener.attributeAdded(sessionBindingEvent);
                }
            });
        }

        protected void valueUnbound(final HttpSessionBindingEvent sessionBindingEvent) {
            StagingServer.this.fireEvent(SESSION_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<HttpSessionAttributeListener>(){

                @Override
                public void invoke(HttpSessionAttributeListener listener) {
                    listener.attributeRemoved(sessionBindingEvent);
                }
            });
        }

        protected void valueReplaced(final HttpSessionBindingEvent sessionBindingEvent) {
            StagingServer.this.fireEvent(SESSION_ATTRIBUTE_LISTENER_CLASS, new EventInvoker<HttpSessionAttributeListener>(){

                @Override
                public void invoke(HttpSessionAttributeListener listener) {
                    listener.attributeReplaced(sessionBindingEvent);
                }
            });
        }

        public void invalidate() {
            super.invalidate();
            StagingServer.this.setCurrentSession(null);
        }
    }

    private class LocalContext
    extends StagingServletContext {
        private LocalContext() {
        }

        public String getMimeType(String file) {
            int indexOfDot = file.lastIndexOf(46);
            if (indexOfDot >= 0) {
                file = file.substring(indexOfDot);
            }
            return (String)StagingServer.this.mimeTypes.get(file);
        }

        protected void valueBound(ServletContextAttributeEvent event) {
            for (EventListener listener : StagingServer.this.contextListeners) {
                if (!(listener instanceof ServletContextAttributeListener)) continue;
                ServletContextAttributeListener contextListener = (ServletContextAttributeListener)listener;
                contextListener.attributeAdded(event);
            }
        }

        protected void valueReplaced(ServletContextAttributeEvent event) {
            for (EventListener listener : StagingServer.this.contextListeners) {
                if (!(listener instanceof ServletContextAttributeListener)) continue;
                ServletContextAttributeListener contextListener = (ServletContextAttributeListener)listener;
                contextListener.attributeReplaced(event);
            }
        }

        protected void valueUnbound(ServletContextAttributeEvent event) {
            for (EventListener listener : StagingServer.this.contextListeners) {
                if (!(listener instanceof ServletContextAttributeListener)) continue;
                ServletContextAttributeListener contextListener = (ServletContextAttributeListener)listener;
                contextListener.attributeRemoved(event);
            }
        }

        protected ServerResource getServerResource(String path) {
            return StagingServer.this.serverRoot.getResource(new ServerResourcePath(path));
        }
    }
}

