/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.ajax4jsf.io.FastBufferInputStream;
import org.ajax4jsf.io.FastBufferOutputStream;
import org.ajax4jsf.io.FastBufferReader;
import org.ajax4jsf.io.FastBufferWriter;

public class Test {
    static int ARRAY_LENGTH = 27;
    static int READ_OFF = 4;
    static int READ_LENGTH = 22;
    static boolean BUILD_STRING = false;
    static boolean OUT_STRING = true;

    static void testStreams() throws IOException {
        int i;
        String s = "This is a senseless text to test streams.\n";
        for (int i2 = 0; i2 < 10; ++i2) {
            s = s + s;
        }
        byte[] bytes = s.getBytes();
        FastBufferOutputStream output = new FastBufferOutputStream(16);
        for (i = 0; i < 4; ++i) {
            output.write(bytes);
        }
        for (i = 0; i < bytes.length; ++i) {
            output.write(bytes[i]);
        }
        FastBufferInputStream input = new FastBufferInputStream(output);
        StringBuffer sb = new StringBuffer();
        byte[] bs = new byte[ARRAY_LENGTH];
        int l = 0;
        while ((l = input.read(bs, READ_OFF, READ_LENGTH)) >= 0) {
            if (!BUILD_STRING) continue;
            sb.append(new String(bs, READ_OFF, l));
        }
        if (BUILD_STRING && OUT_STRING) {
            System.out.println(sb);
            System.out.println("Length=" + output.getLength());
        }
    }

    static void testStandardStreams() throws IOException {
        int i;
        String s = "This is a senseless text to test streams.\n";
        for (int i2 = 0; i2 < 10; ++i2) {
            s = s + s;
        }
        byte[] bytes = s.getBytes();
        ByteArrayOutputStream output = new ByteArrayOutputStream(16);
        for (i = 0; i < 4; ++i) {
            output.write(bytes);
        }
        for (i = 0; i < bytes.length; ++i) {
            output.write(bytes[i]);
        }
        ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());
        StringBuffer sb = new StringBuffer();
        byte[] bs = new byte[ARRAY_LENGTH];
        int l = 0;
        while ((l = input.read(bs, READ_OFF, READ_LENGTH)) >= 0) {
            if (!BUILD_STRING) continue;
            sb.append(new String(bs, READ_OFF, l));
        }
        if (BUILD_STRING && OUT_STRING) {
            System.out.println(sb);
        }
    }

    static void testReaders() throws IOException {
        int i;
        String s = "This is a senseless text to test readers.\n";
        for (int i2 = 0; i2 < 10; ++i2) {
            s = s + s;
        }
        char[] bytes = s.toCharArray();
        FastBufferWriter output = new FastBufferWriter(16);
        for (i = 0; i < 4; ++i) {
            output.write(bytes);
        }
        for (i = 0; i < bytes.length; ++i) {
            output.write(bytes[i]);
        }
        FastBufferReader input = new FastBufferReader(output);
        StringBuffer sb = new StringBuffer();
        char[] bs = new char[ARRAY_LENGTH];
        int l = 0;
        while ((l = input.read(bs, READ_OFF, READ_LENGTH)) >= 0) {
            if (!BUILD_STRING) continue;
            sb.append(new String(bs, READ_OFF, l));
        }
        if (BUILD_STRING && OUT_STRING) {
            System.out.println(sb);
        }
    }

    static void testStandardReaders() throws IOException {
        int i;
        String s = "This is a senseless text to test readers.\n";
        for (int i2 = 0; i2 < 10; ++i2) {
            s = s + s;
        }
        char[] bytes = s.toCharArray();
        StringWriter output = new StringWriter(16);
        for (i = 0; i < 4; ++i) {
            output.write(bytes);
        }
        for (i = 0; i < bytes.length; ++i) {
            output.write(bytes[i]);
        }
        StringReader input = new StringReader(output.toString());
        StringBuffer sb = new StringBuffer();
        char[] bs = new char[ARRAY_LENGTH];
        int l = 0;
        while ((l = input.read(bs, READ_OFF, READ_LENGTH)) >= 0) {
            if (!BUILD_STRING) continue;
            sb.append(new String(bs, READ_OFF, l));
        }
        if (BUILD_STRING && OUT_STRING) {
            System.out.println(sb);
        }
    }

    static void testTransitionFromWriterToStream() throws IOException {
        int i;
        String s = "This is a senseless text to test transform from writer to stream.\n";
        for (int i2 = 0; i2 < 10; ++i2) {
            s = s + s;
        }
        char[] bytes = s.toCharArray();
        FastBufferWriter output = new FastBufferWriter(16);
        for (i = 0; i < 4; ++i) {
            output.write(bytes);
        }
        for (i = 0; i < bytes.length; ++i) {
            output.write(bytes[i]);
        }
        FastBufferOutputStream output2 = output.convertToOutputStream("UTF-8");
        FastBufferInputStream input = new FastBufferInputStream(output2);
        StringBuffer sb = new StringBuffer();
        byte[] bs = new byte[ARRAY_LENGTH];
        int l = 0;
        while ((l = input.read(bs, READ_OFF, READ_LENGTH)) >= 0) {
            if (!BUILD_STRING) continue;
            sb.append(new String(bs, READ_OFF, l));
        }
        if (BUILD_STRING && OUT_STRING) {
            System.out.println(sb);
        }
    }

    static void testStandardTransitionFromWriterToStream() throws IOException {
        int i;
        String s = "This is a senseless text to test transform from writer to stream.\n";
        for (int i2 = 0; i2 < 10; ++i2) {
            s = s + s;
        }
        char[] bytes = s.toCharArray();
        StringWriter output = new StringWriter(16);
        for (i = 0; i < 4; ++i) {
            output.write(bytes);
        }
        for (i = 0; i < bytes.length; ++i) {
            output.write(bytes[i]);
        }
        String str = output.toString();
        ByteArrayInputStream input = new ByteArrayInputStream(str.getBytes());
        StringBuffer sb = new StringBuffer();
        byte[] bs = new byte[ARRAY_LENGTH];
        int l = 0;
        while ((l = input.read(bs, READ_OFF, READ_LENGTH)) >= 0) {
            if (!BUILD_STRING) continue;
            sb.append(new String(bs, READ_OFF, l));
        }
        if (BUILD_STRING && OUT_STRING) {
            System.out.println(sb);
        }
    }

    static void testTransitionFromStreamToWriter() throws IOException {
        int i;
        String s = "This is a senseless text to test transform from stream to writer.\n";
        for (int i2 = 0; i2 < 10; ++i2) {
            s = s + s;
        }
        byte[] bytes = s.getBytes();
        FastBufferOutputStream output = new FastBufferOutputStream(16);
        for (i = 0; i < 4; ++i) {
            output.write(bytes);
        }
        for (i = 0; i < bytes.length; ++i) {
            output.write(bytes[i]);
        }
        FastBufferWriter output2 = output.convertToWriter("UTF-8");
        FastBufferReader input = new FastBufferReader(output2);
        StringBuffer sb = new StringBuffer();
        char[] bs = new char[ARRAY_LENGTH];
        int l = 0;
        while ((l = input.read(bs, READ_OFF, READ_LENGTH)) >= 0) {
            if (!BUILD_STRING) continue;
            sb.append(new String(bs, READ_OFF, l));
        }
        if (BUILD_STRING && OUT_STRING) {
            System.out.println(sb);
        }
    }

    public static void main(String[] args) {
        long t = System.currentTimeMillis();
        try {
            for (int i = 0; i < 10; ++i) {
                Test.testStandardTransitionFromWriterToStream();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long dt = System.currentTimeMillis() - t;
        System.out.println(dt);
    }
}

