/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application;

import javax.faces.context.FacesContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.richfaces.ContextInitParameter;
import org.richfaces.ContextInitParameters;
import org.richfaces.FacesRequestSetupRule;
import org.richfaces.application.Configuration;
import org.richfaces.application.Enumeration;
import org.richfaces.application.configuration.ConfigurationServiceHelper;

public class ConfigurationServiceImplTest {
    @Rule
    public FacesRequestSetupRule rule = new FacesRequestSetupRule();

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.LongValue", value="223372036854775807"), @ContextInitParameter(name="org.richfaces.IntValue", value="32768"), @ContextInitParameter(name="org.richfaces.StringValue", value="some string"), @ContextInitParameter(name="org.richfaces.BooleanValue", value="true"), @ContextInitParameter(name="org.richfaces.EnumValue", value="bar")})
    public void testLiteralValues() throws Exception {
        FacesContext context = FacesContext.getCurrentInstance();
        Assert.assertEquals((long)223372036854775807L, (long)ConfigurationServiceHelper.getLongConfigurationValue((FacesContext)context, (Enum)Configuration.longValue));
        Assert.assertEquals((long)32768L, (long)ConfigurationServiceHelper.getIntConfigurationValue((FacesContext)context, (Enum)Configuration.intValue).intValue());
        Assert.assertEquals((Object)"some string", (Object)ConfigurationServiceHelper.getStringConfigurationValue((FacesContext)context, (Enum)Configuration.stringValue));
        Assert.assertEquals((Object)true, (Object)ConfigurationServiceHelper.getBooleanConfigurationValue((FacesContext)context, (Enum)Configuration.booleanValue));
        Assert.assertEquals((Object)((Object)Enumeration.bar), (Object)ConfigurationServiceHelper.getEnumConfigurationValue((FacesContext)context, (Enum)Configuration.enumValue, Enumeration.class));
    }

    @Test
    public void testDefaultValues() throws Exception {
        FacesContext context = FacesContext.getCurrentInstance();
        Assert.assertEquals((long)-100L, (long)ConfigurationServiceHelper.getLongConfigurationValue((FacesContext)context, (Enum)Configuration.longValueWithDefault));
        Assert.assertEquals((long)-1L, (long)ConfigurationServiceHelper.getIntConfigurationValue((FacesContext)context, (Enum)Configuration.intValueWithDefault).intValue());
        Assert.assertEquals((Object)"default name", (Object)ConfigurationServiceHelper.getStringConfigurationValue((FacesContext)context, (Enum)Configuration.stringValueWithDefault));
        Assert.assertEquals((Object)false, (Object)ConfigurationServiceHelper.getBooleanConfigurationValue((FacesContext)context, (Enum)Configuration.booleanValueWithDefault));
        Assert.assertEquals((Object)((Object)Enumeration.foo), (Object)ConfigurationServiceHelper.getEnumConfigurationValue((FacesContext)context, (Enum)Configuration.enumValueWithDefault, Enumeration.class));
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.MultiValue2", value="test value")})
    public void testMultiValues() throws Exception {
        Assert.assertEquals((Object)"test value", (Object)ConfigurationServiceHelper.getStringConfigurationValue((FacesContext)FacesContext.getCurrentInstance(), (Enum)Configuration.multiValue));
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.FacesContextReference", value="#{facesContext}"), @ContextInitParameter(name="org.richfaces.DynamicValueWithDefault", value="#{facesContext.attributes['dummyValue']}")})
    public void testDynamicValues() throws Exception {
        FacesContext context = FacesContext.getCurrentInstance();
        Assert.assertSame((Object)context, (Object)ConfigurationServiceHelper.getConfigurationValue((FacesContext)context, (Enum)Configuration.facesContext));
        Assert.assertEquals((Object)"<something>", (Object)ConfigurationServiceHelper.getConfigurationValue((FacesContext)context, (Enum)Configuration.dynamicValueWithDefault));
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.LiteralOnlyValue", value="pure literal"), @ContextInitParameter(name="org.richfaces.LiteralOnlyWithEl", value="#{someEl}")})
    public void testLiteral() throws Exception {
        FacesContext context = FacesContext.getCurrentInstance();
        Assert.assertEquals((Object)"pure literal", (Object)ConfigurationServiceHelper.getConfigurationValue((FacesContext)context, (Enum)Configuration.literalOnly));
        Assert.assertEquals((Object)"#{someEl}", (Object)ConfigurationServiceHelper.getConfigurationValue((FacesContext)context, (Enum)Configuration.literalOnlyWithEl));
    }
}

