/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application;

import org.junit.Assert;
import org.junit.Test;
import org.richfaces.application.JsfVersionInspector;

public class JsfVersionInspectorTest {
    @Test
    public void testParseString() throws Exception {
        JsfVersionInspector enforcer = new JsfVersionInspector("");
        JsfVersionInspector.Version version = enforcer.parseVersion("2.0.6");
        Assert.assertEquals((long)2L, (long)version.major);
        Assert.assertEquals((long)0L, (long)version.minor);
        Assert.assertEquals((long)6L, (long)version.micro);
        Assert.assertEquals((Object)"", (Object)version.qualifier);
        version = enforcer.parseVersion("2.1.27.redhat-9");
        Assert.assertEquals((long)2L, (long)version.major);
        Assert.assertEquals((long)1L, (long)version.minor);
        Assert.assertEquals((long)27L, (long)version.micro);
        Assert.assertEquals((Object)"redhat-9", (Object)version.qualifier);
        version = enforcer.parseVersion("2.1.4-jbossorg-1");
        Assert.assertEquals((long)2L, (long)version.major);
        Assert.assertEquals((long)1L, (long)version.minor);
        Assert.assertEquals((long)4L, (long)version.micro);
        Assert.assertEquals((Object)"jbossorg-1", (Object)version.qualifier);
        version = enforcer.parseVersion("2.1.6-SNAPSHOT");
        Assert.assertEquals((long)2L, (long)version.major);
        Assert.assertEquals((long)1L, (long)version.minor);
        Assert.assertEquals((long)6L, (long)version.micro);
        Assert.assertEquals((Object)"SNAPSHOT", (Object)version.qualifier);
    }

    @Test
    public void testExtractVersion() throws Exception {
        JsfVersionInspector enforcer = new JsfVersionInspector("");
        String version = enforcer.extractVersion("This sentence contains the version 2.1.4-jbossorg-2 in the middle");
        Assert.assertEquals((Object)"2.1.4-jbossorg-2", (Object)version);
        version = enforcer.extractVersion("This sentence contains the version 2.2.6 in the middle");
        Assert.assertEquals((Object)"2.2.6", (Object)version);
    }

    @Test
    public void testTestVersion() throws Exception {
        JsfVersionInspector enforcer = new JsfVersionInspector("");
        Assert.assertFalse((boolean)enforcer.testVersion(enforcer.parseVersion("2.2.4")));
        Assert.assertFalse((boolean)enforcer.testVersion(enforcer.parseVersion("2.2.5-jbossorg-2")));
        Assert.assertTrue((boolean)enforcer.testVersion(enforcer.parseVersion("2.2.5-jbossorg-3")));
        Assert.assertTrue((boolean)enforcer.testVersion(enforcer.parseVersion("2.2.6")));
    }
}

