/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.application;

import java.util.Locale;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import org.easymock.EasyMock;
import org.jboss.test.faces.mock.MockFacesEnvironment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.richfaces.application.MessageFactory;
import org.richfaces.application.MessageFactoryImpl;
import org.richfaces.l10n.BundleLoader;
import org.richfaces.l10n.MessageBundle;

public class MessageFactoryImplementationTest {
    private MockFacesEnvironment facesEnvironment;
    private MessageFactory messageFactory;

    @Before
    public void setUp() throws Exception {
        Locale.setDefault(Locale.US);
        this.facesEnvironment = MockFacesEnvironment.createEnvironment().withApplication();
        this.messageFactory = new MessageFactoryImpl(new BundleLoader());
    }

    @After
    public void tearDown() throws Exception {
        this.facesEnvironment.verify();
        this.facesEnvironment.release();
        this.facesEnvironment = null;
        this.messageFactory = null;
    }

    @Test
    public void testCreateMessageFromFacesBundle() throws Exception {
        EasyMock.expect((Object)this.facesEnvironment.getFacesContext().getViewRoot()).andStubReturn(null);
        EasyMock.expect((Object)this.facesEnvironment.getApplication().getMessageBundle()).andStubReturn(null);
        this.facesEnvironment.replay();
        FacesMessage stringConverterMessage = this.messageFactory.createMessage(this.facesEnvironment.getFacesContext(), (Enum)Messages.CONVERTER_STRING, new Object[]{"something", "Message"});
        Assert.assertNotNull((Object)stringConverterMessage);
        Assert.assertEquals((Object)FacesMessage.SEVERITY_INFO, (Object)stringConverterMessage.getSeverity());
        Assert.assertEquals((Object)"Message: Could not convert 'something' to a string.", (Object)stringConverterMessage.getSummary());
        Assert.assertEquals((Object)stringConverterMessage.getSummary(), (Object)stringConverterMessage.getDetail());
        FacesMessage longConverterMessage = this.messageFactory.createMessage(this.facesEnvironment.getFacesContext(), FacesMessage.SEVERITY_ERROR, (Enum)Messages.ENUM_CONVERTER_ENUM, new Object[]{"field", "anotherField", "Failed"});
        Assert.assertNotNull((Object)longConverterMessage);
        Assert.assertEquals((Object)FacesMessage.SEVERITY_ERROR, (Object)longConverterMessage.getSeverity());
        Assert.assertEquals((Object)"Failed: 'field' must be convertible to an enum.", (Object)longConverterMessage.getSummary());
        Assert.assertEquals((Object)"Failed: 'field' must be convertible to an enum from the enum that contains the constant 'anotherField'.", (Object)longConverterMessage.getDetail());
    }

    @Test
    public void testCreateMessageFromApplicationBundle() throws Exception {
        UIViewRoot mockViewRoot = (UIViewRoot)this.facesEnvironment.createMock(UIViewRoot.class);
        EasyMock.expect((Object)mockViewRoot.getLocale()).andStubReturn((Object)new Locale("ru", "RU"));
        EasyMock.expect((Object)this.facesEnvironment.getFacesContext().getViewRoot()).andStubReturn((Object)mockViewRoot);
        EasyMock.expect((Object)this.facesEnvironment.getApplication().getMessageBundle()).andStubReturn((Object)"org.richfaces.application.MessageFactoryImplTest");
        this.facesEnvironment.replay();
        FacesMessage stringConverterMessage = this.messageFactory.createMessage(this.facesEnvironment.getFacesContext(), (Enum)Messages.CONVERTER_STRING, new Object[]{"something", "Message"});
        Assert.assertNotNull((Object)stringConverterMessage);
        Assert.assertEquals((Object)FacesMessage.SEVERITY_INFO, (Object)stringConverterMessage.getSeverity());
        Assert.assertEquals((Object)"Message: 'something' ne konvertiruyetsia v stroku.", (Object)stringConverterMessage.getSummary());
        Assert.assertEquals((Object)stringConverterMessage.getSummary(), (Object)stringConverterMessage.getDetail());
        FacesMessage longConverterMessage = this.messageFactory.createMessage(this.facesEnvironment.getFacesContext(), FacesMessage.SEVERITY_ERROR, (Enum)Messages.ENUM_CONVERTER_ENUM, new Object[]{"field", "anotherField", "Failed"});
        Assert.assertNotNull((Object)longConverterMessage);
        Assert.assertEquals((Object)FacesMessage.SEVERITY_ERROR, (Object)longConverterMessage.getSeverity());
        Assert.assertEquals((Object)"Failed: 'field' dolzhno konvertirovat'sia v enum.", (Object)longConverterMessage.getSummary());
        Assert.assertEquals((Object)"Failed: 'field' dolzhno konvertirovat'sia v enum iz enum s konstantoj 'anotherField'.", (Object)longConverterMessage.getDetail());
        FacesMessage inputConversionMessage = this.messageFactory.createMessage(this.facesEnvironment.getFacesContext(), (Enum)Messages.UIINPUT_CONVERSION, new Object[]{"Failure message"});
        Assert.assertNotNull((Object)inputConversionMessage);
        Assert.assertEquals((Object)FacesMessage.SEVERITY_INFO, (Object)inputConversionMessage.getSeverity());
        Assert.assertEquals((Object)"Failure message: Conversion error occurred.", (Object)inputConversionMessage.getSummary());
    }

    @MessageBundle(baseName="org.richfaces.application.Messages")
    public static enum Messages {
        UIINPUT_CONVERSION("javax.faces.component.UIInput.CONVERSION"),
        ENUM_CONVERTER_ENUM("javax.faces.converter.EnumConverter.ENUM"),
        CONVERTER_STRING("javax.faces.converter.STRING");

        private String key;

        private Messages(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }
}

