/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.cache.lru;

import java.util.Date;
import junit.framework.TestCase;
import org.junit.Assert;
import org.richfaces.cache.lru.CacheEntry;
import org.richfaces.cache.lru.CacheMap;

public class CacheMapTest
extends TestCase {
    private void addToCacheMap(CacheMap cacheMap, String key, String value) {
        CacheEntry entry = new CacheEntry((Object)key, (Object)value, null);
        cacheMap.put((Object)key, entry);
    }

    public void testLRUEviction() throws Exception {
        CacheMap cache = new CacheMap(3);
        this.addToCacheMap(cache, "key1", "value1");
        this.addToCacheMap(cache, "key2", "value2");
        this.addToCacheMap(cache, "key3", "value3");
        Assert.assertEquals((Object)"value1", (Object)((CacheEntry)cache.get((Object)"key1")).getValue());
        Assert.assertEquals((Object)"value2", (Object)((CacheEntry)cache.get((Object)"key2")).getValue());
        Assert.assertEquals((Object)"value3", (Object)((CacheEntry)cache.get((Object)"key3")).getValue());
        cache.get((Object)"key1");
        cache.get((Object)"key3");
        this.addToCacheMap(cache, "key4", "value4");
        Assert.assertEquals((Object)"value1", (Object)((CacheEntry)cache.get((Object)"key1")).getValue());
        Assert.assertNull((Object)cache.get((Object)"key2"));
        Assert.assertEquals((Object)"value3", (Object)((CacheEntry)cache.get((Object)"key3")).getValue());
        Assert.assertEquals((Object)"value4", (Object)((CacheEntry)cache.get((Object)"key4")).getValue());
    }

    public void testExpirationQueue() throws Exception {
        CacheMap cacheMap = new CacheMap();
        Assert.assertTrue((boolean)cacheMap.getExpirationQueue().isEmpty());
        CacheEntry cacheEntry = new CacheEntry((Object)"key", (Object)"value", new Date(System.currentTimeMillis() + 1000L));
        cacheMap.put((Object)"key", cacheEntry);
        Assert.assertNotNull((Object)cacheMap.get((Object)"key"));
        Assert.assertSame((Object)cacheEntry, (Object)cacheMap.get((Object)"key"));
        Assert.assertFalse((boolean)cacheMap.getExpirationQueue().isEmpty());
        cacheMap.clear();
        Assert.assertTrue((boolean)cacheMap.getExpirationQueue().isEmpty());
        cacheMap.put((Object)"key2", new CacheEntry((Object)"key2", (Object)"value2", new Date(System.currentTimeMillis() + 1000L)));
        Assert.assertNotNull((Object)cacheMap.get((Object)"key2"));
        cacheMap.remove((Object)"key2");
        Assert.assertTrue((boolean)cacheMap.getExpirationQueue().isEmpty());
    }
}

