/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import org.jboss.test.faces.FacesEnvironment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.richfaces.context.ComponentIdResolver;

public class ComponentIdResolverTest {
    static final String META_COMPONENT_ID = "testId";
    static final String META_COMPONENT_ID_SUBSTITUTION = "@substitutedTestId";
    private static final String META_CLIENT_ID = "@testId";
    private FacesEnvironment environment;
    private FacesEnvironment.FacesRequest facesRequest;
    private FacesContext facesContext;
    private UIViewRoot viewRoot;

    @Before
    public void setUp() throws Exception {
        ComponentIdResolver.setMetaComponentSubstitutions(Collections.singletonMap(META_COMPONENT_ID, META_COMPONENT_ID_SUBSTITUTION));
        this.environment = FacesEnvironment.createEnvironment();
        this.environment.withResource("/test.xhtml", this.getClass().getResource("/org/richfaces/context/ComponentIdResolver.xhtml"));
        this.environment.withResource("/WEB-INF/faces-config.xml", this.getClass().getResource("/org/richfaces/context/ComponentIdResolver.config.xml"));
        this.environment.start();
        this.facesRequest = this.environment.createFacesRequest();
        this.facesRequest.start();
        this.facesContext = FacesContext.getCurrentInstance();
        this.viewRoot = this.facesContext.getViewRoot();
        this.facesContext.getExternalContext().getRequestMap().put("one", Arrays.asList(1));
        ViewHandler viewHandler = this.facesContext.getApplication().getViewHandler();
        ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(this.facesContext, this.viewRoot.getViewId());
        vdl.buildView(this.facesContext, this.viewRoot);
    }

    @After
    public void tearDown() throws Exception {
        this.viewRoot = null;
        this.facesContext = null;
        this.facesRequest.release();
        this.facesRequest = null;
        this.environment.release();
        this.environment = null;
    }

    private <T> Set<T> asSet(T ... elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    private ComponentIdResolver createComponentIdResolver() {
        return new ComponentIdResolver(this.facesContext);
    }

    private UIComponent evaluateComponentExpression(String expression) {
        return (UIComponent)this.facesContext.getApplication().evaluateExpressionGet(this.facesContext, expression, UIComponent.class);
    }

    @Test
    public void testFindBySimpleId() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId("input");
        resolver.addId("column");
        resolver.addId("header");
        resolver.resolve((UIComponent)this.viewRoot);
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("form:table:input", "form:table:header", "form:table:column"), (Object)resolvedIds);
    }

    @Test
    public void testFindBySimpleIdInContext() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId("input");
        resolver.addId("column");
        resolver.addId("header");
        resolver.resolve(this.evaluateComponentExpression("#{testBean.table}"));
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("form:table:input", "form:table:header", "form:table:column"), (Object)resolvedIds);
    }

    @Test
    public void testFindByRowsId() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId("table:@rows(one):input");
        resolver.resolve(this.evaluateComponentExpression("#{testBean.table}"));
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("form:table:1:input"), (Object)resolvedIds);
    }

    @Test
    public void testFindByMetaComponentId() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId("input@text");
        resolver.addId("table:@rows(one):header@head");
        resolver.addId("table:@rows(one):header@footer");
        resolver.resolve((UIComponent)this.viewRoot);
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("form:table:1:header@footer", "form:table:1:header@head", "form:table:input@text"), (Object)resolvedIds);
    }

    @Test
    public void testFindWithNoParentContainer() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId("form:table:@rows(one):column");
        resolver.resolve(this.evaluateComponentExpression("#{testBean.table}"));
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("form:table:1:column"), (Object)resolvedIds);
    }

    @Test
    public void testFindNonExistent() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId("nonExistentId");
        resolver.addId("xForm:nonExistentId");
        resolver.addId(":ySubview:nonExistentId");
        resolver.resolve((UIComponent)this.viewRoot);
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("nonExistentId", "xForm:nonExistentId", "ySubview:nonExistentId"), (Object)resolvedIds);
    }

    @Test
    public void testFindNonExistentWithContext() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId("nonExistentId");
        resolver.addId("xForm:nonExistentId");
        resolver.addId(":ySubview:nonExistentId");
        resolver.resolve(this.evaluateComponentExpression("#{testBean.table}"));
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("nonExistentId", "xForm:nonExistentId", "ySubview:nonExistentId"), (Object)resolvedIds);
    }

    @Test
    public void testFindViaMetadataResolverInContext() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId(META_CLIENT_ID);
        resolver.resolve(this.evaluateComponentExpression("#{testBean.outputInRegion}"));
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("firstRegion"), (Object)resolvedIds);
    }

    @Test
    public void testFindViaMetadataResolverOutContext() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId(META_CLIENT_ID);
        resolver.resolve(this.evaluateComponentExpression("#{testBean.outputOutRegion}"));
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet(META_COMPONENT_ID_SUBSTITUTION), (Object)resolvedIds);
    }

    @Test
    public void testAbsoluteIds() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId(":form:table:input");
        resolver.addId(":form:table:column@head");
        resolver.addId(":form:table:@rows(one):column");
        resolver.resolve((UIComponent)this.viewRoot);
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("form:table:input", "form:table:column@head", "form:table:1:column"), (Object)resolvedIds);
    }

    @Test
    public void testUnresolvedMetaComponentSubstitutionCompatibility() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId(META_CLIENT_ID);
        resolver.resolve(this.evaluateComponentExpression("#{testBean.linkInRegion}"));
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("firstRegion"), (Object)resolvedIds);
    }

    @Test
    public void testUnresolvedMetaComponentSubstitution() throws Exception {
        ComponentIdResolver resolver = this.createComponentIdResolver();
        resolver.addId(META_CLIENT_ID);
        resolver.resolve(this.evaluateComponentExpression("#{testBean.linkOutRegion}"));
        Set resolvedIds = resolver.getResolvedIds();
        Assert.assertEquals(this.asSet("@all"), (Object)resolvedIds);
    }
}

