/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.javascript;

import com.google.common.collect.Iterables;
import java.util.Collection;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.jboss.test.faces.mock.Environment;
import org.jboss.test.faces.mock.Mock;
import org.jboss.test.faces.mock.MockController;
import org.jboss.test.faces.mock.MockFacesEnvironment;
import org.jboss.test.faces.mock.MockTestRunner;
import org.jboss.test.faces.mock.Stub;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.richfaces.application.ServicesFactory;
import org.richfaces.component.UIScripts;
import org.richfaces.javascript.JavaScriptServiceImpl;
import org.richfaces.resource.ResourceKey;

@RunWith(value=MockTestRunner.class)
public class JavaScriptServiceTest {
    static final ResourceKey FOO_RESOURCE = ResourceKey.create((String)"foo", (String)"org.rf");
    protected UIScripts scriptResource;
    protected JavaScriptServiceImpl serviceImpl;
    @Mock
    @Environment(value={Environment.Feature.APPLICATION, Environment.Feature.RENDER_KIT, Environment.Feature.EL_CONTEXT})
    protected MockFacesEnvironment environment;
    protected MockController controller;
    @Mock
    protected ValueExpression expression;
    @Stub
    protected ServicesFactory factory;

    @After
    public void tearDown() throws Exception {
        this.controller.release();
    }

    @Before
    public void setUpResource() {
        this.serviceImpl = new JavaScriptServiceImpl(){

            UIScripts getOrCreateScriptResource(FacesContext facesContext) {
                return JavaScriptServiceTest.this.scriptResource;
            }
        };
        this.scriptResource = new UIScripts();
    }

    @After
    public void cleanUpResource() {
        this.scriptResource = null;
    }

    @Test
    public void testAddOrFindScript() {
        Object script = this.createScript("foo bar");
        Object script2 = this.serviceImpl.addScript(this.environment.getFacesContext(), script);
        Collection scripts = this.scriptResource.getScripts();
        Assert.assertEquals((long)1L, (long)scripts.size());
        Assert.assertSame((Object)script, (Object)Iterables.getOnlyElement((Iterable)scripts));
    }

    @Test
    public void testAddOrFindScript2() {
        Object script = this.createScript("foo bar");
        this.serviceImpl.addScript(this.environment.getFacesContext(), script);
        Object script2 = this.createScript("fooz baz bar");
        Object script3 = this.serviceImpl.addScript(this.environment.getFacesContext(), script2);
        Collection scripts = this.scriptResource.getScripts();
        Assert.assertEquals((long)2L, (long)scripts.size());
        Assert.assertSame((Object)script2, (Object)script3);
    }

    @Test
    public void testAddOrFindScript3() {
        Object script = this.createScript("foo bar");
        this.serviceImpl.addScript(this.environment.getFacesContext(), script);
        Object script2 = this.createScript("foo bar");
        Object script3 = this.serviceImpl.addScript(this.environment.getFacesContext(), script2);
        Collection scripts = this.scriptResource.getScripts();
        Assert.assertEquals((long)1L, (long)scripts.size());
        Assert.assertSame((Object)script, (Object)script3);
    }

    private Object createScript(String content) {
        return content;
    }
}

