/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.richfaces.resource.AbstractCacheableResource;
import org.richfaces.resource.DynamicResource;
import org.richfaces.resource.ResourceHandlerImplTest;

@DynamicResource
public class CacheableResourceImpl
extends AbstractCacheableResource {
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getContentToEcho());
    }

    private byte[] getContentToEcho() {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        Map headers = externalContext.getRequestHeaderMap();
        Object content = headers.get("RichFaces-Echo");
        try {
            return content.toString().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    protected int getContentLength(FacesContext context) {
        return this.getContentToEcho().length;
    }

    public String getContentType() {
        return "text/plain";
    }

    long getCurrentTime() {
        return ResourceHandlerImplTest.currentTime.getTime();
    }

    protected Date getLastModified(FacesContext context) {
        return ResourceHandlerImplTest.lastModified;
    }

    public Date getExpires(FacesContext context) {
        return ResourceHandlerImplTest.expires;
    }
}

