/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.jboss.test.faces.AbstractFacesTest;
import org.richfaces.resource.CachedResourceImpl;

public class CachedResourceImplTest
extends AbstractFacesTest {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String EXPIRES = "Expires";
    private static final String LAST_MODIFIED = "Last-Modified";

    public void setUp() throws Exception {
        super.setUp();
        this.setupFacesRequest();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    private CachedResourceImpl createCachedResource() throws IOException {
        return this.createCachedResource(this.createTestHeaders());
    }

    private CachedResourceImpl createCachedResource(Map<String, String> headers) throws IOException {
        return this.createCachedResource(headers, null);
    }

    private CachedResourceImpl createCachedResource(Map<String, String> headers, InputStream stream) throws IOException {
        MockHeadersResourceImpl mockResource = new MockHeadersResourceImpl(headers, stream);
        MockCachedResourceImpl cachedResource = new MockCachedResourceImpl();
        cachedResource.initialize(mockResource);
        return cachedResource;
    }

    private Map<String, String> createTestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("ETag", "W/\"123\"");
        headers.put(LAST_MODIFIED, "Tue, 21 Jul 2009 12:45:09 GMT");
        headers.put(EXPIRES, "Tue, 28 Jul 2009 12:45:09 GMT");
        headers.put(CACHE_CONTROL, "public, max-age=86400");
        return headers;
    }

    private Calendar createBaseDateCalendar() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.clear();
        calendar.set(2009, 6, 21, 12, 45, 9);
        return calendar;
    }

    public void testInitialize() throws Exception {
        CachedResourceImpl cachedResource = this.createCachedResource();
        Calendar calendar = this.createBaseDateCalendar();
        Date baseDate = calendar.getTime();
        CachedResourceImplTest.assertEquals((String)"W/\"123\"", (String)cachedResource.getEntityTag(this.facesContext));
        CachedResourceImplTest.assertEquals((Object)baseDate, (Object)cachedResource.getLastModified(this.facesContext));
        CachedResourceImplTest.assertEquals(this.createTestHeaders(), (Object)cachedResource.getResponseHeaders());
        CachedResourceImplTest.assertEquals((String)"image/png", (String)cachedResource.getContentType());
        Date expired = cachedResource.getExpired(this.facesContext);
        CachedResourceImplTest.assertNotNull((Object)expired);
        CachedResourceImplTest.assertTrue((boolean)expired.after(baseDate));
        calendar.add(5, 1);
        CachedResourceImplTest.assertFalse((boolean)calendar.getTime().before(expired));
    }

    public void testInitializeExpires() throws Exception {
        Map<String, String> headers = this.createTestHeaders();
        headers.remove(CACHE_CONTROL);
        CachedResourceImpl cachedResource = this.createCachedResource(headers);
        Date expired = cachedResource.getExpired(this.facesContext);
        CachedResourceImplTest.assertNotNull((Object)expired);
        Calendar calendar = this.createBaseDateCalendar();
        CachedResourceImplTest.assertTrue((boolean)expired.after(calendar.getTime()));
        calendar.add(5, 1);
        CachedResourceImplTest.assertFalse((boolean)expired.before(calendar.getTime()));
        calendar.add(5, 6);
        CachedResourceImplTest.assertTrue((boolean)expired.before(calendar.getTime()));
    }

    public void testInitializeMaxAge() throws Exception {
        Map<String, String> headers = this.createTestHeaders();
        headers.remove(EXPIRES);
        CachedResourceImpl cachedResource = this.createCachedResource(headers);
        Date expired = cachedResource.getExpired(this.facesContext);
        CachedResourceImplTest.assertNotNull((Object)expired);
        Calendar calendar = this.createBaseDateCalendar();
        CachedResourceImplTest.assertTrue((boolean)expired.after(calendar.getTime()));
        calendar.add(5, 1);
        CachedResourceImplTest.assertTrue((boolean)expired.before(calendar.getTime()));
    }

    public void testInitializeSMaxAge() throws Exception {
        Map<String, String> headers = this.createTestHeaders();
        headers.put(CACHE_CONTROL, "public, max-age=86400, s-maxage=172800");
        CachedResourceImpl cachedResource = this.createCachedResource(headers);
        Date expired = cachedResource.getExpired(this.facesContext);
        CachedResourceImplTest.assertNotNull((Object)expired);
        Calendar calendar = this.createBaseDateCalendar();
        CachedResourceImplTest.assertTrue((boolean)expired.after(calendar.getTime()));
        calendar.add(5, 1);
        CachedResourceImplTest.assertFalse((boolean)expired.before(calendar.getTime()));
        calendar.add(5, 1);
        CachedResourceImplTest.assertTrue((boolean)expired.before(calendar.getTime()));
    }

    public void testGetStream() throws Exception {
        ByteArrayInputStream testStream = new ByteArrayInputStream("test".getBytes("US-ASCII"));
        CachedResourceImpl cachedResource = this.createCachedResource(this.createTestHeaders(), testStream);
        InputStream stream = cachedResource.getInputStream();
        CachedResourceImplTest.assertNotNull((Object)stream);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "US-ASCII"));
        CachedResourceImplTest.assertEquals((String)"test", (String)reader.readLine());
        CachedResourceImplTest.assertNull((Object)reader.readLine());
        reader.close();
    }

    public void testGetBigStream() throws Exception {
        byte[] bs = new byte[127123];
        new Random().nextBytes(bs);
        ByteArrayInputStream bigStream = new ByteArrayInputStream(bs);
        CachedResourceImpl cachedResource = this.createCachedResource(this.createTestHeaders(), bigStream);
        InputStream stream = cachedResource.getInputStream();
        byte[] testBs = new byte[bs.length];
        CachedResourceImplTest.assertEquals((int)testBs.length, (int)stream.read(testBs));
        CachedResourceImplTest.assertTrue((boolean)Arrays.equals(testBs, bs));
        CachedResourceImplTest.assertEquals((int)-1, (int)stream.read());
        stream.close();
    }

    public void testCacheable() throws Exception {
        CachedResourceImpl cachedResource = this.createCachedResource();
        CachedResourceImplTest.assertTrue((boolean)cachedResource.isCacheable(this.facesContext));
    }

    public void testDefaults() throws Exception {
        CachedResourceImpl cachedResource = this.createCachedResource();
        try {
            cachedResource.getURL();
            CachedResourceImplTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            cachedResource.getRequestPath();
            CachedResourceImplTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testUserAgentNeedsUpdate() throws Exception {
        CachedResourceImpl cachedResource = this.createCachedResource();
        this.connection.addRequestHeaders(Collections.singletonMap("If-Modified-Since", "Tue, 21 Jul 2009 14:45:09 GMT"));
        CachedResourceImplTest.assertFalse((boolean)cachedResource.userAgentNeedsUpdate(this.facesContext));
    }

    public void testUserAgentNeedsUpdate2() throws Exception {
        CachedResourceImpl cachedResource = this.createCachedResource();
        this.connection.addRequestHeaders(Collections.singletonMap("If-Modified-Since", "Tue, 21 Jul 2009 09:45:09 GMT"));
        CachedResourceImplTest.assertTrue((boolean)cachedResource.userAgentNeedsUpdate(this.facesContext));
    }

    private class MockHeadersResourceImpl
    extends Resource {
        private Map<String, String> headers;
        private InputStream stream;

        public MockHeadersResourceImpl(Map<String, String> headers, InputStream stream) {
            this.setResourceName(((Object)((Object)this)).getClass().getName());
            this.setContentType("image/png");
            this.headers = headers;
            this.stream = stream != null ? stream : new ByteArrayInputStream(new byte[0]);
        }

        public Map<String, String> getResponseHeaders() {
            return this.headers;
        }

        public InputStream getInputStream() throws IOException {
            return this.stream;
        }

        public String getRequestPath() {
            throw new UnsupportedOperationException();
        }

        public URL getURL() {
            throw new UnsupportedOperationException();
        }

        public boolean userAgentNeedsUpdate(FacesContext context) {
            throw new UnsupportedOperationException();
        }
    }

    private class MockCachedResourceImpl
    extends CachedResourceImpl {
        private final long currentTime;

        public MockCachedResourceImpl() {
            this.currentTime = CachedResourceImplTest.this.createBaseDateCalendar().getTimeInMillis();
        }

        long getCurrentTime() {
            return this.currentTime;
        }
    }
}

