/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import org.easymock.classextension.EasyMock;
import org.jboss.test.faces.AbstractFacesTest;
import org.jboss.test.faces.htmlunit.LocalWebClient;
import org.richfaces.application.DependencyInjector;
import org.richfaces.application.DependencyInjectorImpl;
import org.richfaces.application.Module;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.ServicesFactory;
import org.richfaces.application.ServicesFactoryImpl;
import org.richfaces.application.Uptime;
import org.richfaces.application.configuration.ConfigurationService;
import org.richfaces.application.configuration.ConfigurationServiceImpl;
import org.richfaces.cache.Cache;
import org.richfaces.resource.ResourceCodec;
import org.richfaces.resource.ResourceRequestData;
import org.richfaces.resource.ResourceUtils;

public class ResourceHandlerImplTest
extends AbstractFacesTest {
    protected static final String ECHO_HEADER = "RichFaces-Echo";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String RESOURCES_FOLDER_PATH = "resources/";
    private static final String TEST_RESOURCE_NAME = "resources/defaultResourceHandlerResource.js";
    protected static final Date currentTime;
    protected static final Date expires;
    protected static final Date lastModified;
    private LocalWebClient webClient;

    private void addClasspathResources() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        File testResourceFile = new File(classLoader.getResource(TEST_RESOURCE_NAME).getFile());
        File testResourceFolder = testResourceFile.getParentFile();
        this.facesServer.addResourcesFromDirectory("/resources/", testResourceFolder);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.addClasspathResources();
        this.webClient = new LocalWebClient(this.facesServer);
        this.webClient.setRedirectEnabled(false);
        this.webClient.setCache((com.gargoylesoftware.htmlunit.Cache)new DisabledCache());
    }

    public void tearDown() throws Exception {
        super.tearDown();
        this.webClient = null;
    }

    public void testReadCacheableResource() throws Exception {
        WebRequest webRequest = new WebRequest(new URL("http://localhost/rfRes/org.richfaces.resource.CacheableResourceImpl.jsf"));
        webRequest.getAdditionalHeaders().put(ECHO_HEADER, "ping?");
        WebResponse webResponse = this.webClient.loadWebResponse(webRequest);
        ResourceHandlerImplTest.assertEquals((int)200, (int)webResponse.getStatusCode());
        ResourceHandlerImplTest.assertEquals((String)ResourceUtils.formatHttpDate((Object)lastModified.getTime()), (String)webResponse.getResponseHeaderValue("Last-Modified"));
        ResourceHandlerImplTest.assertEquals((String)ResourceUtils.formatHttpDate((Object)currentTime.getTime()), (String)webResponse.getResponseHeaderValue("Date"));
        ResourceHandlerImplTest.assertEquals((String)ResourceUtils.formatHttpDate((Object)expires.getTime()), (String)webResponse.getResponseHeaderValue("Expires"));
        ResourceHandlerImplTest.assertEquals((String)"max-age=1209600", (String)webResponse.getResponseHeaderValue("Cache-Control"));
        ResourceHandlerImplTest.assertTrue((boolean)webResponse.getResponseHeaderValue("Content-Type").startsWith("text/plain"));
        ResourceHandlerImplTest.assertEquals((String)("W/\"" + "ping?".length() + "-" + lastModified.getTime() + "\""), (String)webResponse.getResponseHeaderValue("ETag"));
        ResourceHandlerImplTest.assertNull((Object)webResponse.getResponseHeaderValue("Pragma"));
        ResourceHandlerImplTest.assertEquals((String)"ping?", (String)webResponse.getContentAsString("US-ASCII"));
        webRequest.getAdditionalHeaders().put(ECHO_HEADER, "pong");
        WebResponse cachedWebResponse = this.webClient.loadWebResponse(webRequest);
        ResourceHandlerImplTest.assertEquals((int)200, (int)cachedWebResponse.getStatusCode());
        ResourceHandlerImplTest.assertEquals((String)"ping?", (String)cachedWebResponse.getContentAsString("US-ASCII"));
        webRequest.getAdditionalHeaders().put(IF_MODIFIED_SINCE, ResourceUtils.formatHttpDate((Object)currentTime));
        WebResponse cachedWebResponse2 = this.webClient.loadWebResponse(webRequest);
        ResourceHandlerImplTest.assertEquals((int)304, (int)cachedWebResponse2.getStatusCode());
    }

    public void testReadNonCacheableResource() throws Exception {
        WebRequest webRequest = new WebRequest(new URL("http://localhost/rfRes/org.richfaces.resource.NonCacheableResourceImpl.jsf"));
        webRequest.getAdditionalHeaders().put(ECHO_HEADER, "ping?");
        WebResponse webResponse = this.webClient.loadWebResponse(webRequest);
        ResourceHandlerImplTest.assertEquals((int)200, (int)webResponse.getStatusCode());
        ResourceHandlerImplTest.assertEquals((String)ResourceUtils.formatHttpDate((Object)lastModified.getTime()), (String)webResponse.getResponseHeaderValue("Last-Modified"));
        ResourceHandlerImplTest.assertEquals((String)ResourceUtils.formatHttpDate((Object)currentTime.getTime()), (String)webResponse.getResponseHeaderValue("Date"));
        ResourceHandlerImplTest.assertEquals((String)"0", (String)webResponse.getResponseHeaderValue("Expires"));
        ResourceHandlerImplTest.assertEquals((String)"max-age=0, no-store, no-cache", (String)webResponse.getResponseHeaderValue("Cache-Control"));
        ResourceHandlerImplTest.assertTrue((boolean)webResponse.getResponseHeaderValue("Content-Type").startsWith("text/plain"));
        ResourceHandlerImplTest.assertNull((Object)webResponse.getResponseHeaderValue("ETag"));
        ResourceHandlerImplTest.assertEquals((String)"no-cache", (String)webResponse.getResponseHeaderValue("Pragma"));
        ResourceHandlerImplTest.assertEquals((String)"ping?", (String)webResponse.getContentAsString("US-ASCII"));
        webRequest.getAdditionalHeaders().put(ECHO_HEADER, "pong");
        WebResponse cachedWebResponse = this.webClient.loadWebResponse(webRequest);
        ResourceHandlerImplTest.assertEquals((int)200, (int)cachedWebResponse.getStatusCode());
        ResourceHandlerImplTest.assertEquals((String)"pong", (String)cachedWebResponse.getContentAsString("US-ASCII"));
        webRequest.getAdditionalHeaders().put(IF_MODIFIED_SINCE, ResourceUtils.formatHttpDate((Object)currentTime));
        WebResponse cachedWebResponse2 = this.webClient.loadWebResponse(webRequest);
        ResourceHandlerImplTest.assertEquals((int)200, (int)cachedWebResponse2.getStatusCode());
    }

    public void testNonExistingResource() throws Exception {
        WebRequest emptyResourceNameSettings = new WebRequest(new URL("http://localhost/rfRes/x.jsf"));
        WebResponse emptyResourceNameResponse = this.webClient.loadWebResponse(emptyResourceNameSettings);
        ResourceHandlerImplTest.assertEquals((int)404, (int)emptyResourceNameResponse.getStatusCode());
    }

    public void testDefaultMojarraResource() throws Exception {
        WebRequest mojarraWebRequest = new WebRequest(new URL("http://localhost/javax.faces.resource/defaultResourceHandlerResource.js.jsf"));
        WebResponse mojarraResourceNameResponse = this.webClient.loadWebResponse(mojarraWebRequest);
        ResourceHandlerImplTest.assertEquals((int)200, (int)mojarraResourceNameResponse.getStatusCode());
    }

    public void testMarkerFile() throws Exception {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        ResourceHandlerImplTest.assertNotNull(Class.forName("org.richfaces.resource.MarkerFileResourceImpl", true, contextClassLoader));
        ResourceHandlerImplTest.assertNotNull((Object)contextClassLoader.getResource("META-INF/org.richfaces.resource.MarkerFileResourceImpl.resource.properties"));
        WebRequest markerFileWebRequest = new WebRequest(new URL("http://localhost/rfRes/org.richfaces.resource.MarkerFileResourceImpl.jsf"));
        WebResponse markerFileResponse = this.webClient.loadWebResponse(markerFileWebRequest);
        ResourceHandlerImplTest.assertEquals((int)200, (int)markerFileResponse.getStatusCode());
        ResourceHandlerImplTest.assertNotNull(Class.forName("org.richfaces.resource.NoMarkerFileResourceImpl", true, contextClassLoader));
        ResourceHandlerImplTest.assertNull((Object)contextClassLoader.getResource("META-INF/org.richfaces.resource.NoMarkerFileResourceImpl.resource.properties"));
        WebRequest noMarkerFileRequestSettings = new WebRequest(new URL("http://localhost/rfRes/org.richfaces.resource.NoMarkerFileResourceImpl.jsf"));
        WebResponse noMarkerResponse = this.webClient.loadWebResponse(noMarkerFileRequestSettings);
        ResourceHandlerImplTest.assertEquals((int)404, (int)noMarkerResponse.getStatusCode());
    }

    public void testStateHolder() throws Exception {
        this.setupFacesRequest();
        final ResourceCodec mockedCodec = (ResourceCodec)EasyMock.createNiceMock(ResourceCodec.class);
        final Cache mockCache = (Cache)EasyMock.createNiceMock(Cache.class);
        ResourceRequestData resourceCodecData = (ResourceRequestData)EasyMock.createMock(ResourceRequestData.class);
        org.easymock.EasyMock.expect((Object)resourceCodecData.getResourceName()).andStubReturn((Object)"org.richfaces.resource.StateHolderResourceImpl");
        org.easymock.EasyMock.expect((Object)resourceCodecData.getLibraryName()).andStubReturn(null);
        org.easymock.EasyMock.expect((Object)resourceCodecData.getData()).andStubReturn((Object)"test text".getBytes());
        org.easymock.EasyMock.expect((Object)resourceCodecData.getVersion()).andStubReturn(null);
        org.easymock.EasyMock.expect((Object)resourceCodecData.getResourceKey()).andStubReturn((Object)"StateHolderResource.jsf?db=1");
        EasyMock.expect((Object)mockedCodec.decodeResource((FacesContext)EasyMock.notNull(), (String)EasyMock.eq((Object)"StateHolderResource"))).andReturn((Object)resourceCodecData);
        EasyMock.replay((Object[])new Object[]{mockedCodec, resourceCodecData, mockCache});
        ServicesFactoryImpl injector = new ServicesFactoryImpl();
        injector.init(Collections.singletonList(new Module(){

            public void configure(ServicesFactory injector) {
                injector.setInstance(ResourceCodec.class, (Object)mockedCodec);
                injector.setInstance(Cache.class, (Object)mockCache);
                injector.setInstance(Uptime.class, (Object)new Uptime());
                injector.setInstance(DependencyInjector.class, (Object)new DependencyInjectorImpl());
                injector.setInstance(ConfigurationService.class, (Object)new ConfigurationServiceImpl());
            }
        }));
        ServiceTracker.setFactory((ServicesFactory)injector);
        WebRequest webRequest = new WebRequest(new URL("http://localhost/rfRes/StateHolderResource.jsf?db=1"));
        WebResponse resourceResponse = this.webClient.loadWebResponse(webRequest);
        ResourceHandlerImplTest.assertEquals((int)200, (int)resourceResponse.getStatusCode());
        ResourceHandlerImplTest.assertEquals((String)"test text", (String)resourceResponse.getContentAsString("US-ASCII"));
        EasyMock.verify((Object[])new Object[]{mockedCodec, resourceCodecData, mockCache});
    }

    public void testVersionedResource() throws Exception {
        WebRequest webRequest = new WebRequest(new URL("http://localhost/rfRes/org.richfaces.resource.VersionedResourceImpl.jsf"));
        WebResponse resourceResponse = this.webClient.loadWebResponse(webRequest);
        ResourceHandlerImplTest.assertEquals((int)200, (int)resourceResponse.getStatusCode());
        webRequest = new WebRequest(new URL("http://localhost/rfRes/org.richfaces.resource.VersionedResourceImpl.jsf?v=1_0_2"));
        resourceResponse = this.webClient.loadWebResponse(webRequest);
        ResourceHandlerImplTest.assertEquals((int)200, (int)resourceResponse.getStatusCode());
        webRequest = new WebRequest(new URL("http://localhost/rfRes/org.richfaces.resource.VersionedResourceImpl.jsf?v=1_0_3"));
        resourceResponse = this.webClient.loadWebResponse(webRequest);
        ResourceHandlerImplTest.assertEquals((int)404, (int)resourceResponse.getStatusCode());
    }

    public void testCompiledCssResource() throws Exception {
        String baseResourseURL = "http://localhost/rfRes/";
        String endResourceURL = ".jsf";
        String resourceName = null;
        List<String> resources = this.populateResourcesToCheck();
        for (String resource : resources) {
            resourceName = baseResourseURL + resource + endResourceURL;
            WebRequest webRequest = new WebRequest(new URL(resourceName));
            WebResponse resourceResponse = this.webClient.loadWebResponse(webRequest);
            ResourceHandlerImplTest.assertEquals((String)resource, (int)200, (int)resourceResponse.getStatusCode());
            String expected = ResourceHandlerImplTest.readFileAsString(this.getResourceExpectedOutputFileName(resource));
            ResourceHandlerImplTest.assertEquals((String)resource, (String)this.unifyWhitespace(expected), (String)this.unifyWhitespace(resourceResponse.getContentAsString()));
        }
    }

    public void testCreateResource() throws Exception {
        this.setupFacesRequest();
        ResourceHandler resourceHandler = this.facesContext.getApplication().getResourceHandler();
        ResourceHandlerImplTest.assertNotNull((Object)resourceHandler.createResource("org.richfaces.resource.CacheableResourceImpl"));
        ResourceHandlerImplTest.assertNotNull((Object)resourceHandler.createResource("org.richfaces.resource.CacheableResourceImpl", ""));
        ResourceHandlerImplTest.assertNotNull((Object)resourceHandler.createResource("org.richfaces.resource.CacheableResourceImpl", null));
        ResourceHandlerImplTest.assertNotNull((Object)resourceHandler.createResource("defaultResourceHandlerResource.js"));
        ResourceHandlerImplTest.assertNotNull((Object)resourceHandler.createResource("libraryResource.js", "org.richfaces.resource.test"));
    }

    public void testLibraryExists() throws Exception {
        this.setupFacesRequest();
        ResourceHandler resourceHandler = this.facesContext.getApplication().getResourceHandler();
        ResourceHandlerImplTest.assertTrue((boolean)resourceHandler.libraryExists("org.richfaces.resource.test"));
    }

    private String unifyWhitespace(String source) {
        String[] chars;
        String result = source.replaceAll("(\n|\r)", "").replaceAll("\\t", " ").replaceAll(" {2,}", " ");
        for (String c : chars = new String[]{",", "\\{", "\\}"}) {
            result = result.replaceAll(" ?" + c + " ?", c);
        }
        return result;
    }

    private static String readFileAsString(String filePath) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        File testResourceFile = new File(classLoader.getResource("resources//" + filePath).getFile());
        StringBuffer fileData = new StringBuffer(1000);
        BufferedReader reader = new BufferedReader(new FileReader(testResourceFile));
        char[] buf = new char[1024];
        int numRead = 0;
        while ((numRead = reader.read(buf)) != -1) {
            String readData = String.valueOf(buf, 0, numRead);
            fileData.append(readData);
            buf = new char[1024];
        }
        reader.close();
        return fileData.toString();
    }

    private List<String> populateResourcesToCheck() {
        ArrayList<String> resources = new ArrayList<String>();
        resources.add("importedEL.ecss");
        resources.add("media.ecss");
        resources.add("fake.ecss");
        resources.add("fake2.ecss");
        resources.add("fontface.ecss");
        resources.add("full.ecss");
        resources.add("import.ecss");
        resources.add("media.ecss");
        resources.add("page.ecss");
        resources.add("resource.ecss");
        resources.add("selector.ecss");
        resources.add("skin.ecss");
        resources.add("charset.ecss");
        return resources;
    }

    private String getResourceExpectedOutputFileName(String name) {
        return name.replaceAll("ecss", "css");
    }

    static {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        currentTime = calendar.getTime();
        calendar.add(5, -1);
        lastModified = calendar.getTime();
        calendar.add(5, 15);
        expires = calendar.getTime();
    }

    private class DisabledCache
    extends com.gargoylesoftware.htmlunit.Cache {
        private static final long serialVersionUID = -1788422188914461469L;

        private DisabledCache() {
        }

        protected boolean isCacheable(WebRequest request, WebResponse response) {
            return false;
        }
    }
}

