/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.test.faces.mockito.runner.FacesMockitoRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.resource.ResourceFactoryImpl;
import org.richfaces.resource.mapping.AbstractResourceMappingTest;

@RunWith(value=FacesMockitoRunner.class)
public class ResourceFactoryImplStaticResourcesTest
extends AbstractResourceMappingTest {
    private static final String RESOURCE = "name";
    private static final String LIBRARY = "library";
    @Mock
    ExpressionFactory expressionFactory;
    private String configuredLocation;
    private Resource resourceInDefaultMapping = this.resource("library", "name", this.location("defaultMappingFilePath"));
    private Resource resourceInFirstCustomMapping = this.resource("library", "name", this.location("firstCustomMappingFilePath"));
    private Resource resourceInSecondCustomMapping = this.resource("library", "name", this.location("secondCustomMappingFilePath"));
    private Resource onlyInDefaultMappingFile = this.resource("library", "onlyInDefaultMappingFile", this.location("onlyInDefaultMappingFilePath"));
    private Resource onlyInFeatureSpecificMappingFile = this.resource("library", "onlyInFeatureSpecificMappingFile", this.location("onlyInFeatureSpecificMappingFilePath"));
    private Resource onlyInFirstCustomMappingFile = this.resource("library", "onlyInFirstCustomMappingFile", this.location("onlyInFirstCustomMappingFilePath"));
    private Resource onlyInSecondCustomMappingFile = this.resource("library", "onlyInSecondCustomMappingFile", this.location("onlyInSecondCustomMappingFilePath"));
    private Resource externalHttpResource = this.resource("library", "externalHttpResource", this.externalLocation("http://some_resource"));
    private Resource externalHttpsResource = this.resource("library", "externalHttpsResource", this.externalLocation("https://some_resource"));
    private Resource noLibraryResource = this.resource(null, "noLibraryResource", this.location("noLibraryResourcePath"));

    @Override
    public void setUp() {
        super.setUp();
        this.setupExpressionFactory();
        this.configuredLocation = "#{facesContext.externalContext.requestContextPath}/org.richfaces.resources/javax.faces.resource/";
    }

    @Test
    public void testDefaultMappingFile() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, false);
        this.verifyResourcesPresent(this.resourceInDefaultMapping);
        this.verifyResourcesInDefaultMappingFilePresent();
        this.verifyResourceNotPresent(this.onlyInFeatureSpecificMappingFile, this.onlyInFirstCustomMappingFile, this.onlyInSecondCustomMappingFile);
    }

    @Test
    public void testFeatureSpecificMappingFile() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, true);
        this.verifyResourcesPresent(this.resourceInDefaultMapping, this.onlyInFeatureSpecificMappingFile);
        this.verifyResourcesInDefaultMappingFilePresent();
        this.verifyResourceNotPresent(this.onlyInFirstCustomMappingFile, this.onlyInSecondCustomMappingFile);
    }

    @Test
    public void testFirstCustomMappingFile() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, true);
        this.configureCustomMappingFiles("mapping-test1.properties");
        this.verifyResourcesPresent(this.resourceInFirstCustomMapping, this.onlyInFeatureSpecificMappingFile, this.onlyInFirstCustomMappingFile);
        this.verifyResourcesInDefaultMappingFilePresent();
        this.verifyResourceNotPresent(this.onlyInSecondCustomMappingFile);
    }

    @Test
    public void testMultipleCustomMappingFile() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, true);
        this.configureCustomMappingFiles("mapping-test1.properties", "mapping-test2.properties");
        this.verifyResourcesPresent(this.resourceInSecondCustomMapping, this.onlyInFeatureSpecificMappingFile, this.onlyInFirstCustomMappingFile, this.onlyInSecondCustomMappingFile);
        this.verifyResourcesInDefaultMappingFilePresent();
    }

    @Test
    public void testCustomLocation() {
        this.configuredLocation = "customLocation";
        this.configure((Enum<?>)CoreConfiguration.Items.resourceMappingLocation, this.configuredLocation);
        this.testFeatureSpecificMappingFile();
    }

    private void verifyResourcesPresent(Resource ... expectedResources) {
        for (Resource expectedResource : expectedResources) {
            ResourceFactoryImpl resourceFactory = new ResourceFactoryImpl(null);
            Resource resource = resourceFactory.createResource(expectedResource.getResourceName(), expectedResource.getLibraryName(), null);
            Assert.assertNotNull((String)("resource is not present: " + expectedResource.getLibraryName() + ":" + expectedResource.getResourceName()), (Object)resource);
            Assert.assertThat((Object)resource.getRequestPath(), (Matcher)Matchers.equalTo((Object)expectedResource.getRequestPath()));
        }
    }

    private void verifyResourceNotPresent(Resource ... nonPresentResources) {
        for (Resource notPresentResource : nonPresentResources) {
            ResourceFactoryImpl resourceFactory = new ResourceFactoryImpl(null);
            Resource resource = resourceFactory.createResource(notPresentResource.getResourceName(), notPresentResource.getLibraryName(), null);
            Assert.assertNull((Object)resource);
        }
    }

    private void verifyResourcesInDefaultMappingFilePresent() {
        this.verifyResourcesPresent(this.onlyInDefaultMappingFile, this.externalHttpResource, this.externalHttpsResource, this.noLibraryResource);
    }

    private void configureCustomMappingFiles(String ... customMappingFiles) {
        String packagePath = this.getClass().getPackage().getName().replace('.', '/');
        StringBuffer mappingFiles = new StringBuffer();
        for (String mappingFile : customMappingFiles) {
            if (mappingFiles.length() > 0) {
                mappingFiles.append(',');
            }
            mappingFiles.append(packagePath);
            mappingFiles.append('/');
            mappingFiles.append(mappingFile);
        }
        this.configure((Enum<?>)CoreConfiguration.Items.resourceMappingFile, mappingFiles.toString());
    }

    private Resource resource(String library, String name, final Location location) {
        Resource resource = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resource.getLibraryName()).thenReturn((Object)library);
        Mockito.when((Object)resource.getResourceName()).thenReturn((Object)name);
        Mockito.when((Object)resource.getRequestPath()).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return location.getRequestPath();
            }
        });
        return resource;
    }

    private Location location(final String location) {
        return new Location(){

            @Override
            public String getRequestPath() {
                return ResourceFactoryImplStaticResourcesTest.this.configuredLocation + location;
            }
        };
    }

    private Location externalLocation(final String location) {
        return new Location(){

            @Override
            public String getRequestPath() {
                return location;
            }
        };
    }

    private void setupExpressionFactory() {
        Mockito.when((Object)this.application.getExpressionFactory()).thenReturn((Object)this.expressionFactory);
        Mockito.when((Object)this.expressionFactory.createValueExpression((ELContext)Mockito.any(ELContext.class), Mockito.anyString(), (Class)Mockito.any(Class.class))).thenAnswer((Answer)new Answer<ValueExpression>(){

            public ValueExpression answer(InvocationOnMock invocation) throws Throwable {
                String expression = (String)invocation.getArguments()[1];
                ValueExpression valueExpression = (ValueExpression)Mockito.mock(ValueExpression.class);
                Mockito.when((Object)valueExpression.getValue(ResourceFactoryImplStaticResourcesTest.this.elContext)).thenReturn((Object)expression);
                return valueExpression;
            }
        });
    }

    private static interface Location {
        public String getRequestPath();
    }
}

