/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import java.util.Arrays;
import java.util.List;
import org.jboss.test.faces.mockito.runner.FacesMockitoRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.resource.mapping.AbstractResourceMappingTest;
import org.richfaces.resource.mapping.PropertiesMappingConfiguration;
import org.richfaces.resource.mapping.ResourceLoadingOptimizationConfiguration;

@RunWith(value=FacesMockitoRunner.class)
public class ResourceMappingConfigurationTest
extends AbstractResourceMappingTest {
    @Test
    public void testMappingDisabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, false);
        boolean enabled = ResourceLoadingOptimizationConfiguration.isEnabled();
        Assert.assertFalse((boolean)enabled);
    }

    @Test
    public void testMappingEnabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, true);
        boolean enabled = ResourceLoadingOptimizationConfiguration.isEnabled();
        Assert.assertTrue((boolean)enabled);
    }

    @Test
    public void testLocationIsNull() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceMappingLocation, (String)null);
        String location = PropertiesMappingConfiguration.getLocation();
        Assert.assertNull((Object)location);
    }

    @Test
    public void testLocationConfiguredWithResourceMappingLocationSwitch() {
        String expected = "some_location";
        this.configure((Enum<?>)CoreConfiguration.Items.resourceMappingLocation, expected);
        String location = PropertiesMappingConfiguration.getLocation();
        Assert.assertEquals((Object)expected, (Object)location);
    }

    @Test
    public void testMappingFileIsNull() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceMappingFile, (String)null);
        List mappingFiles = PropertiesMappingConfiguration.getMappingFiles();
        Assert.assertEquals(Arrays.asList("META-INF/richfaces/static-resource-mappings.properties"), (Object)mappingFiles);
    }

    @Test
    public void testMappingFileConfiguredUsingStaticResourceLocation() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceMappingFile, (String)null);
        List mappingFiles = PropertiesMappingConfiguration.getMappingFiles();
        Assert.assertEquals(Arrays.asList("META-INF/richfaces/static-resource-mappings.properties"), (Object)mappingFiles);
    }

    @Test
    public void testMappingFileConfiguredWithResourceMappingFileSwitch() {
        String expected = "some_file";
        this.configure((Enum<?>)CoreConfiguration.Items.resourceMappingFile, expected);
        List mappingFiles = PropertiesMappingConfiguration.getMappingFiles();
        Assert.assertEquals(Arrays.asList("META-INF/richfaces/static-resource-mappings.properties", expected), (Object)mappingFiles);
    }
}

