/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import java.util.Arrays;
import java.util.List;
import javax.faces.application.ProjectStage;
import org.jboss.test.faces.mockito.runner.FacesMockitoRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.richfaces.application.CoreConfiguration;
import org.richfaces.resource.mapping.AbstractResourceMappingTest;
import org.richfaces.resource.mapping.PropertiesMappingConfiguration;

@RunWith(value=FacesMockitoRunner.class)
public class ResourceMappingFeatureMappingTest
extends AbstractResourceMappingTest {
    private static final String DEFAULT = "META-INF/richfaces/static-resource-mappings.properties";
    private static final String STATIC = "META-INF/richfaces/optimizedResourcesMapping/Static.properties";
    private static final String PACKED = "META-INF/richfaces/optimizedResourcesMapping/Packed.properties";
    private static final String COMPRESSED = "META-INF/richfaces/optimizedResourcesMapping/Compressed.properties";
    private static final String PACKED_COMPRESSED = "META-INF/richfaces/optimizedResourcesMapping/PackedCompressed.properties";

    @Test
    public void testDefaultMappingFilesWhenResourceLoadingOptimizationDisabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, false);
        this.testMappingFile(null, DEFAULT);
    }

    @Test
    public void testDefaultMappingFileWhenResourceLoadingOptimizationEnabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, true);
        this.testMappingFile(null, STATIC, DEFAULT);
    }

    @Test
    public void testCustomMappingFileWhenResourceLoadingOptimizationDisabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, false);
        this.testMappingFile("some_path", DEFAULT, "some_path");
    }

    @Test
    public void testCustomMappingFileWhenResourceLoadingOptimizationEnabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, true);
        this.testMappingFile("some_path", STATIC, DEFAULT, "some_path");
    }

    @Test
    public void testMultipleMappingFiles() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, true);
        this.testMappingFile("some_path,another_path", STATIC, DEFAULT, "some_path", "another_path");
    }

    @Test
    public void testCustomStagesWhenResourceLoadingOptimizationDisabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, false);
        Mockito.when((Object)this.application.getProjectStage()).thenReturn((Object)ProjectStage.Development);
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationPackagingStages, "All");
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationCompressionStages, "All");
        this.testMappingFile(null, DEFAULT);
    }

    @Test
    public void testCustomStagesWhenResourceLoadingOptimizationEnabled() {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationEnabled, true);
        Mockito.when((Object)this.application.getProjectStage()).thenReturn((Object)ProjectStage.Development);
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationPackagingStages, "None");
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationCompressionStages, "None");
        this.testMappingFile(null, STATIC, DEFAULT);
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationPackagingStages, "All");
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationCompressionStages, "All");
        this.testMappingFile(null, PACKED_COMPRESSED, DEFAULT);
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationPackagingStages, "Development");
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationCompressionStages, "Production");
        this.testMappingFile(null, PACKED, DEFAULT);
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationPackagingStages, "Production");
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationCompressionStages, "Development");
        this.testMappingFile(null, COMPRESSED, DEFAULT);
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationPackagingStages, "Development,Production");
        this.configure((Enum<?>)CoreConfiguration.Items.resourceOptimizationCompressionStages, "Production,Development");
        this.testMappingFile(null, PACKED_COMPRESSED, DEFAULT);
    }

    private void testMappingFile(String configuredValue, String ... expectedResolvedMappingFiles) {
        this.configure((Enum<?>)CoreConfiguration.Items.resourceMappingFile, configuredValue);
        List mappingFiles = PropertiesMappingConfiguration.getMappingFiles();
        Assert.assertEquals(Arrays.asList(expectedResolvedMappingFiles), (Object)mappingFiles);
    }
}

