/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.skin;

import java.util.HashMap;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.richfaces.ContextInitParameter;
import org.richfaces.ContextInitParameters;
import org.richfaces.FacesRequestSetupRule;
import org.richfaces.skin.CompositeSkinImpl;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public class SkinTestCase {
    @Rule
    public FacesRequestSetupRule rule = new FacesRequestSetupRule();

    private void addParameters(FacesContext facesContext, Object[][] strings) {
        HashMap<Object, Object> baseMap = new HashMap<Object, Object>();
        for (Object[] objects : strings) {
            baseMap.put(objects[0], objects[1]);
        }
        facesContext.getExternalContext().getRequestMap().put("test", baseMap);
    }

    @Test
    public void testGetInstance() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        SkinFactory factory1 = SkinFactory.getInstance((FacesContext)facesContext);
        Assert.assertSame((Object)factory, (Object)factory1);
    }

    @Test
    @ContextInitParameter(name="org.richfaces.skin", value="test")
    public void testGetSkin() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.addParameters(facesContext, new Object[][]{{"bean", "test.value"}});
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        Skin skin = factory.getSkin(facesContext);
        Assert.assertNotNull((String)"Null skin!", (Object)skin);
        Assert.assertEquals((Object)"string", (Object)skin.getParameter(facesContext, "string.property"));
        Assert.assertEquals((Object)"base.string", (Object)skin.getParameter(facesContext, "base.property"));
        Assert.assertEquals((Object)"test.value", (Object)skin.getParameter(facesContext, "bind.property"));
    }

    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.skin", value="test"), @ContextInitParameter(name="org.richfaces.baseSkin", value="DEFAULT")})
    public void testSkinReferences() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        Skin skin = factory.getSkin(facesContext);
        Assert.assertNotNull((String)"Null skin!", (Object)skin);
        Assert.assertEquals((Object)"default", (Object)skin.getParameter(facesContext, "c"));
        Assert.assertEquals((Object)"yyy", (Object)skin.getParameter(facesContext, "y"));
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.skin", value="style"), @ContextInitParameter(name="org.richfaces.baseSkin", value="style_base")})
    public void testSkinReferences1() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        Skin skin = factory.getSkin(facesContext);
        Assert.assertNotNull((String)"Null skin!", (Object)skin);
        Assert.assertEquals((Object)"#F5F0E7", (Object)skin.getParameter(facesContext, "intermediateTextColor"));
        Assert.assertEquals((Object)"10px", (Object)skin.getParameter(facesContext, "intermediateTextSize"));
        Assert.assertEquals((Object)"#F5F0E7", (Object)skin.getParameter(facesContext, "generalTextColor"));
        Assert.assertEquals((Object)"white.textcolor", (Object)skin.getParameter(facesContext, "additionalTextColor"));
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.skin", value="dynatest"), @ContextInitParameter(name="org.richfaces.baseSkin", value="dynatest_base")})
    public void testBaseSkin() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        this.addParameters(facesContext, new Object[][]{{"bean", "dynabase1"}});
        Skin skin = factory.getSkin(facesContext);
        Assert.assertEquals((Object)"default", (Object)skin.getParameter(facesContext, "default"));
        Assert.assertEquals((Object)"itself", (Object)skin.getParameter(facesContext, "selfValue"));
        Assert.assertEquals((Object)"#AAA", (Object)skin.getParameter(facesContext, "customFormColor"));
        Map map = (Map)facesContext.getExternalContext().getRequestMap().get("test");
        map.put("bean", "dynabase2");
        Assert.assertEquals((Object)"xxx", (Object)skin.getParameter(facesContext, "default"));
        Assert.assertEquals((Object)"itself", (Object)skin.getParameter(facesContext, "selfValue"));
        Assert.assertEquals((Object)"#AAA", (Object)skin.getParameter(facesContext, "customFormColor"));
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.skin", value="cyclic")})
    public void testCyclicSkinReferences() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        try {
            Skin skin = factory.getSkin(facesContext);
            skin.getParameter(facesContext, "x");
            Assert.fail();
        }
        catch (FacesException facesException) {
            // empty catch block
        }
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.skin", value="noref")})
    public void testBadSkinReferences() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        try {
            Skin skin = factory.getSkin(facesContext);
            skin.getParameter(facesContext, "x");
            Assert.fail();
        }
        catch (FacesException facesException) {
            // empty catch block
        }
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.skin", value="#{test.skin}")})
    public void testGetBindedSkin() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        this.addParameters(facesContext, new Object[][]{{"skin", "bindedtest"}, {"bean", "binded.test.value"}});
        Skin skin = factory.getSkin(facesContext);
        Assert.assertNotNull((String)"Null skin!", (Object)skin);
        Assert.assertEquals((Object)"bindedstring", (Object)skin.getParameter(facesContext, "string.property"));
        Assert.assertEquals((Object)"binded.test.value", (Object)skin.getParameter(facesContext, "bind.property"));
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.skin", value="#{test.skin}")})
    public void testSkinHash() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        this.addParameters(facesContext, new Object[][]{{"skin", "bindedtest"}, {"bean", "binded.test.value"}});
        Skin skin = factory.getSkin(facesContext);
        int hash = skin.hashCode(facesContext);
        Assert.assertEquals((long)hash, (long)skin.hashCode(facesContext));
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        Map map = (Map)requestMap.get("test");
        ((CompositeSkinImpl)skin).resetCachedHashCode();
        map.put("bean", "other.test.value");
        Assert.assertFalse((hash == skin.hashCode(facesContext) ? 1 : 0) != 0);
    }

    @Test
    public void testGetDefaultProperties() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        Assert.assertEquals((Object)"default", (Object)factory.getDefaultSkin(facesContext).getParameter(facesContext, "a"));
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.skin", value="plain")})
    public void testPlainSkin() throws Exception {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        Assert.assertNull((Object)factory.getSkin(facesContext).getParameter(facesContext, "generalBackgroundColor"));
    }

    @Test
    @ContextInitParameters(value={@ContextInitParameter(name="org.richfaces.baseSkin", value="plain")})
    public void testPlainSkinBase() throws Exception {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        SkinFactory factory = SkinFactory.getInstance((FacesContext)facesContext);
        Assert.assertNull((Object)factory.getBaseSkin(facesContext).getParameter(facesContext, "generalBackgroundColor"));
    }
}

