/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

import java.io.Writer;
import java.lang.reflect.Array;
import java.util.Random;
import javax.faces.context.ResponseWriter;
import junit.framework.TestCase;
import org.ajax4jsf.javascript.ResponseWriterWrapper;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.jboss.test.faces.mock.MockFacesEnvironment;

public class ResponseWriterWrapperTest
extends TestCase {
    private MockFacesEnvironment facesEnvironment;
    private ResponseWriter mockWriter;
    private Writer writer;

    protected void setUp() throws Exception {
        super.setUp();
        this.facesEnvironment = MockFacesEnvironment.createEnvironment();
        this.mockWriter = (ResponseWriter)this.facesEnvironment.createMock(ResponseWriter.class);
        this.writer = new ResponseWriterWrapper(this.mockWriter);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.facesEnvironment.verify();
        this.facesEnvironment.release();
        this.facesEnvironment = null;
        this.writer = null;
        this.mockWriter = null;
    }

    public void testWrite1() throws Exception {
        char[] cs = new char[]{'a', 'b'};
        this.mockWriter.writeText(cs, 0, 2);
        this.facesEnvironment.replay();
        this.writer.write(cs);
    }

    private static char[] expectSingleChar(final char c) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){
            private String failureMessage;

            public void appendTo(StringBuffer sb) {
                sb.append(this.failureMessage);
            }

            public boolean matches(Object o) {
                if (!(o instanceof char[])) {
                    this.failureMessage = "Array of chars expected as argument";
                } else if (Array.getLength(o) == 0) {
                    this.failureMessage = "Array should be of non-zero length";
                } else if (Array.getChar(o, 0) != c) {
                    this.failureMessage = "[" + c + "] expected as [0] char";
                }
                return this.failureMessage == null;
            }
        });
        return null;
    }

    private static char[] expectFirstChars(char[] cs) {
        return ResponseWriterWrapperTest.expectFirstChars(cs, cs.length);
    }

    private static char[] expectFirstChars(final char[] cs, final int length) {
        EasyMock.reportMatcher((IArgumentMatcher)new IArgumentMatcher(){
            private String failureMessage;

            public void appendTo(StringBuffer sb) {
                sb.append(this.failureMessage);
            }

            public boolean matches(Object o) {
                if (!(o instanceof char[])) {
                    this.failureMessage = "Array of chars expected as argument";
                } else {
                    char[] argChars = (char[])o;
                    if (argChars.length < length) {
                        this.failureMessage = "Array should have minimum " + length + " length, but has only: " + argChars.length;
                    } else {
                        for (int i = 0; i < length; ++i) {
                            if (argChars[i] == cs[i]) continue;
                            this.failureMessage = "Char at offset [" + i + "] mismath: expected " + cs[i] + " but was " + argChars[i];
                            break;
                        }
                    }
                }
                return this.failureMessage == null;
            }
        });
        return null;
    }

    public void testWrite2() throws Exception {
        this.mockWriter.writeText(ResponseWriterWrapperTest.expectSingleChar('\u5678'), EasyMock.eq((int)0), EasyMock.eq((int)1));
        this.mockWriter.writeText(ResponseWriterWrapperTest.expectSingleChar('\uba98'), EasyMock.eq((int)0), EasyMock.eq((int)1));
        this.facesEnvironment.replay();
        this.writer.write(305419896);
        this.writer.write(-20071784);
    }

    public void testWrite3() throws Exception {
        this.mockWriter.writeText(EasyMock.eq((Object)"test"), (String)EasyMock.isNull());
        this.facesEnvironment.replay();
        this.writer.write("test");
    }

    public void testWrite4() throws Exception {
        this.mockWriter.writeText(EasyMock.aryEq((char[])"abcd".toCharArray()), EasyMock.eq((int)1), EasyMock.eq((int)2));
        this.mockWriter.writeText(EasyMock.aryEq((char[])"efgh".toCharArray()), EasyMock.eq((int)0), EasyMock.eq((int)3));
        this.mockWriter.writeText(EasyMock.aryEq((char[])"ijklm".toCharArray()), EasyMock.eq((int)2), EasyMock.eq((int)3));
        this.facesEnvironment.replay();
        this.writer.write("abcd".toCharArray(), 1, 2);
        this.writer.write("efgh".toCharArray(), 0, 3);
        this.writer.write("ijklm".toCharArray(), 2, 3);
    }

    public void testWrite5() throws Exception {
        this.mockWriter.writeText(ResponseWriterWrapperTest.expectFirstChars("string to".toCharArray()), EasyMock.eq((int)0), EasyMock.eq((int)9));
        this.mockWriter.writeText(ResponseWriterWrapperTest.expectFirstChars("one".toCharArray()), EasyMock.eq((int)0), EasyMock.eq((int)3));
        this.facesEnvironment.replay();
        this.writer.write("string to test", 0, 9);
        this.writer.write("short one", 6, 3);
    }

    public void testWrite6() throws Exception {
        char[] cs = new char[4098];
        int length = cs.length - 2;
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = (char)new Random().nextInt(65536);
        }
        this.mockWriter.writeText(ResponseWriterWrapperTest.expectFirstChars(cs, length), EasyMock.eq((int)0), EasyMock.eq((int)length));
        this.facesEnvironment.replay();
        this.writer.write(String.valueOf(cs), 0, length);
    }

    public void testFlush() throws Exception {
        this.mockWriter.flush();
        this.facesEnvironment.replay();
        this.writer.flush();
    }

    public void testClose() throws Exception {
        this.mockWriter.close();
        this.facesEnvironment.replay();
        this.writer.close();
    }
}

