/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.javascript;

import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.faces.context.ResponseWriter;
import junit.framework.TestCase;
import org.ajax4jsf.javascript.JSLiteral;
import org.ajax4jsf.javascript.ScriptUtils;
import org.easymock.Capture;
import org.easymock.CaptureType;
import org.easymock.EasyMock;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.test.faces.mock.MockFacesEnvironment;
import org.junit.Assert;
import org.junit.Test;

public class ScriptUtilsTest
extends TestCase {
    public ScriptUtilsTest(String name) {
        super(name);
    }

    private static String dehydrate(String s) {
        return s != null ? s.replaceAll("\\s", "") : s;
    }

    public void testStringToScript() {
        String obj = "f \b\r\t\f\n\"'\\/ oo ]&<>-";
        ScriptUtilsTest.assertEquals((String)"\"f \\b\\r\\t\\f\\n\\\"'\\\\\\/ oo \\u005D\\u0026\\u003C\\u003E\\u002D\"", (String)ScriptUtils.toScript((Object)obj));
    }

    public void testArrayToScript() {
        int[] obj = new int[]{1, 2, 3, 4, 5};
        ScriptUtilsTest.assertEquals((String)"[1,2,3,4,5] ", (String)ScriptUtils.toScript((Object)obj));
    }

    public void testSqlDate() {
        Time obj = new Time(1L);
        String timeString = ScriptUtils.toScript((Object)obj);
        timeString = ScriptUtils.toScript((Object)obj);
        timeString = ScriptUtils.toScript((Object)obj);
        timeString = ScriptUtils.toScript((Object)obj);
        timeString = ScriptUtils.toScript((Object)obj);
        ScriptUtilsTest.assertNotNull((Object)timeString);
        ScriptUtilsTest.assertFalse((boolean)timeString.contains("year"));
        Date obj1 = new Date(1L);
        String dateString = ScriptUtils.toScript((Object)obj1);
        ScriptUtilsTest.assertNotNull((Object)dateString);
        ScriptUtilsTest.assertFalse((boolean)dateString.contains("seconds"));
    }

    public void testTwoDimentionalArrayToScript() {
        int[][] obj = new int[][]{{1, 2}, {3, 4}};
        ScriptUtilsTest.assertEquals((String)"[[1,2] ,[3,4] ] ", (String)ScriptUtils.toScript((Object)obj));
    }

    public void testTwoDimentionalStringArrayToScript() {
        String[][] obj = new String[][]{{"one", "two"}, {"three", "four"}};
        ScriptUtilsTest.assertEquals((String)"[[\"one\",\"two\"] ,[\"three\",\"four\"] ] ", (String)ScriptUtils.toScript((Object)obj));
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        map.put("a", obj);
        map.put("b", "c");
        ScriptUtilsTest.assertEquals((String)"{\"a\":[[\"one\",\"two\"] ,[\"three\",\"four\"] ] ,\"b\":\"c\"} ", (String)ScriptUtils.toScript(map));
    }

    public void testListToScript() {
        ArrayList<Integer> obj = new ArrayList<Integer>();
        obj.add(new Integer(1));
        obj.add(new Integer(2));
        obj.add(new Integer(3));
        obj.add(new Integer(4));
        obj.add(new Integer(5));
        ScriptUtilsTest.assertEquals((String)"[1,2,3,4,5] ", (String)ScriptUtils.toScript(obj));
    }

    public void testSetToScript() {
        TreeSet<Integer> obj = new TreeSet<Integer>();
        obj.add(new Integer(1));
        obj.add(new Integer(2));
        obj.add(new Integer(3));
        obj.add(new Integer(4));
        obj.add(new Integer(5));
        ScriptUtilsTest.assertEquals((String)"[1,2,3,4,5] ", (String)ScriptUtils.toScript(obj));
    }

    public void testObjectArrayToScript() {
        Bean[] obj = new Bean[]{new Bean(1, true, "foo"), new Bean(2, false, "bar")};
        ScriptUtilsTest.assertEquals((String)"[{\"bool\":true,\"foo\":\"foo\",\"integer\":1} ,{\"bool\":false,\"foo\":\"bar\",\"integer\":2} ] ", (String)ScriptUtils.toScript((Object)obj));
    }

    public void testObjectListToScript() {
        Bean[] array = new Bean[]{new Bean(1, true, "foo"), new Bean(2, false, "bar")};
        List<Bean> obj = Arrays.asList(array);
        ScriptUtilsTest.assertEquals((String)"[{\"bool\":true,\"foo\":\"foo\",\"integer\":1} ,{\"bool\":false,\"foo\":\"bar\",\"integer\":2} ] ", (String)ScriptUtils.toScript(obj));
    }

    public void testMapToScript() {
        TreeMap<String, String> obj = new TreeMap<String, String>();
        obj.put("a", "foo");
        obj.put("b", "bar");
        obj.put("c", "baz");
        ScriptUtilsTest.assertEquals((String)"{\"a\":\"foo\",\"b\":\"bar\",\"c\":\"baz\"} ", (String)ScriptUtils.toScript(obj));
    }

    public void testAddEncodedString() throws Exception {
        StringBuilder buff = new StringBuilder();
        ScriptUtils.appendEncodedString((Appendable)buff, (Object)"foo");
        ScriptUtilsTest.assertEquals((String)"\"foo\"", (String)buff.toString());
    }

    public void testAddEncoded() throws Exception {
        StringBuilder buff = new StringBuilder();
        ScriptUtils.appendEncoded((Appendable)buff, (Object)"foo");
        ScriptUtilsTest.assertEquals((String)"foo", (String)buff.toString());
    }

    public void testNull() throws Exception {
        ScriptUtilsTest.assertEquals((String)"null", (String)ScriptUtils.toScript(null));
    }

    public void testScriptString() throws Exception {
        ScriptUtilsTest.assertEquals((String)"alert(x<y);", (String)ScriptUtils.toScript((Object)new JSLiteral("alert(x<y);")));
    }

    public void testEnum() throws Exception {
        ScriptUtilsTest.assertEquals((String)"\"TestEnum: B\"", (String)ScriptUtils.toScript((Object)((Object)TestEnum.B)));
    }

    public void testCharacter() throws Exception {
        ScriptUtilsTest.assertEquals((String)"\"N\"", (String)ScriptUtils.toScript((Object)Character.valueOf('N')));
    }

    private void assertCaptureEquals(Capture<? extends Object> capture, String expected) {
        StringBuilder sb = new StringBuilder();
        List list = capture.getValues();
        for (Object o : list) {
            ScriptUtilsTest.assertNotNull(o);
            sb.append(o);
        }
        ScriptUtilsTest.assertEquals((String)expected, (String)sb.toString().trim());
    }

    public void testWriteToStream() throws Exception {
        MockFacesEnvironment environment = MockFacesEnvironment.createEnvironment();
        ResponseWriter mockWriter = (ResponseWriter)environment.createMock(ResponseWriter.class);
        Capture<Object> capture = new Capture<Object>(CaptureType.ALL){
            private static final long serialVersionUID = -4915440411892856583L;

            public void setValue(Object value) {
                if (value instanceof char[]) {
                    char[] cs = (char[])value;
                    super.setValue((Object)new String(cs, 0, 1));
                } else {
                    super.setValue(value);
                }
            }
        };
        mockWriter.writeText(EasyMock.capture((Capture)capture), (String)EasyMock.isNull());
        EasyMock.expectLastCall().anyTimes();
        mockWriter.writeText((char[])EasyMock.capture((Capture)capture), EasyMock.eq((int)0), EasyMock.eq((int)1));
        EasyMock.expectLastCall().anyTimes();
        environment.replay();
        ScriptUtils.writeToStream((ResponseWriter)mockWriter, Collections.singletonMap("delay", 1500));
        environment.verify();
        this.assertCaptureEquals((Capture<? extends Object>)capture, "{\"delay\":1500}");
        environment.release();
    }

    public void testCircularReferenceBeans() throws Exception {
        ReferenceHolderBean parent = new ReferenceHolderBean("parent");
        ReferencedBean child = new ReferencedBean("child", parent);
        ScriptUtilsTest.assertEquals((String)ScriptUtilsTest.dehydrate("{\"name\": \"child\", \"parent\": {\"name\": \"parent\", \"reference\": null}}"), (String)ScriptUtilsTest.dehydrate(ScriptUtils.toScript((Object)child)));
    }

    public void testCircularReferenceViaProperty() throws Exception {
        ReferenceHolderBean parent = new ReferenceHolderBean("parent");
        ReferencedBean child = new ReferencedBean("child", parent);
        parent.setReference(child);
        ScriptUtilsTest.assertEquals((String)ScriptUtilsTest.dehydrate("{\"name\": \"parent\", \"reference\": {\"name\": \"child\", \"parent\": null}}"), (String)ScriptUtilsTest.dehydrate(ScriptUtils.toScript((Object)parent)));
    }

    public void testCircularReferenceViaArray() throws Exception {
        ReferenceHolderBean parent = new ReferenceHolderBean("parent");
        ReferencedBean child = new ReferencedBean("child", parent);
        parent.setReference(new Object[]{child});
        ScriptUtilsTest.assertEquals((String)ScriptUtilsTest.dehydrate("{\"name\": \"parent\", \"reference\": [{\"name\": \"child\", \"parent\": null}]}"), (String)ScriptUtilsTest.dehydrate(ScriptUtils.toScript((Object)parent)));
    }

    public void testCircularReferenceViaCollection() throws Exception {
        ReferenceHolderBean parent = new ReferenceHolderBean("parent");
        ReferencedBean child = new ReferencedBean("child", parent);
        ArrayList<ReferencedBean> set = new ArrayList<ReferencedBean>();
        set.add(child);
        parent.setReference(set);
        ScriptUtilsTest.assertEquals((String)ScriptUtilsTest.dehydrate("{\"name\": \"parent\", \"reference\": [{\"name\": \"child\", \"parent\": null}]}"), (String)ScriptUtilsTest.dehydrate(ScriptUtils.toScript((Object)parent)));
    }

    public void testCircularReferenceViaMap() throws Exception {
        ReferenceHolderBean parent = new ReferenceHolderBean("parent");
        ReferencedBean child = new ReferencedBean("child", parent);
        HashMap<String, ReferencedBean> map = new HashMap<String, ReferencedBean>();
        map.put("key", child);
        parent.setReference(map);
        ScriptUtilsTest.assertEquals((String)ScriptUtilsTest.dehydrate("{\"name\": \"parent\", \"reference\": {\"key\": {\"name\": \"child\", \"parent\": null}}}"), (String)ScriptUtilsTest.dehydrate(ScriptUtils.toScript((Object)parent)));
    }

    @Test
    public void testEscapeStringForCSSSelector() throws Exception {
        ScriptUtilsTest.assertNull((Object)ScriptUtils.escapeCSSMetachars(null));
        ScriptUtilsTest.assertEquals((String)"", (String)ScriptUtils.escapeCSSMetachars((String)""));
        ScriptUtilsTest.assertEquals((String)"test", (String)ScriptUtils.escapeCSSMetachars((String)"test"));
        ScriptUtilsTest.assertEquals((String)"test\\.string", (String)ScriptUtils.escapeCSSMetachars((String)"test.string"));
        ScriptUtilsTest.assertEquals((String)"test\\.\\=string", (String)ScriptUtils.escapeCSSMetachars((String)"test.=string"));
        ScriptUtilsTest.assertEquals((String)"some\\.test\\=string", (String)ScriptUtils.escapeCSSMetachars((String)"some.test=string"));
        ScriptUtilsTest.assertEquals((String)"\\#test", (String)ScriptUtils.escapeCSSMetachars((String)"#test"));
        ScriptUtilsTest.assertEquals((String)"\\#\\=test", (String)ScriptUtils.escapeCSSMetachars((String)"#=test"));
        ScriptUtilsTest.assertEquals((String)"test\\#", (String)ScriptUtils.escapeCSSMetachars((String)"test#"));
        ScriptUtilsTest.assertEquals((String)"test\\#\\=", (String)ScriptUtils.escapeCSSMetachars((String)"test#="));
    }

    @Test
    public void testTimezoneSerialization() throws Exception {
        TimeZone utcPlusTwoTZ = TimeZone.getTimeZone("GMT+02:00");
        String serializedUTCPlusTwoTZ = ScriptUtilsTest.dehydrate(ScriptUtils.toScript((Object)utcPlusTwoTZ));
        Assert.assertThat((Object)serializedUTCPlusTwoTZ, (Matcher)CoreMatchers.containsString((String)"\"DSTSavings\":0"));
        Assert.assertThat((Object)serializedUTCPlusTwoTZ, (Matcher)CoreMatchers.containsString((String)"\"ID\":\"GMT+02:00\""));
        Assert.assertThat((Object)serializedUTCPlusTwoTZ, (Matcher)CoreMatchers.containsString((String)"\"rawOffset\":7200000"));
        TimeZone pstTimeZone = TimeZone.getTimeZone("PST");
        String serializedPSTTimeZone = ScriptUtilsTest.dehydrate(ScriptUtils.toScript((Object)pstTimeZone));
        Assert.assertThat((Object)serializedPSTTimeZone, (Matcher)CoreMatchers.containsString((String)"\"ID\":\"PST\""));
        Assert.assertThat((Object)serializedPSTTimeZone, (Matcher)CoreMatchers.containsString((String)"\"rawOffset\":-28800000"));
        TimeZone sfTimeZone = TimeZone.getTimeZone("America/New_York");
        String serializedSFTimeZone = ScriptUtilsTest.dehydrate(ScriptUtils.toScript((Object)sfTimeZone));
        Assert.assertThat((Object)serializedSFTimeZone, (Matcher)CoreMatchers.containsString((String)"\"ID\":\"America\\/New_York\""));
        Assert.assertThat((Object)serializedSFTimeZone, (Matcher)CoreMatchers.containsString((String)"\"rawOffset\":-18000000"));
    }

    @Test
    public void testGetMD5scriptHash() throws Exception {
        String testString = "Some string to hash";
        String expectedMD5hash = "7624f3fd394f02f0ff8c53fac249129a";
        String computedMD5hash = ScriptUtils.getMD5scriptHash((String)testString);
        ScriptUtilsTest.assertEquals((String)expectedMD5hash, (String)computedMD5hash);
    }

    public static class Bean {
        private boolean bool;
        private Object foo;
        private int integer;

        public Bean() {
        }

        public Bean(int ineger, boolean bool, Object foo) {
            this.integer = ineger;
            this.bool = bool;
            this.foo = foo;
        }

        public boolean isBool() {
            return this.bool;
        }

        public void setBool(boolean bool) {
            this.bool = bool;
        }

        public int getInteger() {
            return this.integer;
        }

        public void setInteger(int ineger) {
            this.integer = ineger;
        }

        public Object getFoo() {
            return this.foo;
        }

        public void setFoo(Object foo) {
            this.foo = foo;
        }
    }

    public static class ReferenceHolderBean {
        private String name;
        private Object reference;

        public ReferenceHolderBean(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public Object getReference() {
            return this.reference;
        }

        public void setReference(Object reference) {
            this.reference = reference;
        }
    }

    public static class ReferencedBean {
        private String name;
        private ReferenceHolderBean parent;

        public ReferencedBean(String name, ReferenceHolderBean parent) {
            this.name = name;
            this.parent = parent;
        }

        public ReferenceHolderBean getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum TestEnum {
        A,
        B,
        C;


        public String toString() {
            return "TestEnum: " + super.toString();
        }
    }
}

