/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.net.MalformedURLException;
import org.jboss.test.faces.FacesEnvironment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UIViewResourceTest {
    private FacesEnvironment environment;

    @Before
    public void setUp() {
        this.environment = FacesEnvironment.createEnvironment().withContent("/test.xhtml", "<html xmlns=\"http://www.w3.org/1999/xhtml\"\n      xmlns:ui=\"http://java.sun.com/jsf/facelets\"\n      xmlns:h=\"http://java.sun.com/jsf/html\"><h:body>\n<h:form id=\"helloForm\" >    <h:inputText id=\"input\" value=\"#{test.value}\" />\n    <h:commandButton id=\"command\" value=\"Ok\" action=\"#{test.action}\"/>\n</h:form>\n</h:body>\n</html>").withResource("/WEB-INF/faces-config.xml", "org/richfaces/faces-config.xml").start();
    }

    @After
    public void thearDown() throws Exception {
        this.environment.release();
        this.environment = null;
    }

    @Test
    public void testRequest() throws Exception {
        FacesEnvironment.FacesRequest request = this.environment.createFacesRequest("http://localhost/test.jsf?foo=bar");
        Assert.assertNotNull((Object)request.execute());
        String contentAsString = request.getConnection().getContentAsString();
        Assert.assertFalse((boolean)contentAsString.contains("function foo(id){alert(id);}"));
        FacesEnvironment.FacesRequest request2 = this.submit(request).submit();
        request2.execute();
        String content2 = request2.getConnection().getContentAsString();
        Assert.assertFalse((boolean)content2.contains("function foo(id){alert(id);}"));
    }

    private FacesEnvironment.FacesRequest submit(FacesEnvironment.FacesRequest request) throws MalformedURLException {
        FacesEnvironment.FacesRequest request2 = request.submit().withParameter("helloForm:input", "BAZ").withParameter("helloForm:command", "Ok");
        request2.execute();
        String content2 = request2.getConnection().getContentAsString();
        Assert.assertTrue((boolean)content2.contains("function foo(id){alert(id);}"));
        return request2;
    }
}

