/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import com.sun.faces.component.visit.PartialVisitContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.application.Application;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitHint;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import org.jboss.test.faces.FacesEnvironment;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.richfaces.context.AjaxOutputComponentImpl;
import org.richfaces.context.AjaxTableComponentImpl;
import org.richfaces.context.BaseExtendedVisitContext;
import org.richfaces.context.ExtendedRenderVisitContext;
import org.richfaces.context.ExtendedVisitContext;

public class ExtendedPartialVisitContextTest {
    private FacesEnvironment environment;
    private FacesEnvironment.FacesRequest facesRequest;
    private FacesContext facesContext;
    private Application application;
    private UIViewRoot viewRoot;
    private UIForm form;
    private AjaxOutputComponentImpl outerOutput;
    private AjaxTableComponentImpl table;
    private UIOutput dataHeader;
    private AjaxOutputComponentImpl nestedOutput;
    private UIOutput nestedText;
    private List<String> tableData;
    private BaseExtendedVisitContext renderingContext;
    private TrackingVisitCallback trackingVisitCallback;
    private ArrayList<String> nestedTableData;
    private AjaxTableComponentImpl nestedTable;
    private UIOutput nestedTableText;
    private UIOutput nestedTableFooter;

    private static void assertEqualSets(Collection<?> expected, Collection<?> actual) {
        Assert.assertEquals(ExtendedPartialVisitContextTest.asComparableCollection(expected), ExtendedPartialVisitContextTest.asComparableCollection(actual));
    }

    private static <T> Collection<T> asComparableCollection(Collection<T> c) {
        if (c instanceof Set || c instanceof List) {
            return c;
        }
        if (c == VisitContext.ALL_IDS) {
            return c;
        }
        if (c != null) {
            return new HashSet<T>(c);
        }
        return null;
    }

    private static <T> Set<T> asSet(T ... args) {
        HashSet<T> set = new HashSet<T>();
        for (T argItem : args) {
            set.add(argItem);
        }
        return set;
    }

    private void createVisitContext(boolean limitRender) {
        Set rendererIds = Collections.emptySet();
        PartialVisitContext partialVisitContext = new PartialVisitContext(this.facesContext, rendererIds);
        this.renderingContext = new ExtendedRenderVisitContext((VisitContext)partialVisitContext, this.facesContext, rendererIds, EnumSet.of(VisitHint.SKIP_UNRENDERED), limitRender);
    }

    private void createNestedTableData() {
        this.nestedTableData = new ArrayList();
        for (int i = 0; i < 3; ++i) {
            this.nestedTableData.add(MessageFormat.format("Nested item {0}", i));
        }
    }

    private void createTableData() {
        this.tableData = new ArrayList<String>();
        for (int i = 0; i < 2; ++i) {
            this.tableData.add(MessageFormat.format("Item {0}", i));
        }
    }

    private ValueExpression createTableVarValueExpression() {
        ExpressionFactory expressionFactory = this.application.getExpressionFactory();
        ELContext elContext = this.facesContext.getELContext();
        return expressionFactory.createValueExpression(elContext, "#{item}", String.class);
    }

    private ValueExpression createNestedTableVarValueExpression() {
        ExpressionFactory expressionFactory = this.application.getExpressionFactory();
        ELContext elContext = this.facesContext.getELContext();
        return expressionFactory.createValueExpression(elContext, "#{nestedItem}", String.class);
    }

    private void createNestedText() {
        this.nestedText = (UIOutput)this.application.createComponent("javax.faces.HtmlOutputText");
        this.nestedText.setId("nestedText");
        this.nestedText.setValueExpression("value", this.createTableVarValueExpression());
        ((UIComponent)this.table.getChildren().get(0)).getChildren().add(this.nestedText);
    }

    private void createNestedOutput() {
        this.nestedOutput = new AjaxOutputComponentImpl();
        this.nestedOutput.setAjaxRendered(true);
        this.nestedOutput.setId("nestedOutput");
        this.nestedOutput.setValueExpression("value", this.createTableVarValueExpression());
        ((UIComponent)this.table.getChildren().get(0)).getChildren().add(this.nestedOutput);
    }

    private void createOuterOutput() {
        this.outerOutput = new AjaxOutputComponentImpl();
        this.outerOutput.setAjaxRendered(true);
        this.outerOutput.setId("outerOutput");
        this.form.getChildren().add(this.outerOutput);
    }

    private void createTableHeader() {
        this.dataHeader = (UIOutput)this.application.createComponent("javax.faces.HtmlOutputText");
        this.dataHeader.setId("theHeader");
        this.table.getFacets().put("header", this.dataHeader);
    }

    private void createNestedTable() {
        this.nestedTable = new AjaxTableComponentImpl();
        this.nestedTable.setId("nestedTable");
        this.nestedTable.setVar("nestedItem");
        this.createNestedTableData();
        this.nestedTable.setValue(this.nestedTableData);
        this.nestedTable.getChildren().add(new UIColumn());
        ((UIComponent)this.table.getChildren().get(0)).getChildren().add(this.nestedTable);
        this.createNestedTableText();
        this.createNestedTableFooter();
    }

    private void createNestedTableFooter() {
        this.nestedTableFooter = (UIOutput)this.application.createComponent("javax.faces.HtmlOutputText");
        this.nestedTableFooter.setId("nestedTableFooter");
        this.nestedTableFooter.setValueExpression("value", this.createTableVarValueExpression());
        this.nestedTable.getFacets().put("footer", this.nestedTableFooter);
    }

    private void createNestedTableText() {
        this.nestedTableText = (UIOutput)this.application.createComponent("javax.faces.HtmlOutputText");
        this.nestedTableText.setId("nestedTableText");
        this.nestedTableText.setValueExpression("value", this.createNestedTableVarValueExpression());
        ((UIComponent)this.nestedTable.getChildren().get(0)).getChildren().add(this.nestedTableText);
    }

    private void createTable() {
        this.table = new AjaxTableComponentImpl();
        this.table.setId("table");
        this.table.setVar("item");
        this.createTableData();
        this.table.setValue(this.tableData);
        this.table.getChildren().add(new UIColumn());
        this.form.getChildren().add(this.table);
        this.createNestedOutput();
        this.createNestedText();
        this.createNestedTable();
        this.createTableHeader();
    }

    private void createForm() {
        this.form = (UIForm)this.application.createComponent("javax.faces.Form");
        this.form.setId("myForm");
        this.viewRoot.getChildren().add(this.form);
        this.createOuterOutput();
        this.createTable();
    }

    private void createView() {
        this.viewRoot = this.facesContext.getViewRoot();
        this.createForm();
    }

    @Before
    public void setUp() throws Exception {
        this.environment = FacesEnvironment.createEnvironment();
        this.environment.start();
        this.facesRequest = this.environment.createFacesRequest();
        this.facesRequest.start();
        this.facesContext = FacesContext.getCurrentInstance();
        this.application = this.facesContext.getApplication();
        this.createView();
        this.trackingVisitCallback = new TrackingVisitCallback();
    }

    @After
    public void tearDown() throws Exception {
        this.renderingContext = null;
        this.trackingVisitCallback = null;
        this.facesContext = null;
        this.application = null;
        this.table = null;
        this.dataHeader = null;
        this.form = null;
        this.nestedOutput = null;
        this.nestedTable = null;
        this.nestedTableData = null;
        this.nestedTableFooter = null;
        this.nestedTableText = null;
        this.nestedText = null;
        this.outerOutput = null;
        this.tableData = null;
        this.viewRoot = null;
        this.facesRequest.release();
        this.facesRequest = null;
        this.environment.release();
        this.environment = null;
    }

    @Test
    public void testCollectionProxy() throws Exception {
        this.createVisitContext(false);
        Collection idsToVisit = this.renderingContext.getIdsToVisit();
        Assert.assertTrue((boolean)idsToVisit.isEmpty());
        Assert.assertTrue((idsToVisit.size() == 0 ? 1 : 0) != 0);
        Iterator iterator = idsToVisit.iterator();
        Assert.assertNotNull(iterator);
        Assert.assertFalse((boolean)iterator.hasNext());
        Set<String> idsToAdd = ExtendedPartialVisitContextTest.asSet("someIds", "thisIs:evenBetter", "myForm:table:0:nestedText");
        idsToVisit.addAll(idsToAdd);
        Assert.assertFalse((boolean)idsToVisit.isEmpty());
        Assert.assertTrue((idsToVisit.size() == 3 ? 1 : 0) != 0);
        iterator = idsToVisit.iterator();
        while (iterator.hasNext()) {
            String nextId = (String)iterator.next();
            Assert.assertTrue((boolean)idsToAdd.remove(nextId));
            iterator.remove();
        }
        Assert.assertTrue((boolean)idsToVisit.isEmpty());
        Assert.assertTrue((idsToVisit.size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)idsToAdd.isEmpty());
        iterator = idsToVisit.iterator();
        try {
            iterator.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        idsToVisit.add("testId");
        Assert.assertFalse((boolean)idsToVisit.isEmpty());
        iterator = idsToVisit.iterator();
        try {
            iterator.remove();
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testSubtreeIdsToForAjaxOutputs() throws Exception {
        this.createVisitContext(false);
        Assert.assertSame((Object)VisitContext.ALL_IDS, (Object)this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.form));
        ExtendedPartialVisitContextTest.assertEqualSets(ExtendedPartialVisitContextTest.asSet("table", "outerOutput"), this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.form));
        Assert.assertSame((Object)VisitContext.ALL_IDS, (Object)this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.table));
        ExtendedPartialVisitContextTest.assertEqualSets(ExtendedPartialVisitContextTest.asSet("nestedOutput"), this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.table));
        Assert.assertTrue((boolean)this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.nestedTable).isEmpty());
        Assert.assertTrue((boolean)this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.nestedTable).isEmpty());
    }

    @Test
    public void testSubtreeIdsForEmptyIdsWithLimitRender() throws Exception {
        this.createVisitContext(true);
        Assert.assertTrue((boolean)this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.form).isEmpty());
        Assert.assertTrue((boolean)this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.form).isEmpty());
        Assert.assertTrue((boolean)this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.table).isEmpty());
        Assert.assertTrue((boolean)this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.table).isEmpty());
        Assert.assertTrue((boolean)this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.nestedTable).isEmpty());
        Assert.assertTrue((boolean)this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.nestedTable).isEmpty());
    }

    @Test
    public void testSubtreeIdsForOuterOutputWithLimitRender() throws Exception {
        this.createVisitContext(true);
        this.renderingContext.getIdsToVisit().add("myForm:outerOutput");
        ExtendedPartialVisitContextTest.assertEqualSets(ExtendedPartialVisitContextTest.asSet("myForm:outerOutput"), this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.form));
        ExtendedPartialVisitContextTest.assertEqualSets(ExtendedPartialVisitContextTest.asSet("outerOutput"), this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.form));
        Assert.assertTrue((boolean)this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.table).isEmpty());
        Assert.assertTrue((boolean)this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.table).isEmpty());
    }

    @Test
    public void testSubtreeIdsForNestedComponentsWithLimitRender() throws Exception {
        this.createVisitContext(true);
        this.renderingContext.getIdsToVisit().add("myForm:outerOutput");
        this.renderingContext.getIdsToVisit().add("myForm:table:theHeader");
        this.renderingContext.getIdsToVisit().add("myForm:table:1:nestedOutput");
        this.renderingContext.getIdsToVisit().add("myForm:table:0:nestedText");
        this.renderingContext.getIdsToVisit().add("myForm:table:0:nestedTable:1:nestedTableText");
        this.renderingContext.getIdsToVisit().add("myForm:table:0:nestedTable:nestedFooter");
        Set<String> formClientIds = ExtendedPartialVisitContextTest.asSet("myForm:outerOutput", "myForm:table:0:nestedText", "myForm:table:1:nestedOutput", "myForm:table:theHeader", "myForm:table:0:nestedTable:1:nestedTableText", "myForm:table:0:nestedTable:nestedFooter");
        Set<String> formIds = ExtendedPartialVisitContextTest.asSet("table", "outerOutput");
        ExtendedPartialVisitContextTest.assertEqualSets(formClientIds, this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.form));
        ExtendedPartialVisitContextTest.assertEqualSets(formIds, this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.form));
        Set<String> tableClientIds = ExtendedPartialVisitContextTest.asSet("myForm:table:0:nestedText", "myForm:table:1:nestedOutput", "myForm:table:theHeader", "myForm:table:0:nestedTable:1:nestedTableText", "myForm:table:0:nestedTable:nestedFooter");
        Set<String> tableIds = ExtendedPartialVisitContextTest.asSet("0", "1", "theHeader");
        ExtendedPartialVisitContextTest.assertEqualSets(tableClientIds, this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.table));
        ExtendedPartialVisitContextTest.assertEqualSets(tableIds, this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.table));
        this.table.setRowIndex(0);
        Set<String> nestedTableClientIds = ExtendedPartialVisitContextTest.asSet("myForm:table:0:nestedTable:1:nestedTableText", "myForm:table:0:nestedTable:nestedFooter");
        Set<String> nestedTableIds = ExtendedPartialVisitContextTest.asSet("nestedFooter", "1");
        ExtendedPartialVisitContextTest.assertEqualSets(nestedTableClientIds, this.renderingContext.getSubtreeIdsToVisit((UIComponent)this.nestedTable));
        ExtendedPartialVisitContextTest.assertEqualSets(nestedTableIds, this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.nestedTable));
        this.table.setRowIndex(-1);
    }

    @Test
    public void testVisitCallbackForEmptyIds() throws Exception {
        this.createVisitContext(false);
        this.viewRoot.visitTree((VisitContext)this.renderingContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertEquals(Arrays.asList("myForm:outerOutput", "myForm:table:0:nestedOutput", "myForm:table:1:nestedOutput"), this.trackingVisitCallback.getVisitedIds());
    }

    @Test
    public void testVisitCallbackForEmptyIdsWithLimitRender() throws Exception {
        this.createVisitContext(true);
        this.viewRoot.visitTree((VisitContext)this.renderingContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertEquals(Arrays.asList(new Object[0]), this.trackingVisitCallback.getVisitedIds());
    }

    @Test
    public void testVisitCallbackForEmptyIdsForFalseAjaxRendered() throws Exception {
        this.outerOutput.setAjaxRendered(false);
        this.createVisitContext(false);
        this.viewRoot.visitTree((VisitContext)this.renderingContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertEquals(Arrays.asList("myForm:table:0:nestedOutput", "myForm:table:1:nestedOutput"), this.trackingVisitCallback.getVisitedIds());
    }

    @Test
    public void testVisitCallback() throws Exception {
        this.createVisitContext(false);
        this.renderingContext.getIdsToVisit().add("myForm:table:1:nestedTable:1:nestedTableText");
        this.renderingContext.getIdsToVisit().add("myForm:table:1:nestedTable:nestedTableFooter");
        this.viewRoot.visitTree((VisitContext)this.renderingContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertEquals(Arrays.asList("myForm:outerOutput", "myForm:table:0:nestedOutput", "myForm:table:1:nestedOutput", "myForm:table:1:nestedTable:nestedTableFooter", "myForm:table:1:nestedTable:1:nestedTableText"), this.trackingVisitCallback.getVisitedIds());
    }

    @Test
    public void testVisitMetaComponentsWithLimitRender() throws Exception {
        this.createVisitContext(true);
        this.renderingContext.getIdsToVisit().add("myForm:table:1:nestedTable@footer");
        boolean visitResult = this.viewRoot.visitTree((VisitContext)this.renderingContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertEquals(Arrays.asList("myForm:table:1:nestedTable@footer"), this.trackingVisitCallback.getVisitedIds());
        Assert.assertTrue((boolean)visitResult);
    }

    @Test
    public void testFormVisitContext() throws Exception {
        this.createVisitContext(false);
        Collection formDirectIds = this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.form);
        Assert.assertNotSame((Object)VisitContext.ALL_IDS, (Object)formDirectIds);
        ExtendedVisitContext formVisitContext = (ExtendedVisitContext)this.renderingContext.createNamingContainerVisitContext((UIComponent)this.form, formDirectIds);
        Assert.assertFalse((boolean)formVisitContext.getIdsToVisit().isEmpty());
        Assert.assertSame((Object)VisitContext.ALL_IDS, (Object)formVisitContext.getSubtreeIdsToVisit((UIComponent)this.form));
        Assert.assertTrue((boolean)formVisitContext.getSubtreeIdsToVisit((UIComponent)this.table).isEmpty());
        Collection directIds = formVisitContext.getDirectSubtreeIdsToVisit((UIComponent)this.form);
        ExtendedPartialVisitContextTest.assertEqualSets(ExtendedPartialVisitContextTest.asSet("outerOutput", "table"), directIds);
        Assert.assertTrue((boolean)formVisitContext.getDirectSubtreeIdsToVisit((UIComponent)this.table).isEmpty());
        boolean visitResult = this.form.visitTree((VisitContext)formVisitContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertTrue((boolean)visitResult);
        Assert.assertEquals(Arrays.asList("myForm:outerOutput", "myForm:table"), this.trackingVisitCallback.getVisitedIds());
    }

    @Test
    public void testFormVisitContextWithLimitRender() throws Exception {
        this.createVisitContext(true);
        this.renderingContext.getIdsToVisit().add("myForm:table:0:nestedText");
        Collection formDirectIds = this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.form);
        Assert.assertNotSame((Object)VisitContext.ALL_IDS, (Object)formDirectIds);
        ExtendedVisitContext formVisitContext = (ExtendedVisitContext)this.renderingContext.createNamingContainerVisitContext((UIComponent)this.form, formDirectIds);
        Assert.assertFalse((boolean)formVisitContext.getIdsToVisit().isEmpty());
        Assert.assertSame((Object)VisitContext.ALL_IDS, (Object)formVisitContext.getSubtreeIdsToVisit((UIComponent)this.form));
        Assert.assertTrue((boolean)formVisitContext.getSubtreeIdsToVisit((UIComponent)this.table).isEmpty());
        Collection directIds = formVisitContext.getDirectSubtreeIdsToVisit((UIComponent)this.form);
        ExtendedPartialVisitContextTest.assertEqualSets(ExtendedPartialVisitContextTest.asSet("table"), directIds);
        Assert.assertTrue((boolean)formVisitContext.getSubtreeIdsToVisit((UIComponent)this.table).isEmpty());
        boolean visitResult = this.form.visitTree((VisitContext)formVisitContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertTrue((boolean)visitResult);
        Assert.assertEquals(Arrays.asList("myForm:table"), this.trackingVisitCallback.getVisitedIds());
    }

    @Test
    public void testFormVisitContextNonexistentIdsWithLimitRender() throws Exception {
        this.createVisitContext(true);
        this.renderingContext.getIdsToVisit().add("myForm:nonExistentId");
        Collection formDirectIds = this.renderingContext.getDirectSubtreeIdsToVisit((UIComponent)this.form);
        Assert.assertNotSame((Object)VisitContext.ALL_IDS, (Object)formDirectIds);
        ExtendedVisitContext formVisitContext = (ExtendedVisitContext)this.renderingContext.createNamingContainerVisitContext((UIComponent)this.form, formDirectIds);
        Assert.assertFalse((boolean)formVisitContext.getIdsToVisit().isEmpty());
        Assert.assertSame((Object)VisitContext.ALL_IDS, (Object)formVisitContext.getSubtreeIdsToVisit((UIComponent)this.form));
        Assert.assertTrue((boolean)formVisitContext.getSubtreeIdsToVisit((UIComponent)this.table).isEmpty());
        Collection directIds = formVisitContext.getDirectSubtreeIdsToVisit((UIComponent)this.form);
        ExtendedPartialVisitContextTest.assertEqualSets(ExtendedPartialVisitContextTest.asSet("nonExistentId"), directIds);
        Assert.assertTrue((boolean)formVisitContext.getSubtreeIdsToVisit((UIComponent)this.table).isEmpty());
        boolean visitResult = this.form.visitTree((VisitContext)formVisitContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertFalse((boolean)visitResult);
        Assert.assertEquals(Arrays.asList(new Object[0]), this.trackingVisitCallback.getVisitedIds());
    }

    @Test
    public void testVisitMultiple() throws Exception {
        this.createVisitContext(true);
        String idFormat = "myForm:table:{0}:nestedTable:1:nestedTableText";
        this.renderingContext.getIdsToVisit().add(MessageFormat.format(idFormat, 0));
        this.renderingContext.getIdsToVisit().add(MessageFormat.format(idFormat, 1));
        boolean visitResult = this.viewRoot.visitTree((VisitContext)this.renderingContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertTrue((boolean)visitResult);
        Assert.assertEquals(Arrays.asList("myForm:table:0:nestedTable:1:nestedTableText", "myForm:table:1:nestedTable:1:nestedTableText"), this.trackingVisitCallback.getVisitedIds());
    }

    @Test
    public void testVisitMultipleWithPatternAndMetacomponent() throws Exception {
        this.createVisitContext(true);
        String idFormat = "myForm:table:{0}:nestedTable:{1}:nestedTableText";
        this.renderingContext.getIdsToVisit().add(MessageFormat.format(idFormat, 0, 0));
        this.renderingContext.getIdsToVisit().add(MessageFormat.format(idFormat, 0, 1));
        this.renderingContext.getIdsToVisit().add(MessageFormat.format(idFormat, 1, 0));
        this.renderingContext.getIdsToVisit().add(MessageFormat.format(idFormat, 1, 1));
        this.renderingContext.getIdsToVisit().add("myForm:table:0:nestedTable@footer");
        this.viewRoot.visitTree((VisitContext)this.renderingContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertEquals(Arrays.asList("myForm:table:0:nestedTable@footer", "myForm:table:0:nestedTable:0:nestedTableText", "myForm:table:0:nestedTable:1:nestedTableText", "myForm:table:1:nestedTable:0:nestedTableText", "myForm:table:1:nestedTable:1:nestedTableText"), this.trackingVisitCallback.getVisitedIds());
    }

    @Test
    public void testMultipleMetaComponentIds() throws Exception {
        this.createVisitContext(true);
        this.renderingContext.getIdsToVisit().add("myForm:table@header");
        this.renderingContext.getIdsToVisit().add("myForm:table@footer");
        Assert.assertTrue((boolean)this.renderingContext.getIdsToVisit().contains("myForm:table@header"));
        Assert.assertTrue((boolean)this.renderingContext.getIdsToVisit().contains("myForm:table@footer"));
        Assert.assertFalse((boolean)this.renderingContext.getIdsToVisit().contains("myForm"));
        Assert.assertFalse((boolean)this.renderingContext.getIdsToVisit().contains("table"));
        Assert.assertFalse((boolean)this.renderingContext.getIdsToVisit().contains("myForm:table"));
    }

    @Test
    public void testVisitForm() throws Exception {
        this.createVisitContext(true);
        this.renderingContext.getIdsToVisit().add("myForm");
        boolean result = this.facesContext.getViewRoot().visitTree((VisitContext)this.renderingContext, (VisitCallback)this.trackingVisitCallback);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals(Arrays.asList("myForm"), this.trackingVisitCallback.getVisitedIds());
    }

    private class TrackingVisitCallback
    implements VisitCallback {
        private List<String> visitedIds = new ArrayList<String>();

        private TrackingVisitCallback() {
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (context instanceof ExtendedVisitContext) {
                this.visitedIds.add(((ExtendedVisitContext)context).buildExtendedClientId(target));
            } else {
                this.visitedIds.add(target.getClientId(context.getFacesContext()));
            }
            return VisitResult.REJECT;
        }

        public List<String> getVisitedIds() {
            return this.visitedIds;
        }

        public void reset() {
            this.visitedIds.clear();
        }
    }
}

