/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.HashMap;
import javax.faces.context.FacesContext;
import org.easymock.EasyMock;
import org.jboss.test.faces.mock.Environment;
import org.jboss.test.faces.mock.Mock;
import org.jboss.test.faces.mock.MockFacesEnvironment;
import org.jboss.test.faces.mock.MockTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.richfaces.context.IdParser;

@RunWith(value=MockTestRunner.class)
public class IdParserTest {
    @Mock
    @Environment(value={Environment.Feature.EXTERNAL_CONTEXT})
    private MockFacesEnvironment environment;

    @Before
    public void setUp() throws Exception {
        this.environment.resetToNice();
        FacesContext facesContext = this.environment.getFacesContext();
        EasyMock.expect((Object)facesContext.getAttributes()).andStubReturn(new HashMap());
        this.environment.replay();
    }

    @Test
    public void testSimpleId() throws Exception {
        Assert.assertArrayEquals((Object[])new IdParser.Node[0], (Object[])IdParser.parse((String)""));
        Assert.assertArrayEquals((Object[])new IdParser.Node[]{new IdParser.Node("test")}, (Object[])IdParser.parse((String)"test"));
        Assert.assertArrayEquals((Object[])new IdParser.Node[]{new IdParser.Node("form"), new IdParser.Node("table")}, (Object[])IdParser.parse((String)"form:table"));
    }

    @Test
    public void testRowsFunction() throws Exception {
        try {
            IdParser.parse((String)"form:table:@rows(");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            IdParser.parse((String)"form:table:@rows(12");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertArrayEquals((Object[])new IdParser.Node[]{new IdParser.Node("form"), new IdParser.Node("table"), new IdParser.Node("", "rows"), new IdParser.Node("@row")}, (Object[])IdParser.parse((String)"form:table:@rows():@row"));
        Assert.assertArrayEquals((Object[])new IdParser.Node[]{new IdParser.Node("form"), new IdParser.Node("table"), new IdParser.Node("12", "rows")}, (Object[])IdParser.parse((String)"form:table:@rows(12)"));
        Assert.assertArrayEquals((Object[])new IdParser.Node[]{new IdParser.Node("form"), new IdParser.Node("table"), new IdParser.Node("", "rows"), new IdParser.Node("subtable")}, (Object[])IdParser.parse((String)"form:table:@rows():subtable"));
        Assert.assertArrayEquals((Object[])new IdParser.Node[]{new IdParser.Node("form"), new IdParser.Node("table"), new IdParser.Node("12", "rows"), new IdParser.Node("subtable"), new IdParser.Node("a", "rows"), new IdParser.Node("cell")}, (Object[])IdParser.parse((String)"form:table:@rows(12):subtable:@rows(a):cell"));
    }
}

