/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.context;

import java.util.HashMap;
import java.util.NoSuchElementException;
import javax.faces.context.FacesContext;
import org.easymock.EasyMock;
import org.jboss.test.faces.mock.Environment;
import org.jboss.test.faces.mock.Mock;
import org.jboss.test.faces.mock.MockFacesEnvironment;
import org.jboss.test.faces.mock.MockTestRunner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.richfaces.context.IdSplitIterator;

@RunWith(value=MockTestRunner.class)
public class IdSplitIteratorTest {
    @Mock
    @Environment(value={Environment.Feature.EXTERNAL_CONTEXT})
    private MockFacesEnvironment environment;

    @Before
    public void setUp() throws Exception {
        this.environment.resetToNice();
        FacesContext facesContext = this.environment.getFacesContext();
        EasyMock.expect((Object)facesContext.getAttributes()).andStubReturn(new HashMap());
        this.environment.replay();
    }

    @Test
    public void testEmptyString() throws Exception {
        IdSplitIterator iterator = new IdSplitIterator("");
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertNull((Object)iterator.getSubtreeId());
    }

    @Test
    public void testSimpleString() throws Exception {
        IdSplitIterator iterator = new IdSplitIterator("id");
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"id", (Object)iterator.next());
        Assert.assertNull((Object)iterator.getSubtreeId());
        Assert.assertFalse((boolean)iterator.hasNext());
        try {
            iterator.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertNull((Object)iterator.getSubtreeId());
    }

    @Test
    public void testTwoSegmentsString() throws Exception {
        IdSplitIterator iterator = new IdSplitIterator("form:table");
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"table", (Object)iterator.next());
        Assert.assertEquals((Object)"form", (Object)iterator.getSubtreeId());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"form", (Object)iterator.next());
        Assert.assertNull((Object)iterator.getSubtreeId());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testThreeSegmentsString() throws Exception {
        IdSplitIterator iterator = new IdSplitIterator("form:table:cell");
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"cell", (Object)iterator.next());
        Assert.assertEquals((Object)"form:table", (Object)iterator.getSubtreeId());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"table", (Object)iterator.next());
        Assert.assertEquals((Object)"form", (Object)iterator.getSubtreeId());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"form", (Object)iterator.next());
        Assert.assertNull((Object)iterator.getSubtreeId());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testBadStrings() throws Exception {
        IdSplitIterator iterator = new IdSplitIterator(":");
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = new IdSplitIterator("test:");
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = new IdSplitIterator(":test");
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((Object)"test", (Object)iterator.next());
        Assert.assertEquals((Object)"", (Object)iterator.getSubtreeId());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = new IdSplitIterator("::");
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

