/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import java.util.Arrays;
import java.util.Collection;
import javax.faces.application.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.richfaces.resource.mapping.ResourceServletMapping;

@RunWith(value=Parameterized.class)
public class ResourceServletMappingTest {
    private Resource resource = (Resource)Mockito.mock(Resource.class);
    private String expectedOutput;

    public ResourceServletMappingTest(String ln, String resourceName, String resourcePath, String expectedOutput) {
        Mockito.when((Object)this.resource.getResourceName()).thenReturn((Object)resourceName);
        Mockito.when((Object)this.resource.getLibraryName()).thenReturn((Object)ln);
        Mockito.when((Object)this.resource.getRequestPath()).thenReturn((Object)resourcePath);
        this.expectedOutput = expectedOutput;
    }

    @Parameterized.Parameters
    public static Collection<?> primeNumbers() {
        return Arrays.asList({"org.richfaces.ckeditor", "skins/richfaces/editor.ecss", "/showcase/rfRes/skins/richfaces/editor.ecss?ln=org.richfaces.ckeditor", "org.richfaces.ckeditor/skins/richfaces/editor.ecss"}, {null, "skins/richfaces/editor.ecss", "/showcase/rfRes/skins/richfaces/editor.ecss?db=eAFbwPU8HAAExwHp&test=xyz", "skins/richfaces/editor.ecss?db=eAFbwPU8HAAExwHp&test=xyz"}, {"", "skins/richfaces/editor.ecss", "/showcase/rfRes/skins/richfaces/editor.ecss?db=eAFbwPU8HAAExwHp&ln=&test=xyz", "skins/richfaces/editor.ecss?db=eAFbwPU8HAAExwHp&test=xyz"}, {"org.richfaces.ckeditor", "skins/richfaces/editor.ecss", "/showcase/rfRes/skins/richfaces/editor.ecss?db=eAFbwPU8HAAExwHp&ln=org.richfaces.ckeditor&test=xyz", "org.richfaces.ckeditor/skins/richfaces/editor.ecss?db=eAFbwPU8HAAExwHp&test=xyz"}, {"org.richfaces.ckeditor", "skins/richfaces/editor.ecss", "/showcase/rfRes/skins/richfaces/editor.ecss?ln=org.richfaces.ckeditor&db=eAFbwPU8HAAExwHp&test=xyz", "org.richfaces.ckeditor/skins/richfaces/editor.ecss?db=eAFbwPU8HAAExwHp&test=xyz"}, {"org.richfaces.ckeditor", "skins/richfaces/editor.ecss", "/showcase/rfRes/skins/richfaces/editor.ecss?db=eAFbwPU8HAAExwHp&test=xyz&ln=org.richfaces.ckeditor", "org.richfaces.ckeditor/skins/richfaces/editor.ecss?db=eAFbwPU8HAAExwHp&test=xyz"});
    }

    @Test
    public void testGetResourcePath() {
        Assert.assertThat((Object)ResourceServletMapping.getResourcePath((Resource)this.resource), (Matcher)Matchers.equalTo((Object)this.expectedOutput));
    }
}

