/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.util;

import com.google.common.base.Joiner;
import org.junit.Assert;
import org.junit.Test;
import org.richfaces.util.FastJoiner;

public class FastJoinerTest {
    private static final int PERFORMANCE_TEST_STEPS = 100000;

    @Test
    public void testDotCharJoin() throws Exception {
        FastJoiner joiner = FastJoiner.on((char)'.');
        Assert.assertEquals((Object)"", (Object)joiner.join(null, null));
        Assert.assertEquals((Object)"test", (Object)joiner.join("test", null));
        Assert.assertEquals((Object)"test.", (Object)joiner.join("test", ""));
        Assert.assertEquals((Object)"another test", (Object)joiner.join(null, "another test"));
        Assert.assertEquals((Object)".another test", (Object)joiner.join("", "another test"));
        Assert.assertEquals((Object)"join.them", (Object)joiner.join("join", "them"));
    }

    @Test
    public void testDotCharVarargsJoin() throws Exception {
        FastJoiner joiner = FastJoiner.on((char)'.');
        Assert.assertEquals((Object)"", (Object)joiner.join(new String[]{null, null, null}));
        Assert.assertEquals((Object)"test", (Object)joiner.join(new String[]{"test", null, null}));
        Assert.assertEquals((Object)"test", (Object)joiner.join(new String[]{null, "test", null}));
        Assert.assertEquals((Object)"test", (Object)joiner.join(new String[]{null, null, "test"}));
        Assert.assertEquals((Object)"test..abc", (Object)joiner.join(new String[]{"test", "", "abc"}));
        Assert.assertEquals((Object)"test..abc", (Object)joiner.join(new String[]{null, "test", "", "abc"}));
        Assert.assertEquals((Object)".test.abc", (Object)joiner.join(new String[]{"", "test", "abc"}));
        Assert.assertEquals((Object)".test.abc", (Object)joiner.join(new String[]{null, "", "test", "abc"}));
        Assert.assertEquals((Object)"join.them.all", (Object)joiner.join(new String[]{"join", "them", "all"}));
    }

    @Test
    public void testXYStringJoin() throws Exception {
        FastJoiner joiner = FastJoiner.on((String)"-xy+");
        Assert.assertEquals((Object)"", (Object)joiner.join(null, null));
        Assert.assertEquals((Object)"test", (Object)joiner.join("test", null));
        Assert.assertEquals((Object)"test-xy+", (Object)joiner.join("test", ""));
        Assert.assertEquals((Object)"another test", (Object)joiner.join(null, "another test"));
        Assert.assertEquals((Object)"-xy+another test", (Object)joiner.join("", "another test"));
        Assert.assertEquals((Object)"join-xy+them", (Object)joiner.join("join", "them"));
    }

    @Test
    public void testEmptyStringJoin() throws Exception {
        FastJoiner joiner = FastJoiner.on((String)"");
        Assert.assertEquals((Object)"", (Object)joiner.join(null, null));
        Assert.assertEquals((Object)"test", (Object)joiner.join("test", null));
        Assert.assertEquals((Object)"test", (Object)joiner.join("test", ""));
        Assert.assertEquals((Object)"another test", (Object)joiner.join(null, "another test"));
        Assert.assertEquals((Object)"another test", (Object)joiner.join("", "another test"));
        Assert.assertEquals((Object)"jointhem", (Object)joiner.join("join", "them"));
    }

    @Test
    public void testEmptyStringVarargsJoin() throws Exception {
        FastJoiner joiner = FastJoiner.on((String)"");
        Assert.assertEquals((Object)"", (Object)joiner.join(new String[]{null, null, null}));
        Assert.assertEquals((Object)"test", (Object)joiner.join(new String[]{null, "test", null, null}));
        Assert.assertEquals((Object)"test", (Object)joiner.join(new String[]{"test", null, null}));
        Assert.assertEquals((Object)"test", (Object)joiner.join(new String[]{"test", "", null}));
        Assert.assertEquals((Object)"test", (Object)joiner.join(new String[]{"", "test", null}));
        Assert.assertEquals((Object)"test", (Object)joiner.join(new String[]{null, "", "test", null}));
        Assert.assertEquals((Object)"jointhemall", (Object)joiner.join(new String[]{"join", "them", "all"}));
    }

    @Test
    public void testGuavaJoinerPerformance() throws Exception {
        Joiner joiner = Joiner.on((String)"-separator-").skipNulls();
        for (int i = 0; i < 100000; ++i) {
            joiner.join((Object)"big:table:id:string", (Object)"cell:id", new Object[0]);
        }
    }

    @Test
    public void testFastJoinerPerformance() throws Exception {
        FastJoiner joiner = FastJoiner.on((String)"-separator-");
        for (int i = 0; i < 100000; ++i) {
            joiner.join("big:table:id:string", "cell:id");
        }
    }
}

