/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource.mapping;

import java.net.URL;
import org.richfaces.resource.ResourceKey;
import org.richfaces.util.URLUtils;

public class ResourcePath {
    public String resourcePath;

    public ResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public ResourcePath(URL url) {
        this.resourcePath = url.toExternalForm();
    }

    public ResourcePath(ResourceKey key) {
        this.resourcePath = key.getResourceName();
        if (key.getLibraryName() != null && !key.getLibraryName().isEmpty()) {
            this.resourcePath = key.getLibraryName() + "/" + key.getResourceName();
        }
    }

    public String toExternalForm() {
        return this.resourcePath;
    }

    public boolean isAbsoluteURL() {
        return URLUtils.isValidURL(this.resourcePath);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resourcePath == null ? 0 : this.resourcePath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourcePath other = (ResourcePath)obj;
        return !(this.resourcePath == null ? other.resourcePath != null : !this.resourcePath.equals(other.resourcePath));
    }

    public String toString() {
        return "ResourcePath [resourcePath=" + this.resourcePath + "]";
    }
}

