package org.richfaces.component.html;

import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.richfaces.component.UISuggestionBox;

public class HtmlSuggestionBox extends UISuggestionBox{

static public final  String COMPONENT_FAMILY = "org.richfaces.SuggestionBox";

static public final  String COMPONENT_TYPE = "org.richfaces.SuggestionBox";

/*
* Boolean attribute which provides possibility to limit JSF tree processing(decoding, conversion/validation, value applying) to the component which send the request only.
                Default value is "true"
*/
private  boolean _ajaxSingle = true;

private  boolean _ajaxSingleSet = false;

/*
* align
*/
private  String _align = null;

/*
* Deprecated. This attribute sets the background color for the document body or table cells.
            
            This attribute sets the background color of the canvas for the document body (the BODY element) or for tables (the TABLE, TR, TH, and TD elements). Additional attributes for specifying text color can be used with the BODY element.
            
            This attribute has been deprecated in favor of style sheets for specifying background color information
*/
private  String _bgcolor = null;

/*
* This attributes specifies the width (in pixels only) of the frame around a table
*/
private  String _border = null;

/*
* If "true", after process validations phase it skips updates of model beans on a force render response. It can be used for validating components input
*/
private  boolean _bypassUpdates = false;

private  boolean _bypassUpdatesSet = false;

/*
* This attribute specifies the amount of space between the
                border of the cell and its contents. If the value of
                this attribute is a pixel length, all four margins
                should be this distance from the contents. If the value
                of the attribute is percentage length, the top and
                bottom margins should be equally separated from the
                content based on percentage of the available vertical
                space, and the left and right margins should be equally
                separated from the content based on percentage of the
                available horizontal space
*/
private  String _cellpadding = null;

/*
* This attribute specifies how much space the user agent
                should leave between the table and the column on all
                four sides. The attribute also specifies the amount of
                space to leave between cells
*/
private  String _cellspacing = null;

/*
* 
*/
private  Converter _converter = null;

/*
* data
*/
private  Object _data = null;

/*
* Direction indication for text that does not inherit
			directionality. Valid values are "LTR" (left-to-right)
			and "RTL" (right-to-left)
*/
private  String _dir = null;

/*
* Assigns one or more space-separated CSS class names to the suggestion entry elements (table rows)
*/
private  String _entryClass = null;

/*
* Name of requests queue to avoid send next request before complete other from same event. Can be used to reduce number of requests of frequently events (key press, mouse move etc.)
*/
private  String _eventsQueue = null;

/*
* A value to set in the target input element on a choice
                suggestion that isn't shown in the suggestion table. It
                can be used for descriptive output comments or
                suggestions. If not set, all text in the suggestion row
                is set as a value
*/
private  Object _fetchValue = null;

/*
* 
*/
private  String _focus = null;

/*
* id (or full path of id's) of target components, for which this element must provide support.
		If a target component inside of the same &amp;lt;code&amp;gt;NamingContainer&amp;lt;/code&amp;gt; (UIForm, UIData in base implementations), can be simple value of the "id" attribute.
		For other cases must include id's of &amp;lt;code&amp;gt;NamingContainer&amp;lt;/code&amp;gt; components, separated by ':'. For search from the root of components, must be started with ':'.
*/
private  String _for = null;

/*
* This attribute specifies which sides of the frame surrounding a table will be visible. Possible values:  "void", "above", "below", "hsides", "lhs", "rhs", "vsides", "box" and "border".
        The default value is "void".
*/
private  String _frame = null;

/*
* Delay (in seconds) before activating the suggestion
                pop-up. Default value is 400ms
*/
private  double _frequency = Double.MIN_VALUE;

private  boolean _frequencySet = false;

/*
* Height of the pop-up window in pixels. Default value is "200".
*/
private  String _height = null;

/*
* Attribute allows to ignore an Ajax Response produced by a request if the newest 'similar' request is
in a queue already. ignoreDupResponses="true" does not cancel the request while it is processed on the server,
but just allows to avoid unnecessary updates on the client side if the response isn't actual now
*/
private  boolean _ignoreDupResponses = false;

private  boolean _ignoreDupResponsesSet = false;

/*
* A flag indicating that this component value must be converted and validated immediately (that is, during Apply Request Values phase), rather than waiting until a Process Validations phase.
*/
private  boolean _immediate = false;

private  boolean _immediateSet = false;

/*
* Code describing the language used in the generated markup for this component
*/
private  String _lang = null;

/*
* If "true", then of all AJAX-rendered on the page components only those will be updated, 
		which ID's are passed to the "reRender" attribute of the describable component. 
		"false"-the default value-means that all components with ajaxRendered="true" will be updated.
*/
private  boolean _limitToList = false;

private  boolean _limitToListSet = false;

/*
* Minimal number of chars in input to activate suggestion
                pop-up
*/
private  String _minChars = null;

/*
* "nothingLabel" is inserted to popup list if the autocomplete returns empty list. 
				It isn't selectable and list is closed as always after click on it and nothing is put to input.
*/
private  String _nothingLabel = null;

/*
* The client-side script method to be called before DOM is updated
*/
private  String _onbeforedomupdate = null;

/*
* The client-side script method to be called after the request is completed
*/
private  String _oncomplete = null;

/*
* The client-side script method to be called before the list of suggested objects is changed
*/
private  String _onobjectchange = null;

/*
* The client-side script method to be called after the
                value of the target element is updated
*/
private  String _onselect = null;

/*
* The client-side script method to be called before an ajax event is submitted
*/
private  String _onsubmit = null;

/*
* Name the HTTP request parameter with the value of input
                element token. If not set, it be will sent as an input
                element name. In this case, input will perform
                validation and update the value. Default value is "inputvalue".
*/
private  String _param = null;

/*
* Assigns one or more space-separated CSS class names to the content of the pop-up suggestion element
*/
private  String _popupClass = null;

/*
* CSS style rules to be applied to the content of the pop-up suggestion element
*/
private  String _popupStyle = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, processed at the phases 2-5 in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _process = null;

/*
* Id['s] (in format of call  UIComponent.findComponent()) of components, rendered in case of AjaxRequest  caused by this component. Can be single id, comma-separated list of Id's, or EL Expression  with array or Collection
*/
private  Object _reRender = null;

/*
* Attribute defines the time (in ms.) that the request will be wait in the queue before it is ready to send.
When the delay time is over, the request will be sent to the server or removed if the newest 'similar' request is in a queue already
*/
private  int _requestDelay = Integer.MIN_VALUE;

private  boolean _requestDelaySet = false;

/*
* Assigns one or more space-separated CSS class names to the rows. If the CSS class names are comma-separated, 
            	each class will be assigned to a particular row in the order they follow in the attribute. If you have less class names than rows, 
            	the class will be applied to every n-fold row where n is the order in which the class is listed in the attribute. 
            	If there are more class names than rows, the overflow ones are ignored.
*/
private  String _rowClasses = null;

/*
* This attribute specifies which rules will appear between cells within a table. The rendering of rules is user agent dependent. Possible values:
            
            * none: No rules. This is the default value.
            * groups: Rules will appear between row groups (see THEAD, TFOOT, and TBODY) and column groups (see COLGROUP and COL) only.
            * rows: Rules will appear between rows only.
            * cols: Rules will appear between columns only.
            * all: Rules will appear between all rows and columns
*/
private  String _rules = null;

/*
* Assigns one or more space-separated CSS class names to the cells of the selected suggestion entry (table cells)
*/
private  String _selectValueClass = null;

/*
* Assigns one or more space-separated CSS class names to the selected suggestion entry (table rows)
*/
private  String _selectedClass = null;

/*
* If "true", forces active Ajax region render response
                directly from stored components tree, bypasses page
                processing. Can be used for increase performance. Also,
                must be set to 'true' inside iteration components, such
                as dataTable.
*/
private  boolean _selfRendered = false;

private  boolean _selfRenderedSet = false;

/*
* Pop-up shadow depth for suggestion content
*/
private  String _shadowDepth = null;

/*
* Attribute defines shadow opacity for suggestion content
*/
private  String _shadowOpacity = null;

/*
* If there are any component requests with identical IDs then these requests will be grouped.
*/
private  String _similarityGroupingId = null;

/*
* ID (in format of call UIComponent.findComponent()) of Request status component
*/
private  String _status = null;

/*
* CSS style rules to be applied to the component
*/
private  String _style = null;

/*
* Assigns one or more space-separated CSS class names to the component. Corresponds to the HTML "class" attribute.
*/
private  String _styleClass = null;

/*
* submitedValue
*/
private  Object _submitedValue = null;

/*
* Method calls an expression to get a collection of suggestion data on request. It must have one parameter with a type of Object with content of input component and must return any type allowed for &amp;lt;h:datatable&amp;gt;
*/
private  MethodExpression _suggestionAction = null;

/*
* This attribute provides a summary of the table's purpose and structure for user agents rendering to non-visual media such as speech and Braille
*/
private  String _summary = null;

/*
* Response waiting time on a particular request. If a response is not received during this time, the request is aborted
*/
private  int _timeout = Integer.MIN_VALUE;

private  boolean _timeoutSet = false;

/*
* Advisory title information about markup elements generated for this component
*/
private  String _title = null;

/*
* The list (or single value) of symbols which can be used
                for division chosen of suggestion pop-up values in a
                target element. After input of a symbol from the list
                suggestion pop-up it is caused again
*/
private  Object _tokens = null;

/*
* if true, a suggested object list will be created and will be updated every time when  an input value is changed. Default value is "false".
*/
private  boolean _usingSuggestObjects = false;

private  boolean _usingSuggestObjectsSet = false;

/*
* Width of the pop-up window in pixels. Default value is "200".
*/
private  String _width = null;

/*
* Attribute is similar to the standard HTML attribute and can specify window placement relative to the content. Default value is "200".
*/
private  int _zindex = 200;

private  boolean _zindexSet = false;


public HtmlSuggestionBox(){
setRendererType("org.richfaces.SuggestionBox");
}

public boolean isAjaxSingle(){
	if (this._ajaxSingleSet) {
	    return (this._ajaxSingle);
	}
	ValueExpression ve = getValueExpression("ajaxSingle");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ajaxSingle);
	    }
	    
	    return value;
	} else {
	    return (this._ajaxSingle);
	}

}

public void setAjaxSingle(boolean _ajaxSingle){
this._ajaxSingle = _ajaxSingle;
this._ajaxSingleSet = true;
}

public String getAlign(){
	if (this._align != null) {
		return this._align;
	}
	ValueExpression ve = getValueExpression("align");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setAlign(String _align){
this._align = _align;
}

public String getBgcolor(){
	if (this._bgcolor != null) {
		return this._bgcolor;
	}
	ValueExpression ve = getValueExpression("bgcolor");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setBgcolor(String _bgcolor){
this._bgcolor = _bgcolor;
}

public String getBorder(){
	if (this._border != null) {
		return this._border;
	}
	ValueExpression ve = getValueExpression("border");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setBorder(String _border){
this._border = _border;
}

public boolean isBypassUpdates(){
	if (this._bypassUpdatesSet) {
	    return (this._bypassUpdates);
	}
	ValueExpression ve = getValueExpression("bypassUpdates");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._bypassUpdates);
	    }
	    
	    return value;
	} else {
	    return (this._bypassUpdates);
	}

}

public void setBypassUpdates(boolean _bypassUpdates){
this._bypassUpdates = _bypassUpdates;
this._bypassUpdatesSet = true;
}

public String getCellpadding(){
	if (this._cellpadding != null) {
		return this._cellpadding;
	}
	ValueExpression ve = getValueExpression("cellpadding");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCellpadding(String _cellpadding){
this._cellpadding = _cellpadding;
}

public String getCellspacing(){
	if (this._cellspacing != null) {
		return this._cellspacing;
	}
	ValueExpression ve = getValueExpression("cellspacing");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setCellspacing(String _cellspacing){
this._cellspacing = _cellspacing;
}

public Converter getConverter(){
	if (this._converter != null) {
		return this._converter;
	}
	ValueExpression ve = getValueExpression("converter");
	if (ve != null) {
	    Converter value = null;
	    
	    try {
			value = (Converter) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setConverter(Converter _converter){
this._converter = _converter;
}

public Object getData(){
	if (this._data != null) {
		return this._data;
	}
	ValueExpression ve = getValueExpression("data");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setData(Object _data){
this._data = _data;
}

public String getDir(){
	if (this._dir != null) {
		return this._dir;
	}
	ValueExpression ve = getValueExpression("dir");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setDir(String _dir){
this._dir = _dir;
}

public String getEntryClass(){
	if (this._entryClass != null) {
		return this._entryClass;
	}
	ValueExpression ve = getValueExpression("entryClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setEntryClass(String _entryClass){
this._entryClass = _entryClass;
}

public String getEventsQueue(){
	if (this._eventsQueue != null) {
		return this._eventsQueue;
	}
	ValueExpression ve = getValueExpression("eventsQueue");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setEventsQueue(String _eventsQueue){
this._eventsQueue = _eventsQueue;
}

public Object getFetchValue(){
	if (this._fetchValue != null) {
		return this._fetchValue;
	}
	ValueExpression ve = getValueExpression("fetchValue");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFetchValue(Object _fetchValue){
this._fetchValue = _fetchValue;
}

public String getFocus(){
	if (this._focus != null) {
		return this._focus;
	}
	ValueExpression ve = getValueExpression("focus");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFocus(String _focus){
this._focus = _focus;
}

public String getFor(){
	if (this._for != null) {
		return this._for;
	}
	ValueExpression ve = getValueExpression("for");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFor(String _for){
this._for = _for;
}

public String getFrame(){
	if (this._frame != null) {
		return this._frame;
	}
	ValueExpression ve = getValueExpression("frame");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setFrame(String _frame){
this._frame = _frame;
}

public double getFrequency(){
	if (this._frequencySet) {
	    return (this._frequency);
	}
	ValueExpression ve = getValueExpression("frequency");
	if (ve != null) {
	    Double value = null;
	    
	    try {
			value = (Double) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._frequency);
	    }
	    
	    return value;
	} else {
	    return (this._frequency);
	}

}

public void setFrequency(double _frequency){
this._frequency = _frequency;
this._frequencySet = true;
}

public String getHeight(){
	if (this._height != null) {
		return this._height;
	}
	ValueExpression ve = getValueExpression("height");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "200";
	

}

public void setHeight(String _height){
this._height = _height;
}

public boolean isIgnoreDupResponses(){
	if (this._ignoreDupResponsesSet) {
	    return (this._ignoreDupResponses);
	}
	ValueExpression ve = getValueExpression("ignoreDupResponses");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._ignoreDupResponses);
	    }
	    
	    return value;
	} else {
	    return (this._ignoreDupResponses);
	}

}

public void setIgnoreDupResponses(boolean _ignoreDupResponses){
this._ignoreDupResponses = _ignoreDupResponses;
this._ignoreDupResponsesSet = true;
}

public boolean isImmediate(){
	if (this._immediateSet) {
	    return (this._immediate);
	}
	ValueExpression ve = getValueExpression("immediate");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._immediate);
	    }
	    
	    return value;
	} else {
	    return (this._immediate);
	}

}

public void setImmediate(boolean _immediate){
this._immediate = _immediate;
this._immediateSet = true;
}

public String getLang(){
	if (this._lang != null) {
		return this._lang;
	}
	ValueExpression ve = getValueExpression("lang");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setLang(String _lang){
this._lang = _lang;
}

public boolean isLimitToList(){
	if (this._limitToListSet) {
	    return (this._limitToList);
	}
	ValueExpression ve = getValueExpression("limitToList");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._limitToList);
	    }
	    
	    return value;
	} else {
	    return (this._limitToList);
	}

}

public void setLimitToList(boolean _limitToList){
this._limitToList = _limitToList;
this._limitToListSet = true;
}

public String getMinChars(){
	if (this._minChars != null) {
		return this._minChars;
	}
	ValueExpression ve = getValueExpression("minChars");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setMinChars(String _minChars){
this._minChars = _minChars;
}

public String getNothingLabel(){
	if (this._nothingLabel != null) {
		return this._nothingLabel;
	}
	ValueExpression ve = getValueExpression("nothingLabel");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setNothingLabel(String _nothingLabel){
this._nothingLabel = _nothingLabel;
}

public String getOnbeforedomupdate(){
	if (this._onbeforedomupdate != null) {
		return this._onbeforedomupdate;
	}
	ValueExpression ve = getValueExpression("onbeforedomupdate");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnbeforedomupdate(String _onbeforedomupdate){
this._onbeforedomupdate = _onbeforedomupdate;
}

public String getOncomplete(){
	if (this._oncomplete != null) {
		return this._oncomplete;
	}
	ValueExpression ve = getValueExpression("oncomplete");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOncomplete(String _oncomplete){
this._oncomplete = _oncomplete;
}

public String getOnobjectchange(){
	if (this._onobjectchange != null) {
		return this._onobjectchange;
	}
	ValueExpression ve = getValueExpression("onobjectchange");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnobjectchange(String _onobjectchange){
this._onobjectchange = _onobjectchange;
}

public String getOnselect(){
	if (this._onselect != null) {
		return this._onselect;
	}
	ValueExpression ve = getValueExpression("onselect");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnselect(String _onselect){
this._onselect = _onselect;
}

public String getOnsubmit(){
	if (this._onsubmit != null) {
		return this._onsubmit;
	}
	ValueExpression ve = getValueExpression("onsubmit");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setOnsubmit(String _onsubmit){
this._onsubmit = _onsubmit;
}

public String getParam(){
	if (this._param != null) {
		return this._param;
	}
	ValueExpression ve = getValueExpression("param");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "inputvalue";
	

}

public void setParam(String _param){
this._param = _param;
}

public String getPopupClass(){
	if (this._popupClass != null) {
		return this._popupClass;
	}
	ValueExpression ve = getValueExpression("popupClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setPopupClass(String _popupClass){
this._popupClass = _popupClass;
}

public String getPopupStyle(){
	if (this._popupStyle != null) {
		return this._popupStyle;
	}
	ValueExpression ve = getValueExpression("popupStyle");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setPopupStyle(String _popupStyle){
this._popupStyle = _popupStyle;
}

public Object getProcess(){
	if (this._process != null) {
		return this._process;
	}
	ValueExpression ve = getValueExpression("process");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setProcess(Object _process){
this._process = _process;
}

public Object getReRender(){
	if (this._reRender != null) {
		return this._reRender;
	}
	ValueExpression ve = getValueExpression("reRender");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setReRender(Object _reRender){
this._reRender = _reRender;
}

public int getRequestDelay(){
	if (this._requestDelaySet) {
	    return (this._requestDelay);
	}
	ValueExpression ve = getValueExpression("requestDelay");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._requestDelay);
	    }
	    
	    return value;
	} else {
	    return (this._requestDelay);
	}

}

public void setRequestDelay(int _requestDelay){
this._requestDelay = _requestDelay;
this._requestDelaySet = true;
}

public String getRowClasses(){
	if (this._rowClasses != null) {
		return this._rowClasses;
	}
	ValueExpression ve = getValueExpression("rowClasses");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setRowClasses(String _rowClasses){
this._rowClasses = _rowClasses;
}

public String getRules(){
	if (this._rules != null) {
		return this._rules;
	}
	ValueExpression ve = getValueExpression("rules");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setRules(String _rules){
this._rules = _rules;
}

public String getSelectValueClass(){
	if (this._selectValueClass != null) {
		return this._selectValueClass;
	}
	ValueExpression ve = getValueExpression("selectValueClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setSelectValueClass(String _selectValueClass){
this._selectValueClass = _selectValueClass;
}

public String getSelectedClass(){
	if (this._selectedClass != null) {
		return this._selectedClass;
	}
	ValueExpression ve = getValueExpression("selectedClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSelectedClass(String _selectedClass){
this._selectedClass = _selectedClass;
}

public boolean isSelfRendered(){
	if (this._selfRenderedSet) {
	    return (this._selfRendered);
	}
	ValueExpression ve = getValueExpression("selfRendered");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._selfRendered);
	    }
	    
	    return value;
	} else {
	    return (this._selfRendered);
	}

}

public void setSelfRendered(boolean _selfRendered){
this._selfRendered = _selfRendered;
this._selfRenderedSet = true;
}

public String getShadowDepth(){
	if (this._shadowDepth != null) {
		return this._shadowDepth;
	}
	ValueExpression ve = getValueExpression("shadowDepth");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setShadowDepth(String _shadowDepth){
this._shadowDepth = _shadowDepth;
}

public String getShadowOpacity(){
	if (this._shadowOpacity != null) {
		return this._shadowOpacity;
	}
	ValueExpression ve = getValueExpression("shadowOpacity");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setShadowOpacity(String _shadowOpacity){
this._shadowOpacity = _shadowOpacity;
}

public String getSimilarityGroupingId(){
	if (this._similarityGroupingId != null) {
		return this._similarityGroupingId;
	}
	ValueExpression ve = getValueExpression("similarityGroupingId");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSimilarityGroupingId(String _similarityGroupingId){
this._similarityGroupingId = _similarityGroupingId;
}

public String getStatus(){
	if (this._status != null) {
		return this._status;
	}
	ValueExpression ve = getValueExpression("status");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setStatus(String _status){
this._status = _status;
}

public String getStyle(){
	if (this._style != null) {
		return this._style;
	}
	ValueExpression ve = getValueExpression("style");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyle(String _style){
this._style = _style;
}

public String getStyleClass(){
	if (this._styleClass != null) {
		return this._styleClass;
	}
	ValueExpression ve = getValueExpression("styleClass");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "";
	

}

public void setStyleClass(String _styleClass){
this._styleClass = _styleClass;
}

public Object getSubmitedValue(){
	if (this._submitedValue != null) {
		return this._submitedValue;
	}
	ValueExpression ve = getValueExpression("submitedValue");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSubmitedValue(Object _submitedValue){
this._submitedValue = _submitedValue;
}

public MethodExpression getSuggestionAction(){
return _suggestionAction;
}

public void setSuggestionAction(MethodExpression _suggestionAction){
this._suggestionAction = _suggestionAction;
}

public String getSummary(){
	if (this._summary != null) {
		return this._summary;
	}
	ValueExpression ve = getValueExpression("summary");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setSummary(String _summary){
this._summary = _summary;
}

public int getTimeout(){
	if (this._timeoutSet) {
	    return (this._timeout);
	}
	ValueExpression ve = getValueExpression("timeout");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._timeout);
	    }
	    
	    return value;
	} else {
	    return (this._timeout);
	}

}

public void setTimeout(int _timeout){
this._timeout = _timeout;
this._timeoutSet = true;
}

public String getTitle(){
	if (this._title != null) {
		return this._title;
	}
	ValueExpression ve = getValueExpression("title");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTitle(String _title){
this._title = _title;
}

public Object getTokens(){
	if (this._tokens != null) {
		return this._tokens;
	}
	ValueExpression ve = getValueExpression("tokens");
	if (ve != null) {
	    Object value = null;
	    
	    try {
			value = (Object) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return null;
	

}

public void setTokens(Object _tokens){
this._tokens = _tokens;
}

public boolean isUsingSuggestObjects(){
	if (this._usingSuggestObjectsSet) {
	    return (this._usingSuggestObjects);
	}
	ValueExpression ve = getValueExpression("usingSuggestObjects");
	if (ve != null) {
	    Boolean value = null;
	    
	    try {
			value = (Boolean) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._usingSuggestObjects);
	    }
	    
	    return value;
	} else {
	    return (this._usingSuggestObjects);
	}

}

public void setUsingSuggestObjects(boolean _usingSuggestObjects){
this._usingSuggestObjects = _usingSuggestObjects;
this._usingSuggestObjectsSet = true;
}

public String getWidth(){
	if (this._width != null) {
		return this._width;
	}
	ValueExpression ve = getValueExpression("width");
	if (ve != null) {
	    String value = null;
	    
	    try {
			value = (String) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    return value;
	} 

    return "200";
	

}

public void setWidth(String _width){
this._width = _width;
}

public int getZindex(){
	if (this._zindexSet) {
	    return (this._zindex);
	}
	ValueExpression ve = getValueExpression("zindex");
	if (ve != null) {
	    Integer value = null;
	    
	    try {
			value = (Integer) ve.getValue(getFacesContext().getELContext());
	    } catch (ELException e) {
			throw new FacesException(e);
	    }
	    
	    if (null == value) {
			return (this._zindex);
	    }
	    
	    return value;
	} else {
	    return (this._zindex);
	}

}

public void setZindex(int _zindex){
this._zindex = _zindex;
this._zindexSet = true;
}

public String getFamily(){
return COMPONENT_FAMILY;
}

@Override
public Object saveState(FacesContext context){
Object [] state = new Object[67];
state[0] = super.saveState(context);
state[1] = Boolean.valueOf(_ajaxSingle);
state[2] = Boolean.valueOf(_ajaxSingleSet);
state[3] = _align;
state[4] = _bgcolor;
state[5] = _border;
state[6] = Boolean.valueOf(_bypassUpdates);
state[7] = Boolean.valueOf(_bypassUpdatesSet);
state[8] = _cellpadding;
state[9] = _cellspacing;
state[10] = saveAttachedState(context, _converter);
state[11] = saveAttachedState(context, _data);
state[12] = _dir;
state[13] = _entryClass;
state[14] = _eventsQueue;
state[15] = saveAttachedState(context, _fetchValue);
state[16] = _focus;
state[17] = _for;
state[18] = _frame;
state[19] = Double.valueOf(_frequency);
state[20] = Boolean.valueOf(_frequencySet);
state[21] = _height;
state[22] = Boolean.valueOf(_ignoreDupResponses);
state[23] = Boolean.valueOf(_ignoreDupResponsesSet);
state[24] = Boolean.valueOf(_immediate);
state[25] = Boolean.valueOf(_immediateSet);
state[26] = _lang;
state[27] = Boolean.valueOf(_limitToList);
state[28] = Boolean.valueOf(_limitToListSet);
state[29] = _minChars;
state[30] = _nothingLabel;
state[31] = _onbeforedomupdate;
state[32] = _oncomplete;
state[33] = _onobjectchange;
state[34] = _onselect;
state[35] = _onsubmit;
state[36] = _param;
state[37] = _popupClass;
state[38] = _popupStyle;
state[39] = saveAttachedState(context, _process);
state[40] = saveAttachedState(context, _reRender);
state[41] = Integer.valueOf(_requestDelay);
state[42] = Boolean.valueOf(_requestDelaySet);
state[43] = _rowClasses;
state[44] = _rules;
state[45] = _selectValueClass;
state[46] = _selectedClass;
state[47] = Boolean.valueOf(_selfRendered);
state[48] = Boolean.valueOf(_selfRenderedSet);
state[49] = _shadowDepth;
state[50] = _shadowOpacity;
state[51] = _similarityGroupingId;
state[52] = _status;
state[53] = _style;
state[54] = _styleClass;
state[55] = saveAttachedState(context, _submitedValue);
state[56] = saveAttachedState(context, _suggestionAction);
state[57] = _summary;
state[58] = Integer.valueOf(_timeout);
state[59] = Boolean.valueOf(_timeoutSet);
state[60] = _title;
state[61] = saveAttachedState(context, _tokens);
state[62] = Boolean.valueOf(_usingSuggestObjects);
state[63] = Boolean.valueOf(_usingSuggestObjectsSet);
state[64] = _width;
state[65] = Integer.valueOf(_zindex);
state[66] = Boolean.valueOf(_zindexSet);
return state;
}

@Override
public void restoreState(FacesContext context, Object state){
Object[] states = (Object[]) state;
super.restoreState(context, states[0]);
	_ajaxSingle = ((Boolean)states[1]).booleanValue();
		_ajaxSingleSet = ((Boolean)states[2]).booleanValue();
		_align = (String)states[3];;
		_bgcolor = (String)states[4];;
		_border = (String)states[5];;
		_bypassUpdates = ((Boolean)states[6]).booleanValue();
		_bypassUpdatesSet = ((Boolean)states[7]).booleanValue();
		_cellpadding = (String)states[8];;
		_cellspacing = (String)states[9];;
		_converter = (Converter)restoreAttachedState(context, states[10]);
		_data = (Object)restoreAttachedState(context, states[11]);
		_dir = (String)states[12];;
		_entryClass = (String)states[13];;
		_eventsQueue = (String)states[14];;
		_fetchValue = (Object)restoreAttachedState(context, states[15]);
		_focus = (String)states[16];;
		_for = (String)states[17];;
		_frame = (String)states[18];;
		_frequency = ((Double)states[19]).doubleValue();
		_frequencySet = ((Boolean)states[20]).booleanValue();
		_height = (String)states[21];;
		_ignoreDupResponses = ((Boolean)states[22]).booleanValue();
		_ignoreDupResponsesSet = ((Boolean)states[23]).booleanValue();
		_immediate = ((Boolean)states[24]).booleanValue();
		_immediateSet = ((Boolean)states[25]).booleanValue();
		_lang = (String)states[26];;
		_limitToList = ((Boolean)states[27]).booleanValue();
		_limitToListSet = ((Boolean)states[28]).booleanValue();
		_minChars = (String)states[29];;
		_nothingLabel = (String)states[30];;
		_onbeforedomupdate = (String)states[31];;
		_oncomplete = (String)states[32];;
		_onobjectchange = (String)states[33];;
		_onselect = (String)states[34];;
		_onsubmit = (String)states[35];;
		_param = (String)states[36];;
		_popupClass = (String)states[37];;
		_popupStyle = (String)states[38];;
		_process = (Object)restoreAttachedState(context, states[39]);
		_reRender = (Object)restoreAttachedState(context, states[40]);
		_requestDelay = ((Integer)states[41]).intValue();
		_requestDelaySet = ((Boolean)states[42]).booleanValue();
		_rowClasses = (String)states[43];;
		_rules = (String)states[44];;
		_selectValueClass = (String)states[45];;
		_selectedClass = (String)states[46];;
		_selfRendered = ((Boolean)states[47]).booleanValue();
		_selfRenderedSet = ((Boolean)states[48]).booleanValue();
		_shadowDepth = (String)states[49];;
		_shadowOpacity = (String)states[50];;
		_similarityGroupingId = (String)states[51];;
		_status = (String)states[52];;
		_style = (String)states[53];;
		_styleClass = (String)states[54];;
		_submitedValue = (Object)restoreAttachedState(context, states[55]);
		_suggestionAction = (MethodExpression)restoreAttachedState(context, states[56]);
		_summary = (String)states[57];;
		_timeout = ((Integer)states[58]).intValue();
		_timeoutSet = ((Boolean)states[59]).booleanValue();
		_title = (String)states[60];;
		_tokens = (Object)restoreAttachedState(context, states[61]);
		_usingSuggestObjects = ((Boolean)states[62]).booleanValue();
		_usingSuggestObjectsSet = ((Boolean)states[63]).booleanValue();
		_width = (String)states[64];;
		_zindex = ((Integer)states[65]).intValue();
		_zindexSet = ((Boolean)states[66]).booleanValue();
	
}

}
