/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.AbstractExtendedTableRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.ExtendedDataTableRenderer
 */
public class ExtendedDataTableRenderer extends AbstractExtendedTableRenderer {

	public ExtendedDataTableRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/extendedDataTable.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	private final InternetResource[] scripts = {
						new org.ajax4jsf.javascript.AjaxScript()
						,
				new org.ajax4jsf.javascript.PrototypeScript()
						,
				getResource("/org/richfaces/renderkit/html/scripts/utils.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/browser_info.js")
						,
				getResource("/org/ajax4jsf/javascript/scripts/form.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/form.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/jquery/jquery.js")
						,
				getResource("/org/richfaces/renderkit/html/script/controlUtils.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/common-scrollable-data-table.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/extended-data-table.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/drag-indicator.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/ext-dt-drag-indicator.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/ext-dt-simple-draggable.js")
						,
				getResource("/org/richfaces/renderkit/html/scripts/ext-dt-simple-dropzone.js")
	};

private InternetResource[] scriptsAll = null;

protected InternetResource[] getScripts() {
	synchronized (this) {
		if (scriptsAll == null) {
			InternetResource[] rsrcs = super.getScripts();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = scripts == null || scripts.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					scriptsAll = new InternetResource[0];	
				} else {
					scriptsAll = scripts;
				}
			} else {
				if (ignoreThis) {
					scriptsAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < scripts.length; i++ ) {
						rsrcsSet.add(scripts[i]);
					}

					scriptsAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return scriptsAll;
}
	// 
	// 
	//

	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIExtendedDataTable.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UIExtendedDataTable)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UIExtendedDataTable component, ComponentVariables variables ) throws IOException {
	    java.lang.String clientId = component.getClientId(context);

     	
			variables.setVariable("columnsCount", getColumnsCount(component)+1);
		
    
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "extdt-maindiv rich-extdt-maindiv" );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "onkeydown", component.getAttributes().get("onkeydown") );
						getUtils().writeAttribute(writer, "onkeypress", component.getAttributes().get("onkeypress") );
						getUtils().writeAttribute(writer, "onkeyup", component.getAttributes().get("onkeyup") );
						getUtils().writeAttribute(writer, "style", convertToString(component.getAttributes().get("style")) + ";width:" + convertToString(component.getAttributes().get("width")) + ";height:" + convertToString(component.getAttributes().get("height")) );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "extdt-outerdiv" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":od" );
						getUtils().writeAttribute(writer, "style", "width:100%; height:100%;overflow: hidden;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "drgind_fly drgind_default drag_indicator" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":dataTable_indicator" );
						getUtils().writeAttribute(writer, "style", "display: none;" );
			
encodeNamespace(context, component);

writer.endElement("div");
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("//"),null);

     writer.write("<![CDATA[");
     writer.write(convertToString("\n            " + convertToString(encodeDragDropChildScripts(context,component)) + ";\n            //"));
     writer.write("]]>");

writer.endElement("script");
writer.startElement("span", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":dataTable_indicator_span" );
			
writer.endElement("span");
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "extdt-innerdiv" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":innerd" );
						getUtils().writeAttribute(writer, "style", "height:100%;width:100%;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "extdt-hsplit" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":cs" );
						getUtils().writeAttribute(writer, "style", "display: none;" );
			
writer.endElement("div");
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "cellpadding", "0" );
						getUtils().writeAttribute(writer, "cellspacing", "0" );
						getUtils().writeAttribute(writer, "class", "extdt-table-layout rich-table " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":tu" );
						getUtils().writeAttribute(writer, "width", "100%" );
			
writer.startElement("colgroup", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":colgroup:header" );
			
encodeColumns(context, component);

writer.endElement("colgroup");
encodeCaption(context, component);

encodeHeader(context, component);

writer.startElement("tbody", component);

writer.startElement("tr", component);

writer.startElement("td", component);
			getUtils().writeAttribute(writer, "colspan", variables.getVariable("columnsCount") );
						getUtils().writeAttribute(writer, "style", "padding: 0px;" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "extdt-content" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":sd" );
						getUtils().writeAttribute(writer, "style", "height:50px;width:100%;overflow:hidden;" );
			

				     		
								if (component.getRowCount() <= 0) {
								
							
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "class", "extdt-table-layout rich-table " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":empty" );
						getUtils().writeAttribute(writer, "width", "100%" );
			
getUtils().encodePassThruWithExclusions(context, component, "height,value,name,type,id,class,rows,style,width");

writer.startElement("tbody", component);

encodeNoDataRow(context, component);

writer.endElement("tbody");
writer.endElement("table");

				     		
								}
								
							
writer.startElement("table", component);
			getUtils().writeAttribute(writer, "class", "extdt-table-layout rich-table " + convertToString(component.getAttributes().get("styleClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":n" );
						getUtils().writeAttribute(writer, "style", "width:100%; height:100%;overflow: hidden;" );
			
getUtils().encodePassThruWithExclusions(context, component, "height,value,name,type,id,class,rows,style,width");

writer.startElement("colgroup", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":colgroup:body" );
			
encodeColumns(context, component);

writer.endElement("colgroup");
writer.startElement("tbody", component);
			getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":tb" );
			

	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.richfaces.component.UIExtendedDataTable)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.richfaces.component.UIExtendedDataTable component, ComponentVariables variables) throws IOException {
	    
encodeRows(context, component);


	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIExtendedDataTable component, ComponentVariables variables) throws IOException {
	  
writer.endElement("tbody");
writer.endElement("table");
writer.endElement("div");
writer.endElement("td");
writer.endElement("tr");
writer.endElement("tbody");
encodeFooter(context, component);

writer.endElement("table");
contributorsEncodeHere(context, component);

writer.endElement("div");
java.lang.String clientId = component.getClientId(context);
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "extdt-ss-vsbl" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":splashscreen" );
			
writer.endElement("div");
writer.startElement("script", component);
			getUtils().writeAttribute(writer, "type", "text/javascript" );
			
writer.writeText(convertToString("//"),null);

     writer.write("<![CDATA[");
     writer.write(convertToString("\n			delete " + convertToString(getJavaScriptVarName(context,component)) + ";\n			" + convertToString(getJavaScriptVarName(context,component)) + " = " + convertToString(createClientDataTable(context,component)) + ";\n			" + convertToString(getScriptContributions(context,component)) + ";\n		//"));
     writer.write("]]>");

writer.endElement("script");
writer.endElement("div");

		
		         if((Boolean)component.getAttributes().get("enableContextMenu") == true) {
		        	 encodeTableMenu(context, component);
		         }
		
	
writer.endElement("div");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIExtendedDataTable)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
