/**
 * License Agreement.
 *
 * Ajax4jsf 1.1 - Natural Ajax for Java Server Faces (JSF)
 *
 * Copyright (C) 2007 Exadel, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

package org.richfaces.renderkit.html;


// 
// Imports
//
import java.util.Iterator;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.renderkit.ComponentsVariableResolver;
import org.ajax4jsf.renderkit.ComponentVariables;
import org.ajax4jsf.resource.InternetResource;
//
//
//


import org.richfaces.renderkit.AbstractPageRenderer;



/**
 * Renderer for component class org.richfaces.renderkit.html.PageRenderer
 */
public class PageRenderer extends AbstractPageRenderer {

	public PageRenderer () {
		super();
	}

	// 
	// Declarations
	//
	private final InternetResource[] styles = {
						getResource("css/page.xcss")
	};

private InternetResource[] stylesAll = null;

protected InternetResource[] getStyles() {
	synchronized (this) {
		if (stylesAll == null) {
			InternetResource[] rsrcs = super.getStyles();
			boolean ignoreSuper = rsrcs == null || rsrcs.length == 0;
			boolean ignoreThis = styles == null || styles.length == 0;
			
			if (ignoreSuper) {
				if (ignoreThis) {
					stylesAll = new InternetResource[0];	
				} else {
					stylesAll = styles;
				}
			} else {
				if (ignoreThis) {
					stylesAll = rsrcs;
				} else {
					java.util.Set rsrcsSet = new java.util.LinkedHashSet();

					for (int i = 0; i < rsrcs.length; i++ ) {
						rsrcsSet.add(rsrcs[i]);
					}

					for (int i = 0; i < styles.length; i++ ) {
						rsrcsSet.add(styles[i]);
					}

					stylesAll = (InternetResource[]) rsrcsSet.toArray(new InternetResource[rsrcsSet.size()]);
				}
			}
		}
	}
	
	return stylesAll;
}
	// 
	// 
	//

	private String convertToString(Object obj ) {
		return ( obj == null ? "" : obj.toString() );
	}
	private String convertToString(boolean b ) {
		return String.valueOf(b);
	}
	private String convertToString(int b ) {
		return b!=Integer.MIN_VALUE?String.valueOf(b):"";
	}
	private String convertToString(long b ) {
		return b!=Long.MIN_VALUE?String.valueOf(b):"";
	}
	
	/**
	 * Get base component class, targetted for this renderer. Used for check arguments in decode/encode.
	 * @return
	 */
	protected Class getComponentClass() {
		return org.richfaces.component.UIPage.class;
	}

	
	public void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component ) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeBegin(writer, context, (org.richfaces.component.UIPage)component, variables );
	}		

	public void doEncodeBegin(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPage component, ComponentVariables variables ) throws IOException {
	    java.lang.String clientId = component.getClientId(context);
variables.setVariable("namespace", prolog(context,component) );
writer.startElement("html", component);
			getUtils().writeAttribute(writer, "lang", context.getViewRoot().getLocale() );
						getUtils().writeAttribute(writer, "xmlns", variables.getVariable("namespace") );
			
writer.startElement("head", component);

if ( Boolean.valueOf( String.valueOf(hasTitle(context,component)) ).booleanValue() ) {


writer.startElement("title", component);

writer.writeText(convertToString(component.getAttributes().get("pageTitle")),null);

writer.endElement("title");
}
themeStyle(context, component);

themeScript(context, component);

pageStyle(context, component);

UIComponent indexChildren_34 = component.getFacet("pageHeader");
if (null != indexChildren_34 && indexChildren_34 .isRendered()) {
	renderChild(context, indexChildren_34);
}

writer.endElement("head");
writer.startElement("body", component);
			getUtils().writeAttribute(writer, "oncontextmenu", component.getAttributes().get("oncontextmenu") );
			//
// pass thru attributes
//
getUtils().encodeAttributesFromArray(context,component,new String[] {
    "alink" ,
	    "background" ,
	    "bgcolor" ,
	    "dir" ,
	    "lang" ,
	    "link" ,
	    "onclick" ,
	    "ondblclick" ,
	    "onkeydown" ,
	    "onkeypress" ,
	    "onkeyup" ,
	    "onload" ,
	    "onmousedown" ,
	    "onmousemove" ,
	    "onmouseout" ,
	    "onmouseover" ,
	    "onmouseup" ,
	    "onunload" ,
	    "style" ,
	    "text" ,
	    "title" ,
	    "vlink" ,
	    "xml:lang" });
//
//
//

writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page " + convertToString(component.getAttributes().get("pageClass")) );
						getUtils().writeAttribute(writer, "id", clientId );
						getUtils().writeAttribute(writer, "style", component.getAttributes().get("pageStyle") );
			
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"header")) ).booleanValue() ) {


writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-header " + convertToString(component.getAttributes().get("headerClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":hd" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-header-content" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":hdc" );
			
UIComponent indexChildren_35 = component.getFacet("header");
if (null != indexChildren_35 && indexChildren_35 .isRendered()) {
	renderChild(context, indexChildren_35);
}

writer.endElement("div");
writer.endElement("div");
}
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"subheader")) ).booleanValue() ) {


writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-subheader " + convertToString(component.getAttributes().get("subheaderClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":shd" );
			
UIComponent indexChildren_36 = component.getFacet("subheader");
if (null != indexChildren_36 && indexChildren_36 .isRendered()) {
	renderChild(context, indexChildren_36);
}

writer.endElement("div");
}
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-content " + convertToString(component.getAttributes().get("contentClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":cnt" );
			
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"sidebar")) ).booleanValue() ) {


writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-sidebar " + convertToString(component.getAttributes().get("sidebarClass")) );
			
UIComponent indexChildren_37 = component.getFacet("sidebar");
if (null != indexChildren_37 && indexChildren_37 .isRendered()) {
	renderChild(context, indexChildren_37);
}

writer.endElement("div");
}

	}		
	
    public void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeChildren(writer, context, (org.richfaces.component.UIPage)component, variables );
	}		

    public void doEncodeChildren(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPage component, ComponentVariables variables) throws IOException {
	    
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-main" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-body " + convertToString(component.getAttributes().get("bodyClass")) );
			
renderChildren(context, component);

writer.endElement("div");
writer.endElement("div");

	}		

	/* (non-Javadoc)
	 * @see javax.faces.render.Renderer#getRendersChildren()
	 */
	public boolean getRendersChildren() {
		return true;
	}

	public void doEncodeEnd(ResponseWriter writer, FacesContext context, org.richfaces.component.UIPage component, ComponentVariables variables) throws IOException {
	  
writer.endElement("div");
if ( Boolean.valueOf( String.valueOf(hasFacet(component,"footer")) ).booleanValue() ) {


java.lang.String clientId = component.getClientId(context);
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-footer " + convertToString(component.getAttributes().get("footerClass")) );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":ft" );
			
writer.startElement("div", component);
			getUtils().writeAttribute(writer, "class", "rich-page-footer-content" );
						getUtils().writeAttribute(writer, "id", convertToString(clientId) + ":ftc" );
			
UIComponent indexChildren_38 = component.getFacet("footer");
if (null != indexChildren_38 && indexChildren_38 .isRendered()) {
	renderChild(context, indexChildren_38);
}

writer.endElement("div");
writer.endElement("div");
}
writer.endElement("div");
writer.endElement("body");
writer.endElement("html");

	}		
	
	public void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
		ComponentVariables variables = ComponentsVariableResolver.getVariables(this, component);
		doEncodeEnd(writer, context, (org.richfaces.component.UIPage)component, variables );

		ComponentsVariableResolver.removeVariables(this, component);
	}		
	

}
