/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server;

import com.google.gson.Gson;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.bpm.console.client.model.PluginInfo;
import org.jboss.bpm.console.client.model.ServerStatus;
import org.jboss.bpm.console.server.EngineFacade;
import org.jboss.bpm.console.server.FormProcessingFacade;
import org.jboss.bpm.console.server.ProcessHistoryFacade;
import org.jboss.bpm.console.server.ProcessMgmtFacade;
import org.jboss.bpm.console.server.TaskListFacade;
import org.jboss.bpm.console.server.TaskMgmtFacade;
import org.jboss.bpm.console.server.UserMgmtFacade;
import org.jboss.bpm.console.server.gson.GsonFactory;
import org.jboss.bpm.console.server.plugin.FormDispatcherPlugin;
import org.jboss.bpm.console.server.plugin.GraphViewerPlugin;
import org.jboss.bpm.console.server.plugin.PluginMgr;
import org.jboss.bpm.console.server.plugin.ProcessEnginePlugin;
import org.jboss.bpm.console.server.util.RsComment;
import org.jboss.bpm.console.server.util.RsDocBuilder;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="server")
@RsComment(title="Server Info", description="General REST server information")
public class InfoFacade {
    private Class[] pluginInterfaces = new Class[]{FormDispatcherPlugin.class, GraphViewerPlugin.class, ProcessEnginePlugin.class};
    private ServerStatus status = null;

    @GET
    @Path(value="status")
    @Produces(value={"application/json"})
    @RsComment(title="Plugins", description="Plugin availability")
    public Response getServerInfo() {
        ServerStatus status = this.getServerStatus();
        return this.createJsonResponse((Object)status);
    }

    @GET
    @Path(value="bpelstatus")
    @Produces(value={"application/json"})
    @RsComment(title="BpelStatus", description="BPEL Engine Availability")
    public Response getRiftSawServerInfo() {
        boolean result = this.isBPELEngineStarted();
        return this.createJsonResponse((Object)result);
    }

    private boolean isBPELEngineStarted() {
        boolean result = true;
        try {
            InitialContext ctx = new InitialContext();
            ctx.lookup("java:jboss/BPELEngine");
        }
        catch (NamingException e) {
            result = false;
        }
        return result;
    }

    private ServerStatus getServerStatus() {
        if (null == this.status) {
            this.status = new ServerStatus();
            for (Class type : this.pluginInterfaces) {
                Object impl = PluginMgr.load((Class)type);
                boolean isAvailable = impl != null;
                this.status.getPlugins().add(new PluginInfo(type.getName(), isAvailable));
            }
        }
        return this.status;
    }

    @GET
    @Path(value="resources/{project}")
    @Produces(value={"text/html"})
    public Response getPublishedUrls(@Context HttpServletRequest request, @PathParam(value="project") String projectName) {
        Class[] rootResources = InfoFacade.getRSResources();
        String rsServer = request.getContextPath();
        if (request.getServletPath() != null && !"".equals(request.getServletPath())) {
            rsServer = request.getContextPath() + request.getServletPath();
        }
        RsDocBuilder rsDocBuilder = new RsDocBuilder(rsServer, rootResources);
        StringBuffer sb = rsDocBuilder.build2HTML(projectName);
        return Response.ok((Object)sb.toString()).build();
    }

    private Response createJsonResponse(Object wrapper) {
        Gson gson = GsonFactory.createInstance();
        String json = gson.toJson(wrapper);
        return Response.ok((Object)json).type("application/json").build();
    }

    public static Class[] getRSResources() {
        return new Class[]{InfoFacade.class, ProcessMgmtFacade.class, TaskListFacade.class, TaskMgmtFacade.class, UserMgmtFacade.class, EngineFacade.class, FormProcessingFacade.class, ProcessHistoryFacade.class};
    }
}

