/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bpm.console.server;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.bpm.console.client.model.HistoryProcessInstanceRefWrapper;
import org.jboss.bpm.console.client.model.ProcessDefinitionRefWrapper;
import org.jboss.bpm.console.client.model.StringRef;
import org.jboss.bpm.console.client.model.StringRefWrapper;
import org.jboss.bpm.console.server.gson.GsonFactory;
import org.jboss.bpm.console.server.plugin.PluginMgr;
import org.jboss.bpm.console.server.plugin.ProcessHistoryPlugin;
import org.jboss.bpm.console.server.util.ProjectName;
import org.jboss.bpm.console.server.util.RsComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/history")
@RsComment(title="Process History", description="Process History Service", project={ProjectName.RIFTSAW})
public class ProcessHistoryFacade {
    private static final Logger log = LoggerFactory.getLogger(ProcessHistoryFacade.class);
    private ProcessHistoryPlugin historyPlugin;

    public ProcessHistoryPlugin getProcessHistoryPlugin() {
        if (this.historyPlugin == null) {
            this.historyPlugin = (ProcessHistoryPlugin)PluginMgr.load(ProcessHistoryPlugin.class);
        }
        return this.historyPlugin;
    }

    @GET
    @Produces(value={"applications/json"})
    @Path(value="definition/{id}/instances")
    public Response findHisotryInstances(@PathParam(value="id") String id, @Context UriInfo info) {
        String status = (String)info.getQueryParameters().getFirst((Object)"status");
        String stime = (String)info.getQueryParameters().getFirst((Object)"starttime");
        String etime = (String)info.getQueryParameters().getFirst((Object)"endtime");
        String ckey = (String)info.getQueryParameters().getFirst((Object)"correlationkey");
        this.checkNotNull("definitionkey", id);
        this.checkNotNull("status", status);
        this.checkNotNull("starttime", stime);
        this.checkNotNull("endtime", etime);
        List refs = this.getProcessHistoryPlugin().getHistoryProcessInstances(id, status, new Long(stime).longValue(), new Long(etime).longValue(), ckey);
        HistoryProcessInstanceRefWrapper wrapper = new HistoryProcessInstanceRefWrapper(refs);
        return this.createJsonResponse((Object)wrapper);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="definitions")
    public Response getProcessDefinitionKeys() {
        List keys = this.getProcessHistoryPlugin().getProcessDefinitions();
        ProcessDefinitionRefWrapper wrapper = new ProcessDefinitionRefWrapper(keys);
        return this.createJsonResponse((Object)wrapper);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="definition/{id}/instancekeys")
    public Response getProcessInstanceKeys(@PathParam(value="id") String definitionId) {
        this.checkNotNull("definitionId", definitionId);
        List instances = this.getProcessHistoryPlugin().getProcessInstanceKeys(definitionId);
        ArrayList<StringRef> result = new ArrayList<StringRef>();
        for (String s : instances) {
            StringRef ref = new StringRef(s);
            result.add(ref);
        }
        return this.createJsonResponse((Object)new StringRefWrapper(result));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="instance/{id}/activities")
    public Response getActivityKeys(@PathParam(value="id") String instanceId) {
        this.checkNotNull("instanceId", instanceId);
        List activityIds = this.getProcessHistoryPlugin().getActivityKeys(instanceId);
        return this.createJsonResponse((Object)activityIds);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="instance/{id}/events")
    public Response getAllEvents(@PathParam(value="id") String instanceId) {
        this.checkNotNull("instanceId", instanceId);
        List events = this.getProcessHistoryPlugin().getAllEvents(instanceId);
        LinkedList<StringRef> result = new LinkedList<StringRef>();
        for (String s : events) {
            StringRef ref = new StringRef(s);
            result.add(ref);
        }
        return this.createJsonResponse((Object)new StringRefWrapper(result));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="definition/{id}/instances/completed")
    public Response getCompletedInstances(@PathParam(value="id") String definitionId, @QueryParam(value="timestamp") String timestamp, @QueryParam(value="timespan") String timespan) {
        this.checkNotNull("definitionId", definitionId);
        this.checkNotNull("timestamp", timestamp);
        this.checkNotNull("timespan", timespan);
        Set instances = this.getProcessHistoryPlugin().getCompletedInstances(definitionId, new Long(timestamp).longValue(), timespan);
        ArrayList<StringRef> result = new ArrayList<StringRef>();
        for (String s : instances) {
            StringRef ref = new StringRef(s);
            result.add(ref);
        }
        return this.createJsonResponse((Object)new StringRefWrapper(result));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="definition/{id}/instances/failed")
    public Response getFailedInstances(@PathParam(value="id") String definitionId, @QueryParam(value="timestamp") String timestamp, @QueryParam(value="timespan") String timespan) {
        this.checkNotNull("definitionId", definitionId);
        this.checkNotNull("timestamp", timestamp);
        this.checkNotNull("timespan", timespan);
        Set instances = this.getProcessHistoryPlugin().getFailedInstances(definitionId, new Long(timestamp).longValue(), timespan);
        ArrayList<StringRef> result = new ArrayList<StringRef>();
        for (String s : instances) {
            StringRef ref = new StringRef(s);
            result.add(ref);
        }
        return this.createJsonResponse((Object)new StringRefWrapper(result));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="definition/{id}/instances/terminated")
    public Response getTerminatedInstances(@PathParam(value="id") String definitionId, @QueryParam(value="timestamp") String timestamp, @QueryParam(value="timespan") String timespan) {
        this.checkNotNull("definitionId", definitionId);
        this.checkNotNull("timestamp", timestamp);
        this.checkNotNull("timespan", timespan);
        Set instances = this.getProcessHistoryPlugin().getTerminatedInstances(definitionId, new Long(timestamp).longValue(), timespan);
        ArrayList<StringRef> result = new ArrayList<StringRef>();
        for (String s : instances) {
            StringRef ref = new StringRef(s);
            result.add(ref);
        }
        return this.createJsonResponse((Object)new StringRefWrapper(result));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="definition/{id}/instances/chart/completed")
    public Response getCompletedInstances4Chart(@PathParam(value="id") String definitionId, @QueryParam(value="timespan") String timespan) {
        this.checkNotNull("definitionId", definitionId);
        this.checkNotNull("timespan", timespan);
        String result = this.getProcessHistoryPlugin().getCompletedInstances4Chart(definitionId, timespan);
        return Response.ok((Object)result).type("application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="definition/{id}/instances/chart/failed")
    public Response getFailedInstances4Chart(@PathParam(value="id") String definitionId, @QueryParam(value="timespan") String timespan) {
        this.checkNotNull("definitionId", definitionId);
        this.checkNotNull("timespan", timespan);
        String result = this.getProcessHistoryPlugin().getFailedInstances4Chart(definitionId, timespan);
        return Response.ok((Object)result).type("application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="instance/recovery/{iid}/{aid}/{action}")
    public Response recoveryAction(@PathParam(value="iid") String iid, @PathParam(value="aid") String aid, @PathParam(value="action") String action) {
        this.checkNotNull("action", action);
        this.getProcessHistoryPlugin().recoveryAction(iid, aid, action);
        return Response.ok().type("application/json").build();
    }

    private Response createJsonResponse(Object wrapper) {
        Gson gson = GsonFactory.createInstance();
        String json = gson.toJson(wrapper);
        return Response.ok((Object)json).type("application/json").build();
    }

    private void checkNotNull(String name, String value) {
        if (null == value || "".equals(value.trim())) {
            throw new NullPointerException(" " + name + " is null.");
        }
    }
}

