/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.util.StringUtils;
import org.robotframework.mavenplugin.Arguments;
import org.robotframework.mavenplugin.TestDocMojo;

public class TestDocConfiguration {
    private File outputDirectory;
    private File outputFile;
    private String dataSourceFile;
    private String title;
    private String name;
    private String doc;

    public String[] generateRunArguments() throws IOException {
        Arguments generatedArguments = new Arguments();
        generatedArguments.add("testdoc");
        generatedArguments.addNonEmptyStringToArguments(this.title, "--title");
        generatedArguments.addNonEmptyStringToArguments(this.name, "--name");
        generatedArguments.addNonEmptyStringToArguments(this.doc, "--doc");
        generatedArguments.add(this.getDatasourceFile());
        generatedArguments.add(this.getOutputPath());
        return generatedArguments.toArray();
    }

    private String getDatasourceFile() throws IOException {
        File libOrResource = new File(this.dataSourceFile);
        if (!libOrResource.exists()) {
            throw new IOException("Data source file " + this.dataSourceFile + " does not exist");
        }
        return libOrResource.getAbsolutePath();
    }

    private String getOutputPath() {
        return this.outputDirectory + File.separator + this.outputFile.getName();
    }

    public void ensureOutputDirectoryExists() throws IOException {
        if (this.outputDirectory == null) {
            String baseDir = System.getProperty("basedir");
            if (baseDir == null) {
                baseDir = ".";
            }
            this.outputDirectory = new File(this.joinPaths(baseDir, "target", "robotframework", "testdoc"));
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException("Target output directory cannot be created: " + this.outputDirectory.getAbsolutePath());
        }
    }

    private String joinPaths(String ... parts) {
        return StringUtils.join((Object[])parts, (String)File.separator);
    }

    public void populateDefaults(TestDocMojo defaults) {
        if (this.outputDirectory == null) {
            this.outputDirectory = defaults.defaultTestdocOutputDirectory;
        }
    }
}

