/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.execution.workflow.steps;

import com.dtolabs.rundeck.core.CoreException;
import com.dtolabs.rundeck.core.common.Framework;
import com.dtolabs.rundeck.core.execution.StepExecutionItem;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherException;
import com.dtolabs.rundeck.core.execution.dispatch.DispatcherResult;
import com.dtolabs.rundeck.core.execution.service.ExecutionServiceException;
import com.dtolabs.rundeck.core.execution.workflow.StepExecutionContext;
import com.dtolabs.rundeck.core.execution.workflow.steps.FailureReason;
import com.dtolabs.rundeck.core.execution.workflow.steps.HasSourceStepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResult;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutionResultImpl;
import com.dtolabs.rundeck.core.execution.workflow.steps.StepExecutor;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepExecutionItem;
import com.dtolabs.rundeck.core.execution.workflow.steps.node.NodeStepResult;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;

public class NodeDispatchStepExecutor
implements StepExecutor {
    public static final String STEP_EXECUTION_TYPE = "NodeDispatch";
    public static final String FAILURE_DATA_FAILED_NODES = "failedNodes";

    @Override
    public boolean isNodeDispatchStep(StepExecutionItem item) {
        return true;
    }

    @Override
    public StepExecutionResult executeWorkflowStep(StepExecutionContext context, StepExecutionItem executionItem) {
        if (!(executionItem instanceof NodeStepExecutionItem)) {
            throw new IllegalArgumentException("Cannot executeWorkflowStep: step is not a NodeStepExecutionItem: " + executionItem);
        }
        NodeStepExecutionItem item = (NodeStepExecutionItem)executionItem;
        Framework framework = context.getFramework();
        try {
            return NodeDispatchStepExecutor.wrapDispatcherResult(framework.getExecutionService().dispatchToNodes(context, item));
        }
        catch (DispatcherException e) {
            return NodeDispatchStepExecutor.wrapDispatcherException(e);
        }
        catch (ExecutionServiceException e) {
            throw new CoreException(e);
        }
    }

    public static StepExecutionResult wrapDispatcherException(DispatcherException dispatcherResult) {
        NodeDispatchStepExecutorExceptionResult result = new NodeDispatchStepExecutorExceptionResult(dispatcherResult, (FailureReason)Reason.NodeDispatchFailure, dispatcherResult.getMessage());
        return result;
    }

    public static StepExecutionResult wrapDispatcherResult(DispatcherResult dispatcherResult) {
        NodeDispatchStepExecutorResult result;
        if (dispatcherResult.isSuccess()) {
            result = NodeDispatchStepExecutorResult.success(dispatcherResult);
        } else {
            result = NodeDispatchStepExecutorResult.failure(dispatcherResult, null, Reason.NodeDispatchFailure, "Node dispatch failed");
            ArrayList<String> nodeNames = new ArrayList<String>();
            for (String nodeName : dispatcherResult.getResults().keySet()) {
                NodeStepResult nodeStepResult = dispatcherResult.getResults().get(nodeName);
                if (nodeStepResult.isSuccess()) continue;
                nodeNames.add(nodeName);
            }
            if (!nodeNames.isEmpty()) {
                result.getFailureData().put(FAILURE_DATA_FAILED_NODES, StringUtils.join(nodeNames, (String)","));
            }
        }
        return result;
    }

    public static boolean isWrappedDispatcherException(StepExecutionResult result) {
        return NodeDispatchStepExecutor.extractNodeDispatchStepExecutorExceptionResult(result).isPresent();
    }

    public static Optional<NodeDispatchStepExecutorExceptionResult> extractNodeDispatchStepExecutorExceptionResult(StepExecutionResult result) {
        StepExecutionResult sourceStepExecutionResult;
        boolean isa = result instanceof NodeDispatchStepExecutorExceptionResult;
        if (isa) {
            return Optional.of((NodeDispatchStepExecutorExceptionResult)result);
        }
        if (result instanceof HasSourceStepExecutionResult && (sourceStepExecutionResult = ((HasSourceStepExecutionResult)((Object)result)).getSourceStepExecutionResult()) != null && sourceStepExecutionResult != result) {
            return NodeDispatchStepExecutor.extractNodeDispatchStepExecutorExceptionResult(sourceStepExecutionResult);
        }
        return Optional.empty();
    }

    public static boolean isWrappedDispatcherResult(StepExecutionResult result) {
        return NodeDispatchStepExecutor.extractNodeDispatchStepExecutorResult(result).isPresent();
    }

    public static Optional<NodeDispatchStepExecutorResult> extractNodeDispatchStepExecutorResult(StepExecutionResult result) {
        StepExecutionResult sourceStepExecutionResult;
        boolean isa = result instanceof NodeDispatchStepExecutorResult;
        if (isa) {
            return Optional.of((NodeDispatchStepExecutorResult)result);
        }
        if (result instanceof HasSourceStepExecutionResult && (sourceStepExecutionResult = ((HasSourceStepExecutionResult)((Object)result)).getSourceStepExecutionResult()) != null && sourceStepExecutionResult != result) {
            return NodeDispatchStepExecutor.extractNodeDispatchStepExecutorResult(sourceStepExecutionResult);
        }
        return Optional.empty();
    }

    public static DispatcherResult extractDispatcherResult(StepExecutionResult result) {
        Optional<NodeDispatchStepExecutorResult> extracted = NodeDispatchStepExecutor.extractNodeDispatchStepExecutorResult(result);
        if (!extracted.isPresent()) {
            throw new IllegalArgumentException("Cannot extract result: unexpected type: " + result);
        }
        return extracted.get().getDispatcherResult();
    }

    public static DispatcherException extractDispatcherException(StepExecutionResult result) {
        Optional<NodeDispatchStepExecutorExceptionResult> extracted = NodeDispatchStepExecutor.extractNodeDispatchStepExecutorExceptionResult(result);
        if (!extracted.isPresent()) {
            throw new IllegalArgumentException("Cannot extract result: unexpected type: " + result);
        }
        return extracted.get().getDispatcherException();
    }

    static class NodeDispatchStepExecutorExceptionResult
    extends StepExecutionResultImpl {
        DispatcherException dispatcherResult;

        NodeDispatchStepExecutorExceptionResult(DispatcherException dispatcherResult, FailureReason reason, String message) {
            super(dispatcherResult, reason, message);
            this.dispatcherResult = dispatcherResult;
        }

        public DispatcherException getDispatcherException() {
            return this.dispatcherResult;
        }
    }

    static class NodeDispatchStepExecutorResult
    extends StepExecutionResultImpl {
        DispatcherResult dispatcherResult;

        static NodeDispatchStepExecutorResult success(DispatcherResult dispatcherResult) {
            return new NodeDispatchStepExecutorResult(dispatcherResult);
        }

        static NodeDispatchStepExecutorResult failure(DispatcherResult dispatcherResult, Exception exception, FailureReason reason, String message) {
            return new NodeDispatchStepExecutorResult(dispatcherResult, exception, reason, message);
        }

        NodeDispatchStepExecutorResult(DispatcherResult dispatcherResult) {
            this.dispatcherResult = dispatcherResult;
            this.setSourceResult(dispatcherResult);
        }

        NodeDispatchStepExecutorResult(DispatcherResult dispatcherResult, Exception exception, FailureReason reason, String message) {
            super(exception, reason, message);
            this.dispatcherResult = dispatcherResult;
            this.setSourceResult(dispatcherResult);
        }

        public DispatcherResult getDispatcherResult() {
            return this.dispatcherResult;
        }

        @Override
        public String toString() {
            if (null != this.dispatcherResult) {
                return this.dispatcherResult.toString();
            }
            return super.toString();
        }
    }

    static enum Reason implements FailureReason
    {
        NodeDispatchFailure;

    }
}

