/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.resources.CachingResourceModelSource;
import com.dtolabs.rundeck.core.resources.ExceptionCatchingResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSource;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceCache;
import com.dtolabs.rundeck.core.resources.ResourceModelSourceException;

public class SourceFactory {
    public static ResourceModelSource staticSource(final INodeSet data) {
        return new ResourceModelSource(){

            @Override
            public INodeSet getNodes() throws ResourceModelSourceException {
                return data;
            }
        };
    }

    public static ResourceModelSource cachedSource(ResourceModelSource delegate, String identity, ExceptionCatchingResourceModelSource.ExceptionHandler handler, ResourceModelSourceCache cache) {
        return SourceFactory.cachedSource(delegate, identity, handler, cache, CacheType.BOTH);
    }

    public static ResourceModelSource cacheWritingSource(ResourceModelSource delegate, String identity, ExceptionCatchingResourceModelSource.ExceptionHandler handler, ResourceModelSourceCache cache) {
        return SourceFactory.cachedSource(delegate, identity, handler, cache, CacheType.STORE_ONLY);
    }

    public static ResourceModelSource cacheLoadingSource(ResourceModelSource delegate, String identity, ExceptionCatchingResourceModelSource.ExceptionHandler handler, ResourceModelSourceCache cache) {
        return SourceFactory.cachedSource(delegate, identity, handler, cache, CacheType.LOAD_ONLY);
    }

    public static ResourceModelSource cachedSource(ResourceModelSource delegate, String identity, ExceptionCatchingResourceModelSource.ExceptionHandler handler, ResourceModelSourceCache cache, CacheType type) {
        return new CachingResourceModelSource(delegate, identity, handler, cache, type);
    }

    public static enum CacheType {
        LOAD_ONLY(true, false),
        STORE_ONLY(false, true),
        BOTH(true, true);

        private final boolean storeType;
        private final boolean loadType;

        private CacheType(boolean load, boolean store) {
            this.loadType = load;
            this.storeType = store;
        }

        public boolean isStoreType() {
            return this.storeType;
        }

        public boolean isLoadType() {
            return this.loadType;
        }
    }
}

