/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.resources.format.json;

import com.dtolabs.rundeck.core.common.INodeSet;
import com.dtolabs.rundeck.core.common.NodeEntryImpl;
import com.dtolabs.rundeck.core.common.NodeSetImpl;
import com.dtolabs.rundeck.core.plugins.Plugin;
import com.dtolabs.rundeck.core.plugins.configuration.Describable;
import com.dtolabs.rundeck.core.plugins.configuration.Description;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParser;
import com.dtolabs.rundeck.core.resources.format.ResourceFormatParserException;
import com.dtolabs.rundeck.plugins.util.DescriptionBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Plugin(name="resourcejson", service="ResourceFormatParser")
public class ResourceJsonFormatParser
implements ResourceFormatParser,
Describable {
    public static final String SERVICE_PROVIDER_TYPE = "resourcejson";
    private final ObjectMapper objectMapper = new ObjectMapper();
    public static final Set<String> FILE_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Collections.singletonList("json")));
    public static final Set<String> MIME_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("application/json", "text/json")));
    private static final Description DESCRIPTION = DescriptionBuilder.builder().name("resourcejson").title("Resource JSON").description("The Rundeck Resource JSON format 1.0 (bundled)").build();

    @Override
    public Description getDescription() {
        return DESCRIPTION;
    }

    @Override
    public Set<String> getFileExtensions() {
        return FILE_EXTENSIONS;
    }

    @Override
    public String getPreferredFileExtension() {
        return "json";
    }

    @Override
    public Set<String> getMIMETypes() {
        return MIME_TYPES;
    }

    @Override
    public String getPreferredMimeType() {
        return "application/json";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public INodeSet parseDocument(File file) throws ResourceFormatParserException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            INodeSet iNodeSet = this.parseDocument(fileInputStream);
            return iNodeSet;
        }
        catch (IOException e) {
            throw new ResourceFormatParserException(e);
        }
    }

    @Override
    public INodeSet parseDocument(InputStream input) throws ResourceFormatParserException {
        try {
            return this.convertNodes(this.objectMapper.readValue(input, Object.class));
        }
        catch (IOException e) {
            throw new ResourceFormatParserException(e);
        }
    }

    private INodeSet convertNodes(Object data) throws ResourceFormatParserException {
        if (data instanceof Map) {
            return this.convertMappedNodes((Map)data);
        }
        if (data instanceof Collection) {
            return this.convertListNodes((Collection)data);
        }
        throw new ResourceFormatParserException("JSON structure expected Map or Array, but saw: " + data.getClass());
    }

    private INodeSet convertListNodes(Collection data) {
        NodeSetImpl nodeSet = new NodeSetImpl();
        for (Object value : data) {
            Map attrs;
            if (!(value instanceof Map) || !(attrs = (Map)value).containsKey("nodename")) continue;
            String nodename = attrs.get("nodename").toString();
            this.addNode(nodeSet, nodename, attrs);
        }
        return nodeSet;
    }

    private INodeSet convertMappedNodes(Map map) {
        NodeSetImpl nodeSet = new NodeSetImpl();
        for (Object o : map.keySet()) {
            if (!(o instanceof String)) continue;
            String nodename = o.toString();
            Object value = map.get(o);
            if (!(value instanceof Map)) continue;
            Map attrs = (Map)value;
            this.addNode(nodeSet, nodename, attrs);
        }
        return nodeSet;
    }

    private void addNode(NodeSetImpl nodeSet, String nodename, Map attrs) {
        NodeEntryImpl node = new NodeEntryImpl(nodename);
        Map<String, String> safe = this.safe(attrs);
        node.getAttributes().putAll(safe);
        if (safe.get("tags") != null && !"".equals(safe.get("tags").trim())) {
            node.setTags(new HashSet<String>(Arrays.asList(safe.get("tags").split(", *"))));
        } else if (attrs.get("tags") instanceof Collection) {
            node.setTags(new HashSet<String>(this.stringSet((Collection)attrs.get("tags"))));
        }
        nodeSet.putNode(node);
    }

    private Set<String> stringSet(Collection tags) {
        HashSet<String> strings = new HashSet<String>();
        for (Object tag : tags) {
            strings.add(tag.toString());
        }
        return strings;
    }

    private Map<String, String> safe(Map attrs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object o : attrs.keySet()) {
            Object val = attrs.get(o);
            if (val == null || val instanceof Collection || val instanceof Map) continue;
            map.put(o.toString(), val.toString());
        }
        return map;
    }
}

