/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.conf;

import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathSelector;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.ResourceSelector;
import org.rundeck.storage.api.Tree;
import org.rundeck.storage.conf.ContentConverter;
import org.rundeck.storage.conf.MatcherUtil;
import org.rundeck.storage.impl.DelegateResource;
import org.rundeck.storage.impl.DelegateTree;

public class ConverterTree<T extends ContentMeta>
extends DelegateTree<T> {
    ContentConverter<T> converter;
    PathSelector pathSelector;
    ResourceSelector<T> resourceSelector;

    public ConverterTree(Tree<T> delegate, ContentConverter<T> converter, PathSelector pathSelector) {
        this(delegate, converter, pathSelector, null);
    }

    public ConverterTree(Tree<T> delegate, ContentConverter<T> converter, ResourceSelector<T> resourceSelector) {
        this(delegate, converter, null, resourceSelector);
    }

    public ConverterTree(Tree<T> delegate, ContentConverter<T> converter, PathSelector pathSelector, ResourceSelector<T> resourceSelector) {
        super(delegate);
        this.converter = converter;
        this.pathSelector = pathSelector;
        this.resourceSelector = resourceSelector;
    }

    private T filterReadData(Path path, T contents) {
        return null != this.converter ? this.converter.convertReadData(path, contents) : contents;
    }

    private T filterCreateData(Path path, T contents) {
        return null != this.converter ? this.converter.convertCreateData(path, contents) : contents;
    }

    private T filterUpdateData(Path path, T content) {
        return null != this.converter ? this.converter.convertUpdateData(path, content) : content;
    }

    public Resource<T> getResource(Path path) {
        Resource resource = super.getResource(path);
        if (!resource.isDirectory() && MatcherUtil.matches(path, resource.getContents(), this.pathSelector, this.resourceSelector)) {
            return this.filterGetResource(path, resource);
        }
        return resource;
    }

    public Resource<T> getPath(Path path) {
        Resource resource = super.getPath(path);
        if (!resource.isDirectory() && MatcherUtil.matches(path, resource.getContents(), this.pathSelector, this.resourceSelector)) {
            return this.filterGetResource(path, resource);
        }
        return resource;
    }

    private Resource<T> filterGetResource(final Path path, final Resource<T> resource) {
        return new DelegateResource<T>(resource){

            public T getContents() {
                return ConverterTree.this.filterReadData(path, resource.getContents());
            }
        };
    }

    public Resource<T> createResource(Path path, T content) {
        if (MatcherUtil.matches(path, content, this.pathSelector, this.resourceSelector)) {
            Resource created = super.createResource(path, this.filterCreateData(path, content));
            return this.filterGetResource(path, created);
        }
        return super.createResource(path, content);
    }

    public Resource<T> updateResource(Path path, T content) {
        if (MatcherUtil.matches(path, content, this.pathSelector, this.resourceSelector)) {
            Resource updated = super.updateResource(path, this.filterUpdateData(path, content));
            return this.filterGetResource(path, updated);
        }
        return super.updateResource(path, content);
    }
}

