/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.conf;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.Tree;
import org.rundeck.storage.conf.SelectiveTree;
import org.rundeck.storage.impl.DelegateTree;
import org.rundeck.storage.impl.ResourceBase;

public class TreeStack<T extends ContentMeta>
extends DelegateTree<T> {
    private List<? extends SelectiveTree<T>> treeHandlerList;

    public TreeStack(List<? extends SelectiveTree<T>> treeHandlerList, Tree<T> delegate) {
        super(delegate);
        this.treeHandlerList = treeHandlerList;
    }

    public Resource<T> getResource(Path path) {
        return this.getContentStorage(path).getResource(path);
    }

    public Resource<T> getPath(Path path) {
        return this.getContentStorage(path).getPath(path);
    }

    public Set<Resource<T>> listDirectoryResources(Path path) {
        return this.getContentStorage(path).listDirectoryResources(path);
    }

    public Set<Resource<T>> listDirectory(Path path) {
        return this.merge(this.listDirectoryIfFound(path), this.listStackDirectory(path));
    }

    private Set<Resource<T>> listDirectoryIfFound(Path path) {
        if (this.getContentStorage(path).hasDirectory(path)) {
            return this.getContentStorage(path).listDirectory(path);
        }
        return null;
    }

    private Set<Resource<T>> merge(Set<Resource<T>> matchedList, Set<Resource<T>> subList) {
        HashSet<Resource<T>> merge = new HashSet<Resource<T>>();
        if (null != matchedList && matchedList.size() > 0) {
            merge.addAll(matchedList);
        }
        if (null != subList && subList.size() > 0) {
            merge.addAll(subList);
        }
        return merge;
    }

    public Set<Resource<T>> listDirectorySubdirs(Path path) {
        return this.merge(this.listDirectoryIfFound(path), this.listStackDirectory(path));
    }

    public boolean deleteResource(Path path) {
        return this.getContentStorage(path).deleteResource(path);
    }

    public Resource<T> createResource(Path path, T content) {
        return this.getContentStorage(path).createResource(path, content);
    }

    public Resource<T> updateResource(Path path, T content) {
        return this.getContentStorage(path).updateResource(path, content);
    }

    public boolean hasPath(Path path) {
        return this.getContentStorage(path).hasPath(path);
    }

    public static boolean matchesPath(Path path, SelectiveTree<?> tree) {
        return path.equals(tree.getSubPath()) || PathUtil.hasRoot((Path)path, (Path)tree.getSubPath());
    }

    public static boolean hasParentPath(Path path, SelectiveTree<?> tree) {
        return path.equals(PathUtil.parentPath((Path)tree.getSubPath()));
    }

    private Set<Resource<T>> listStackDirectory(Path path) {
        HashSet<Resource<T>> merge = new HashSet<Resource<T>>();
        if (this.treeHandlerList.size() > 0) {
            for (SelectiveTree<T> treeHandler : this.treeHandlerList) {
                if (!TreeStack.hasParentPath(path, treeHandler)) continue;
                Path subpath = PathUtil.appendPath((Path)path, (String)treeHandler.getSubPath().getName());
                merge.add((Resource<T>)new ResourceBase(subpath, null, true));
            }
        }
        return merge;
    }

    private Tree<T> getContentStorage(Path path) {
        if (this.treeHandlerList.size() > 0) {
            for (SelectiveTree<T> treeHandler : this.treeHandlerList) {
                if (!TreeStack.matchesPath(path, treeHandler)) continue;
                return treeHandler;
            }
        }
        return this.getDelegate();
    }

    public boolean hasResource(Path path) {
        return this.getContentStorage(path).hasResource(path);
    }

    public boolean hasDirectory(Path path) {
        return this.getContentStorage(path).hasDirectory(path);
    }
}

