/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.Path;
import org.rundeck.storage.api.PathItem;
import org.rundeck.storage.api.PathUtil;
import org.rundeck.storage.api.Resource;
import org.rundeck.storage.api.Tree;
import org.rundeck.storage.impl.ResourceBase;
import org.rundeck.storage.impl.StringToPathTree;

public class MemoryTree<T extends ContentMeta>
extends StringToPathTree<T>
implements Tree<T> {
    DirRes<T> root = new DirRes(PathUtil.ROOT);
    Map<Path, DirRes<T>> index = new HashMap<Path, DirRes<T>>();

    public MemoryTree() {
        this.index.put(PathUtil.asPath((String)""), this.root);
    }

    public Set<Resource<T>> listDirectorySubdirs(Path path) {
        if (!this.hasDirectory(path)) {
            throw new IllegalArgumentException("No directory for path: " + path);
        }
        return this.index.get(path).dirListDirs();
    }

    public boolean hasResource(Path path) {
        return this.hasPath(path) && !this.index.get((Object)path).dir;
    }

    public boolean hasPath(Path path) {
        return this.index.containsKey(path);
    }

    public boolean hasDirectory(Path path) {
        return this.hasPath(path) && this.index.get((Object)path).dir;
    }

    public Resource<T> getResource(Path path) {
        if (!this.hasResource(path)) {
            throw new IllegalArgumentException("No resource for path: " + path);
        }
        return this.index.get((Object)path).res;
    }

    public Resource<T> getPath(Path path) {
        if (!this.hasPath(path)) {
            throw new IllegalArgumentException("No path: " + path);
        }
        return this.index.get((Object)path).res;
    }

    public Set<Resource<T>> listDirectoryResources(Path path) {
        if (!this.hasDirectory(path)) {
            throw new IllegalArgumentException("No directory for path: " + path);
        }
        return this.index.get(path).dirListSet();
    }

    public Set<Resource<T>> listDirectory(Path path) {
        if (!this.hasDirectory(path)) {
            throw new IllegalArgumentException("No directory for path: " + path);
        }
        return this.index.get(path).dirListAll();
    }

    public boolean deleteResource(Path path) {
        if (!this.hasResource(path)) {
            return false;
        }
        DirRes<T> res = this.index.get(path);
        return this.deleteRes(res);
    }

    private boolean deleteRes(DirRes<T> dirRes) {
        boolean removed = false;
        if (!dirRes.dir) {
            MyRes res = dirRes.res;
            removed = this.index.remove(res.getPath()) != null;
            Path parentPath = PathUtil.parentPath((Path)res.getPath());
            if (!PathUtil.isRoot((Path)parentPath) && null != this.index.get(parentPath)) {
                DirRes<T> parentRes = this.index.get(parentPath);
                parentRes.dirList.remove(res.getPath());
                dirRes = parentRes;
            } else {
                return removed;
            }
        }
        while (null != dirRes && dirRes.dir && dirRes.dirList.size() < 1) {
            this.index.remove(dirRes.getPath());
            Path parentPath = PathUtil.parentPath((Path)dirRes.getPath());
            if (parentPath != null && !PathUtil.isRoot((Path)parentPath)) {
                DirRes<T> parentRes = this.index.get(parentPath);
                parentRes.dirList.remove(dirRes.getPath());
                dirRes = parentRes;
                continue;
            }
            dirRes = null;
        }
        return removed;
    }

    public Resource<T> createResource(Path path, T data) {
        if (this.hasResource(path)) {
            throw new IllegalArgumentException("Resource exists for path: " + path);
        }
        DirRes<T> newRes = this.createRes(path, data);
        return newRes.res;
    }

    public Resource<T> updateResource(Path path, T data) {
        if (!this.hasResource(path)) {
            throw new IllegalArgumentException("Resource not found for path: " + path);
        }
        DirRes<T> dirRes = this.index.get(path);
        MyRes<T> resource = dirRes.res;
        resource.setContents(data);
        return resource;
    }

    private DirRes<T> createRes(Path path, T t) {
        DirRes<T> parent = this.createParentPaths(path);
        MyRes<T> resource = new MyRes<T>(path, t, false);
        DirRes<T> dirRes = new DirRes<T>(path, resource);
        parent.dirList.put(resource.getPath(), dirRes);
        this.index.put(path, dirRes);
        return dirRes;
    }

    private DirRes<T> createParentPaths(Path path) {
        String[] split = path.getPath().split("/");
        DirRes<T> current = this.root;
        Path currentPath = PathUtil.asPath((String)"");
        for (int i = 0; i < split.length - 1; ++i) {
            if (!this.index.containsKey(currentPath = PathUtil.appendPath((Path)currentPath, (String)split[i]))) {
                DirRes newDir = new DirRes(currentPath);
                newDir.dir = true;
                current.dirList.put(currentPath, newDir);
                this.index.put(currentPath, newDir);
                current = newDir;
                continue;
            }
            current = this.index.get(currentPath);
        }
        return current;
    }

    static final class MyRes<T extends ContentMeta>
    extends ResourceBase<T> {
        MyRes(Path path, T content, boolean directory) {
            super(path, content, directory);
        }

        public void setContents(T contents) {
            super.setContents(contents);
        }
    }

    static class DirRes<T extends ContentMeta>
    implements PathItem {
        private Path path;
        boolean dir;
        MyRes<T> res;
        Map<Path, DirRes<T>> dirList;

        DirRes(Path path) {
            this.path = path;
            this.dir = true;
            this.res = new MyRes<Object>(path, null, true);
            this.dirList = new HashMap<Path, DirRes<T>>();
        }

        public Set<Resource<T>> dirListSet() {
            HashSet<Resource<T>> resources = new HashSet<Resource<T>>();
            for (DirRes<T> dirRes : this.dirList.values()) {
                if (dirRes.dir) continue;
                resources.add((Resource<T>)dirRes.res);
            }
            return resources;
        }

        public Set<Resource<T>> dirListAll() {
            HashSet<Resource<T>> dirs = new HashSet<Resource<T>>();
            for (DirRes<T> dirRes : this.dirList.values()) {
                dirs.add((Resource<T>)dirRes.res);
            }
            return dirs;
        }

        public Set<Resource<T>> dirListDirs() {
            HashSet<Resource<T>> dirs = new HashSet<Resource<T>>();
            for (DirRes<T> dirRes : this.dirList.values()) {
                if (!dirRes.dir) continue;
                dirs.add((Resource<T>)dirRes.res);
            }
            return dirs;
        }

        DirRes(Path path, MyRes<T> res) {
            this.path = path;
            this.res = res;
            this.dir = false;
        }

        public Path getPath() {
            return this.path;
        }
    }
}

