/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.storage.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.rundeck.storage.api.ContentMeta;
import org.rundeck.storage.api.HasInputStream;
import org.rundeck.storage.data.DataUtil;

public class DataContent
implements ContentMeta {
    InputStream stream;
    HasInputStream lazyStream;
    Map<String, String> meta;

    DataContent(InputStream stream, Map<String, String> meta) {
        this.stream = stream;
        this.meta = meta;
    }

    public DataContent(HasInputStream lazyStream, Map<String, String> meta) {
        this.lazyStream = lazyStream;
        this.meta = meta;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public long writeContent(OutputStream out) throws IOException {
        if (null != this.stream) {
            return DataUtil.copyStream(this.stream, out);
        }
        if (null != this.lazyStream) {
            return this.lazyStream.writeContent(out);
        }
        return -1L;
    }

    public InputStream getInputStream() throws IOException {
        if (null != this.stream) {
            return this.stream;
        }
        if (null != this.lazyStream) {
            return this.lazyStream.getInputStream();
        }
        return null;
    }
}

