/*
 * Decompiled with CFR 0.152.
 */
package org.sahli.asciidoc.confluence.publisher.client.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.message.BasicHeader;
import org.sahli.asciidoc.confluence.publisher.client.http.HttpRequestFactory;
import org.sahli.asciidoc.confluence.publisher.client.http.payloads.Ancestor;
import org.sahli.asciidoc.confluence.publisher.client.http.payloads.Body;
import org.sahli.asciidoc.confluence.publisher.client.http.payloads.Label;
import org.sahli.asciidoc.confluence.publisher.client.http.payloads.PagePayload;
import org.sahli.asciidoc.confluence.publisher.client.http.payloads.PropertyPayload;
import org.sahli.asciidoc.confluence.publisher.client.http.payloads.Space;
import org.sahli.asciidoc.confluence.publisher.client.http.payloads.Storage;
import org.sahli.asciidoc.confluence.publisher.client.http.payloads.Version;
import org.sahli.asciidoc.confluence.publisher.client.utils.AssertUtils;

class HttpRequestV1Factory
implements HttpRequestFactory {
    private static final Header APPLICATION_JSON_UTF8_HEADER = new BasicHeader("Content-Type", "application/json;charset=utf-8");
    private static final String REST_API_CONTEXT = "/rest/api";
    private static final int INITAL_VERSION = 1;
    private final String rootConfluenceUrl;
    private final String confluenceRestApiEndpoint;

    HttpRequestV1Factory(String rootConfluenceUrl) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)rootConfluenceUrl), "rootConfluenceUrl");
        this.rootConfluenceUrl = rootConfluenceUrl;
        this.confluenceRestApiEndpoint = rootConfluenceUrl + REST_API_CONTEXT;
    }

    @Override
    public HttpPost addPageUnderAncestorRequest(String spaceKey, String ancestorId, String title, String content, String versionMessage) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)spaceKey), "spaceKey");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)ancestorId), "ancestorId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)title), "title");
        PagePayload pagePayload = PagePayloadBuilder.pagePayloadBuilder().spaceKey(spaceKey).ancestorId(ancestorId).title(title).content(content).version(1).versionMessage(versionMessage).notifyWatchers(true).build();
        return HttpRequestV1Factory.addPageHttpPost(this.confluenceRestApiEndpoint, pagePayload);
    }

    @Override
    public HttpPut updatePageRequest(String contentId, String ancestorId, String title, String content, int newVersion, String versionMessage, boolean notifyWatchers) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)title), "title");
        PagePayload pagePayload = PagePayloadBuilder.pagePayloadBuilder().ancestorId(ancestorId).title(title).content(content).version(newVersion).versionMessage(versionMessage).notifyWatchers(notifyWatchers).build();
        HttpPut updatePageRequest = new HttpPut(this.confluenceRestApiEndpoint + "/content/" + contentId);
        updatePageRequest.setEntity((HttpEntity)HttpRequestV1Factory.httpEntityWithJsonPayload(pagePayload));
        updatePageRequest.addHeader(APPLICATION_JSON_UTF8_HEADER);
        return updatePageRequest;
    }

    @Override
    public HttpDelete deletePageRequest(String contentId) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        return new HttpDelete(this.confluenceRestApiEndpoint + "/content/" + contentId);
    }

    @Override
    public HttpPost addAttachmentRequest(String contentId, String attachmentFileName, InputStream attachmentContent) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)attachmentFileName), "attachmentFileName");
        AssertUtils.assertMandatoryParameter(attachmentContent != null, "attachmentContent");
        HttpPost attachmentPostRequest = new HttpPost(this.confluenceRestApiEndpoint + "/content/" + contentId + "/child/attachment");
        attachmentPostRequest.addHeader((Header)new BasicHeader("X-Atlassian-Token", "no-check"));
        HttpEntity multipartEntity = HttpRequestV1Factory.multipartEntity(attachmentFileName, attachmentContent, false);
        attachmentPostRequest.setEntity(multipartEntity);
        return attachmentPostRequest;
    }

    @Override
    public HttpPost updateAttachmentContentRequest(String contentId, String attachmentId, InputStream attachmentContent, boolean notifyWatchers) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)attachmentId), "attachmentId");
        AssertUtils.assertMandatoryParameter(attachmentContent != null, "attachmentContent");
        HttpPost attachmentPostRequest = new HttpPost(this.confluenceRestApiEndpoint + "/content/" + contentId + "/child/attachment/" + attachmentId + "/data");
        attachmentPostRequest.addHeader((Header)new BasicHeader("X-Atlassian-Token", "no-check"));
        HttpEntity multipartEntity = HttpRequestV1Factory.multipartEntity(null, attachmentContent, notifyWatchers);
        attachmentPostRequest.setEntity(multipartEntity);
        return attachmentPostRequest;
    }

    @Override
    public HttpDelete deleteAttachmentRequest(String attachmentId) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)attachmentId), "attachmentId");
        return new HttpDelete(this.confluenceRestApiEndpoint + "/content/" + attachmentId);
    }

    @Override
    public HttpGet getPageByTitleRequest(String spaceKey, String title) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)spaceKey), "spaceKey");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)title), "title");
        String searchQuery = this.confluenceRestApiEndpoint + "/content?spaceKey=" + spaceKey + "&title=" + HttpRequestV1Factory.urlEncode(title) + "&expand=ancestors";
        return new HttpGet(searchQuery);
    }

    @Override
    public HttpGet getAttachmentByFileNameRequest(String contentId, String attachmentFileName, String expandOptions) {
        HttpGet getAttachmentByFileNameRequest;
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)attachmentFileName), "attachmentFileName");
        URIBuilder uriBuilder = HttpRequestV1Factory.createUriBuilder(this.confluenceRestApiEndpoint + "/content/" + contentId + "/child/attachment");
        uriBuilder.addParameter("filename", attachmentFileName);
        if (StringUtils.isNotBlank((CharSequence)expandOptions)) {
            uriBuilder.addParameter("expand", expandOptions);
        }
        try {
            getAttachmentByFileNameRequest = new HttpGet(uriBuilder.build().toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URL", e);
        }
        return getAttachmentByFileNameRequest;
    }

    private static URIBuilder createUriBuilder(String path) {
        try {
            return new URIBuilder(path);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to parse path as URI: " + path, e);
        }
    }

    @Override
    public HttpGet getPageByIdRequest(String contentId, String expandOptions) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        return new HttpGet(this.confluenceRestApiEndpoint + "/content/" + contentId + "?expand=" + expandOptions);
    }

    @Override
    public HttpGet getChildPagesByIdRequest(String parentContentId, Integer limit, Integer start, String expandOptions) {
        HttpGet getChildPagesByIdRequest;
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)parentContentId), "parentContentId");
        URIBuilder uriBuilder = HttpRequestV1Factory.createUriBuilder(this.confluenceRestApiEndpoint + "/content/" + parentContentId + "/child/page");
        if (limit != null) {
            uriBuilder.addParameter("limit", limit.toString());
        }
        if (start != null) {
            uriBuilder.addParameter("start", start.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)expandOptions)) {
            uriBuilder.addParameter("expand", expandOptions);
        }
        try {
            getChildPagesByIdRequest = new HttpGet(uriBuilder.build().toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URL", e);
        }
        return getChildPagesByIdRequest;
    }

    @Override
    public HttpGet getAttachmentsRequest(String contentId, Integer limit, Integer start, String expandOptions) {
        HttpGet getAttachmentsRequest;
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        URIBuilder uriBuilder = HttpRequestV1Factory.createUriBuilder(this.confluenceRestApiEndpoint + "/content/" + contentId + "/child/attachment");
        if (limit != null) {
            uriBuilder.addParameter("limit", limit.toString());
        }
        if (start != null) {
            uriBuilder.addParameter("start", start.toString());
        }
        if (StringUtils.isNotBlank((CharSequence)expandOptions)) {
            uriBuilder.addParameter("expand", expandOptions);
        }
        try {
            getAttachmentsRequest = new HttpGet(uriBuilder.build().toString());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid URL", e);
        }
        return getAttachmentsRequest;
    }

    @Override
    public HttpGet getAttachmentContentRequest(String relativeDownloadLink) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)relativeDownloadLink), "relativeDownloadLink");
        return new HttpGet(this.rootConfluenceUrl + relativeDownloadLink);
    }

    @Override
    public HttpGet getPropertyByKeyRequest(String contentId, String key) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)key), "key");
        return new HttpGet(this.confluenceRestApiEndpoint + "/content/" + contentId + "/property/" + HttpRequestV1Factory.urlEncode(key) + "?expand=value");
    }

    @Override
    public HttpDelete deletePropertyByKeyRequest(String contentId, String key) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)key), "key");
        return new HttpDelete(this.confluenceRestApiEndpoint + "/content/" + contentId + "/property/" + HttpRequestV1Factory.urlEncode(key));
    }

    @Override
    public HttpPost setPropertyByKeyRequest(String contentId, String key, String value) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)key), "key");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)value), "value");
        PropertyPayload propertyPayload = new PropertyPayload();
        propertyPayload.setKey(HttpRequestV1Factory.urlEncode(key));
        propertyPayload.setValue(value);
        HttpPost postRequest = new HttpPost(this.confluenceRestApiEndpoint + "/content/" + contentId + "/property");
        postRequest.setEntity((HttpEntity)HttpRequestV1Factory.httpEntityWithJsonPayload(propertyPayload));
        postRequest.addHeader(APPLICATION_JSON_UTF8_HEADER);
        return postRequest;
    }

    @Override
    public HttpGet getLabelsRequest(String contentId) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        return new HttpGet(this.confluenceRestApiEndpoint + "/content/" + contentId + "/label");
    }

    @Override
    public HttpPost addLabelsRequest(String contentId, List<String> labels) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(!labels.isEmpty(), "labels");
        List payload = labels.stream().map(Label::new).collect(Collectors.toList());
        HttpPost addLabelsRequest = new HttpPost(this.confluenceRestApiEndpoint + "/content/" + contentId + "/label");
        addLabelsRequest.setEntity((HttpEntity)HttpRequestV1Factory.httpEntityWithJsonPayload(payload));
        addLabelsRequest.addHeader(APPLICATION_JSON_UTF8_HEADER);
        return addLabelsRequest;
    }

    @Override
    public HttpDelete deleteLabelRequest(String contentId, String label) {
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)contentId), "contentId");
        AssertUtils.assertMandatoryParameter(StringUtils.isNotBlank((CharSequence)label), "label");
        return new HttpDelete(this.confluenceRestApiEndpoint + "/content/" + contentId + "/label?name=" + HttpRequestV1Factory.urlEncode(label));
    }

    private static HttpPost addPageHttpPost(String confluenceRestApiEndpoint, PagePayload pagePayload) {
        HttpPost postRequest = new HttpPost(confluenceRestApiEndpoint + "/content");
        postRequest.setEntity((HttpEntity)HttpRequestV1Factory.httpEntityWithJsonPayload(pagePayload));
        postRequest.addHeader(APPLICATION_JSON_UTF8_HEADER);
        return postRequest;
    }

    private static BasicHttpEntity httpEntityWithJsonPayload(Object payload) {
        String jsonPayload = HttpRequestV1Factory.toJsonString(payload);
        BasicHttpEntity entity = new BasicHttpEntity();
        entity.setContent((InputStream)new ByteArrayInputStream(jsonPayload.getBytes(StandardCharsets.UTF_8)));
        return entity;
    }

    private static String toJsonString(Object objectToConvert) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            return objectMapper.writeValueAsString(objectToConvert);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error while converting object to JSON", e);
        }
    }

    private static HttpEntity multipartEntity(String attachmentFileName, InputStream attachmentContent, boolean notifyWatchers) {
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        multipartEntityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        multipartEntityBuilder.setCharset(StandardCharsets.UTF_8);
        InputStreamBody inputStreamBody = StringUtils.isNotBlank((CharSequence)attachmentFileName) ? new InputStreamBody(attachmentContent, ContentType.APPLICATION_OCTET_STREAM, attachmentFileName) : new InputStreamBody(attachmentContent, ContentType.APPLICATION_OCTET_STREAM);
        multipartEntityBuilder.addPart("file", (ContentBody)inputStreamBody);
        if (!notifyWatchers) {
            multipartEntityBuilder.addPart("minorEdit", (ContentBody)new StringBody("true", ContentType.DEFAULT_TEXT));
        }
        return multipartEntityBuilder.build();
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Could not url-encode value '" + value + "'", e);
        }
    }

    static class PagePayloadBuilder {
        private String title;
        private String content;
        private String spaceKey;
        private String ancestorId;
        private Integer version;
        private String versionMessage;
        private boolean notifyWatchers;

        PagePayloadBuilder() {
        }

        public PagePayloadBuilder title(String title) {
            this.title = title;
            return this;
        }

        public PagePayloadBuilder content(String content) {
            this.content = content;
            return this;
        }

        public PagePayloadBuilder spaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
            return this;
        }

        public PagePayloadBuilder ancestorId(String ancestorId) {
            this.ancestorId = ancestorId;
            return this;
        }

        public PagePayloadBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public PagePayloadBuilder versionMessage(String versionMessage) {
            this.versionMessage = versionMessage;
            return this;
        }

        public PagePayloadBuilder notifyWatchers(boolean notifyWatchers) {
            this.notifyWatchers = notifyWatchers;
            return this;
        }

        private PagePayload build() {
            Storage storage = new Storage();
            storage.setValue(this.content);
            Body body = new Body();
            body.setStorage(storage);
            PagePayload pagePayload = new PagePayload();
            pagePayload.setBody(body);
            pagePayload.setTitle(this.title);
            if (StringUtils.isNotBlank((CharSequence)this.spaceKey)) {
                Space space = new Space();
                space.setKey(this.spaceKey);
                pagePayload.setSpace(space);
            }
            if (StringUtils.isNotBlank((CharSequence)this.ancestorId)) {
                Ancestor ancestor = new Ancestor();
                ancestor.setId(this.ancestorId);
                pagePayload.addAncestor(ancestor);
            }
            if (this.version != null) {
                Version versionContainer = new Version();
                versionContainer.setNumber(this.version);
                if (this.versionMessage != null) {
                    versionContainer.setMessage(this.versionMessage);
                }
                if (!this.notifyWatchers) {
                    versionContainer.setMinorEdit(true);
                }
                pagePayload.setVersion(versionContainer);
            }
            return pagePayload;
        }

        static PagePayloadBuilder pagePayloadBuilder() {
            return new PagePayloadBuilder();
        }
    }
}

